/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.serialization.Serializer;
import voldemort.serialization.SlopSerializer;
import voldemort.store.Store;
import voldemort.store.UnreachableStoreException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.store.routed.Response;
import voldemort.store.slop.Slop;
import voldemort.store.slop.strategy.HintedHandoffStrategy;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintedHandoff {
    private static final Logger logger = Logger.getLogger(HintedHandoff.class);
    private static final Serializer<Slop> slopSerializer = new SlopSerializer();
    private final FailureDetector failureDetector;
    private final Map<Integer, Store<ByteArray, Slop, byte[]>> slopStores;
    private final Map<Integer, NonblockingStore> nonblockingSlopStores;
    private final HintedHandoffStrategy handoffStrategy;
    private final List<Node> failedNodes;
    private final long timeoutMs;

    public HintedHandoff(FailureDetector failureDetector, Map<Integer, Store<ByteArray, Slop, byte[]>> slopStores, Map<Integer, NonblockingStore> nonblockingSlopStores, HintedHandoffStrategy handoffStrategy, List<Node> failedNodes, long timeoutMs) {
        this.failureDetector = failureDetector;
        this.slopStores = slopStores;
        this.nonblockingSlopStores = nonblockingSlopStores;
        this.handoffStrategy = handoffStrategy;
        this.failedNodes = failedNodes;
        this.timeoutMs = timeoutMs;
    }

    public void sendHintParallel(final Node failedNode, final Version version, final Slop slop) {
        final ByteArray slopKey = slop.makeKey();
        Versioned<byte[]> slopVersioned = new Versioned<byte[]>(slopSerializer.toBytes(slop), version);
        for (final Node node : this.handoffStrategy.routeHint(failedNode)) {
            int nodeId = node.getId();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Sending an async hint to " + nodeId));
            }
            if (this.failedNodes.contains(node) || !this.failureDetector.isAvailable(node)) continue;
            NonblockingStore nonblockingStore = this.nonblockingSlopStores.get(nodeId);
            Utils.notNull(nonblockingStore);
            final long startNs = System.nanoTime();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Attempt to write " + slop.getKey() + " for " + failedNode + " to node " + node));
            }
            NonblockingStoreCallback callback = new NonblockingStoreCallback(){

                public void requestComplete(Object result, long requestTime) {
                    Response<ByteArray, Object> response = new Response<ByteArray, Object>(node, slopKey, result, requestTime);
                    if (response.getValue() instanceof Exception) {
                        if (!(response.getValue() instanceof ObsoleteVersionException)) {
                            if (!HintedHandoff.this.failedNodes.contains(node)) {
                                HintedHandoff.this.failedNodes.add(node);
                            }
                            if (response.getValue() instanceof UnreachableStoreException) {
                                UnreachableStoreException use = (UnreachableStoreException)response.getValue();
                                HintedHandoff.this.failureDetector.recordException(node, (System.nanoTime() - startNs) / 1000000L, use);
                            }
                            HintedHandoff.this.sendHintSerial(failedNode, version, slop);
                        }
                        return;
                    }
                    HintedHandoff.this.failureDetector.recordSuccess(node, (System.nanoTime() - startNs) / 1000000L);
                }
            };
            nonblockingStore.submitPutRequest(slopKey, slopVersioned, null, callback, this.timeoutMs);
            break;
        }
    }

    public boolean sendHintSerial(Node failedNode, Version version, Slop slop) {
        boolean persisted = false;
        for (Node node : this.handoffStrategy.routeHint(failedNode)) {
            int nodeId = node.getId();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Trying to send hint to " + nodeId));
            }
            if (this.failedNodes.contains(node) || !this.failureDetector.isAvailable(node)) continue;
            Store<ByteArray, Slop, byte[]> slopStore = this.slopStores.get(nodeId);
            Utils.notNull(slopStore);
            long startNs = System.nanoTime();
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Attempt to handoff " + (Object)((Object)slop.getOperation()) + " on " + slop.getKey() + " for " + failedNode + " to node " + node));
                }
                slopStore.put(slop.makeKey(), new Versioned<Slop>(slop, version), null);
                persisted = true;
                this.failureDetector.recordSuccess(node, (System.nanoTime() - startNs) / 1000000L);
                if (!logger.isTraceEnabled()) break;
                logger.trace((Object)("Finished hinted handoff for " + failedNode + " wrote slop to " + node));
                break;
            }
            catch (UnreachableStoreException e) {
                this.failureDetector.recordException(node, (System.nanoTime() - startNs) / 1000000L, e);
                logger.warn((Object)"Error during hinted handoff", (Throwable)e);
            }
            catch (ObsoleteVersionException e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return persisted;
    }
}

