/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.List;
import java.util.Map;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.Store;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PutPipelineData;
import voldemort.store.routed.action.AbstractKeyBasedAction;
import voldemort.utils.ByteArray;
import voldemort.utils.Time;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformSerialPutRequests
extends AbstractKeyBasedAction<ByteArray, Void, PutPipelineData> {
    private final FailureDetector failureDetector;
    private final int required;
    private final Map<Integer, Store<ByteArray, byte[], byte[]>> stores;
    private final Versioned<byte[]> versioned;
    private final Time time;
    private final Pipeline.Event masterDeterminedEvent;
    private byte[] transforms;

    public PerformSerialPutRequests(PutPipelineData pipelineData, Pipeline.Event completeEvent, ByteArray key, byte[] transforms, FailureDetector failureDetector, Map<Integer, Store<ByteArray, byte[], byte[]>> stores, int required, Versioned<byte[]> versioned, Time time, Pipeline.Event masterDeterminedEvent) {
        super(pipelineData, completeEvent, key);
        this.failureDetector = failureDetector;
        this.stores = stores;
        this.required = required;
        this.versioned = versioned;
        this.time = time;
        this.transforms = transforms;
        this.masterDeterminedEvent = masterDeterminedEvent;
    }

    @Override
    public void execute(Pipeline pipeline) {
        int currentNode = 0;
        List<Node> nodes = ((PutPipelineData)this.pipelineData).getNodes();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Performing serial put requests to determine master");
        }
        while (currentNode < nodes.size()) {
            Node node = nodes.get(currentNode);
            ((PutPipelineData)this.pipelineData).incrementNodeIndex();
            VectorClock versionedClock = (VectorClock)this.versioned.getVersion();
            Versioned<byte[]> versionedCopy = new Versioned<byte[]>(this.versioned.getValue(), versionedClock.incremented(node.getId(), this.time.getMilliseconds()));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempt #" + (currentNode + 1) + " to perform put (node " + node.getId() + ")"));
            }
            long start = System.nanoTime();
            try {
                this.stores.get(node.getId()).put((ByteArray)this.key, versionedCopy, this.transforms);
                long requestTime = (System.nanoTime() - start) / 1000000L;
                ((PutPipelineData)this.pipelineData).incrementSuccesses();
                this.failureDetector.recordSuccess(node, requestTime);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Put on node " + node.getId() + " succeeded, using as master"));
                }
                ((PutPipelineData)this.pipelineData).setMaster(node);
                ((PutPipelineData)this.pipelineData).setVersionedCopy(versionedCopy);
                ((PutPipelineData)this.pipelineData).getZoneResponses().add(node.getZoneId());
                break;
            }
            catch (Exception e) {
                long requestTime = (System.nanoTime() - start) / 1000000L;
                if (this.handleResponseError(e, node, requestTime, pipeline, this.failureDetector)) {
                    return;
                }
                ++currentNode;
            }
        }
        if (((PutPipelineData)this.pipelineData).getSuccesses() < 1) {
            List<Exception> failures = ((PutPipelineData)this.pipelineData).getFailures();
            ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException("No master node succeeded!", failures.size() > 0 ? failures.get(0) : null));
            pipeline.abort();
            return;
        }
        if (++currentNode == nodes.size()) {
            if (((PutPipelineData)this.pipelineData).getSuccesses() < this.required) {
                ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException(this.required + " " + pipeline.getOperation().getSimpleName() + "s required, but only " + ((PutPipelineData)this.pipelineData).getSuccesses() + " succeeded", ((PutPipelineData)this.pipelineData).getFailures()));
                pipeline.abort();
            } else if (((PutPipelineData)this.pipelineData).getZonesRequired() != null) {
                int zonesSatisfied = ((PutPipelineData)this.pipelineData).getZoneResponses().size();
                if (zonesSatisfied >= ((PutPipelineData)this.pipelineData).getZonesRequired() + 1) {
                    pipeline.addEvent(this.completeEvent);
                } else {
                    ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientZoneResponsesException(((PutPipelineData)this.pipelineData).getZonesRequired() + 1 + " " + pipeline.getOperation().getSimpleName() + "s required zone, but only " + zonesSatisfied + " succeeded"));
                    pipeline.abort();
                }
            } else {
                pipeline.addEvent(this.completeEvent);
            }
        } else {
            pipeline.addEvent(this.masterDeterminedEvent);
        }
    }
}

