/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.Store;
import voldemort.store.routed.GetAllPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.AbstractAction;
import voldemort.utils.ByteArray;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformSerialGetAllRequests
extends AbstractAction<Iterable<ByteArray>, Map<ByteArray, List<Versioned<byte[]>>>, GetAllPipelineData> {
    private final Iterable<ByteArray> keys;
    private final FailureDetector failureDetector;
    private final Map<Integer, Store<ByteArray, byte[], byte[]>> stores;
    private final int preferred;
    private final int required;

    public PerformSerialGetAllRequests(GetAllPipelineData pipelineData, Pipeline.Event completeEvent, Iterable<ByteArray> keys, FailureDetector failureDetector, Map<Integer, Store<ByteArray, byte[], byte[]>> stores, int preferred, int required) {
        super(pipelineData, completeEvent);
        this.keys = keys;
        this.failureDetector = failureDetector;
        this.stores = stores;
        this.preferred = preferred;
        this.required = required;
    }

    @Override
    public void execute(Pipeline pipeline) {
        Map<ByteArray, List<Versioned<byte[]>>> result = ((GetAllPipelineData)this.pipelineData).getResult();
        block2: for (ByteArray key : this.keys) {
            boolean zoneRequirement = false;
            MutableInt successCount = ((GetAllPipelineData)this.pipelineData).getSuccessCount(key);
            if (successCount.intValue() >= this.preferred) {
                if (((GetAllPipelineData)this.pipelineData).getZonesRequired() == null) continue;
                if (((GetAllPipelineData)this.pipelineData).getKeyToZoneResponse().containsKey(key)) {
                    int zonesSatisfied = ((GetAllPipelineData)this.pipelineData).getKeyToZoneResponse().get(key).size();
                    if (zonesSatisfied >= ((GetAllPipelineData)this.pipelineData).getZonesRequired() + 1) continue;
                    zoneRequirement = true;
                } else {
                    zoneRequirement = true;
                }
            }
            List<Node> extraNodes = ((GetAllPipelineData)this.pipelineData).getKeyToExtraNodesMap().get(key);
            Map<ByteArray, byte[]> transforms = ((GetAllPipelineData)this.pipelineData).getTransforms();
            if (extraNodes == null) continue;
            for (Node node : extraNodes) {
                long start = System.nanoTime();
                try {
                    Store<ByteArray, byte[], byte[]> store = this.stores.get(node.getId());
                    List<Versioned<byte[]>> values = transforms == null ? store.get(key, null) : store.get(key, transforms.get(key));
                    if (result.get(key) == null) {
                        result.put(key, Lists.newArrayList(values));
                    } else {
                        result.get(key).addAll(values);
                    }
                    HashMap<ByteArray, List<Versioned<byte[]>>> map = new HashMap<ByteArray, List<Versioned<byte[]>>>();
                    map.put(key, values);
                    Response response = new Response(node, Arrays.asList(key), map, (System.nanoTime() - start) / 1000000L);
                    successCount.increment();
                    ((GetAllPipelineData)this.pipelineData).getResponses().add(response);
                    this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
                    HashSet<Object> zoneResponses = null;
                    zoneResponses = ((GetAllPipelineData)this.pipelineData).getKeyToZoneResponse().containsKey(key) ? ((GetAllPipelineData)this.pipelineData).getKeyToZoneResponse().get(key) : new HashSet<Integer>();
                    zoneResponses.add(response.getNode().getZoneId());
                    if (!(zoneRequirement ? zoneResponses.size() >= ((GetAllPipelineData)this.pipelineData).getZonesRequired() : successCount.intValue() >= this.preferred)) continue;
                    continue block2;
                }
                catch (Exception e) {
                    long requestTime = (System.nanoTime() - start) / 1000000L;
                    if (!this.handleResponseError(e, node, requestTime, pipeline, this.failureDetector)) continue;
                    return;
                }
            }
        }
        for (ByteArray key : this.keys) {
            MutableInt successCount = ((GetAllPipelineData)this.pipelineData).getSuccessCount(key);
            if (successCount.intValue() >= this.required) continue;
            ((GetAllPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException(this.required + " " + pipeline.getOperation().getSimpleName() + "s required, but " + successCount.intValue() + " succeeded", ((GetAllPipelineData)this.pipelineData).getFailures()));
            pipeline.addEvent(Pipeline.Event.ERROR);
            return;
        }
        pipeline.addEvent(this.completeEvent);
    }
}

