/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InvalidMetadataException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.store.routed.GetAllPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.AbstractAction;
import voldemort.utils.ByteArray;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformParallelGetAllRequests
extends AbstractAction<Iterable<ByteArray>, Map<ByteArray, List<Versioned<byte[]>>>, GetAllPipelineData> {
    private final long timeoutMs;
    private final Map<Integer, NonblockingStore> nonblockingStores;
    private final FailureDetector failureDetector;

    public PerformParallelGetAllRequests(GetAllPipelineData pipelineData, Pipeline.Event completeEvent, FailureDetector failureDetector, long timeoutMs, Map<Integer, NonblockingStore> nonblockingStores) {
        super(pipelineData, completeEvent);
        this.failureDetector = failureDetector;
        this.timeoutMs = timeoutMs;
        this.nonblockingStores = nonblockingStores;
    }

    @Override
    public void execute(final Pipeline pipeline) {
        ConcurrentHashMap responses;
        block11: {
            int attempts = ((GetAllPipelineData)this.pipelineData).getNodeToKeysMap().size();
            responses = new ConcurrentHashMap();
            final CountDownLatch latch = new CountDownLatch(attempts);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting " + attempts + " " + pipeline.getOperation().getSimpleName() + " operations in parallel"));
            }
            Map<ByteArray, byte[]> transforms = ((GetAllPipelineData)this.pipelineData).getTransforms();
            for (Map.Entry<Node, List<ByteArray>> entry : ((GetAllPipelineData)this.pipelineData).getNodeToKeysMap().entrySet()) {
                final Node node = entry.getKey();
                final Collection keys = entry.getValue();
                NonblockingStoreCallback callback = new NonblockingStoreCallback(){

                    public void requestComplete(Object result, long requestTime) {
                        if (PerformParallelGetAllRequests.this.logger.isTraceEnabled()) {
                            PerformParallelGetAllRequests.this.logger.trace((Object)(pipeline.getOperation().getSimpleName() + " response received (" + requestTime + " ms.) from node " + node.getId()));
                        }
                        Response<Collection, Object> response = new Response<Collection, Object>(node, keys, result, requestTime);
                        responses.put(node.getId(), response);
                        latch.countDown();
                        if (pipeline.isFinished() && response.getValue() instanceof Exception) {
                            if (response.getValue() instanceof InvalidMetadataException) {
                                PerformParallelGetAllRequests.this.logger.warn((Object)("Received invalid metadata problem after a successful " + pipeline.getOperation().getSimpleName() + " call on node " + node.getId() + ", store '" + ((GetAllPipelineData)PerformParallelGetAllRequests.this.pipelineData).getStoreName() + "'"));
                            } else {
                                PerformParallelGetAllRequests.this.handleResponseError(response, pipeline, PerformParallelGetAllRequests.this.failureDetector);
                            }
                        }
                    }
                };
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Submitting " + pipeline.getOperation().getSimpleName() + " request on node " + node.getId()));
                }
                NonblockingStore store = this.nonblockingStores.get(node.getId());
                store.submitGetAllRequest(keys, transforms, callback, this.timeoutMs);
            }
            try {
                latch.await(this.timeoutMs * 3L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block11;
                this.logger.warn((Object)e, (Throwable)e);
            }
        }
        for (Response response : responses.values()) {
            if (response.getValue() instanceof Exception) {
                if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                return;
            }
            Map values = (Map)response.getValue();
            for (ByteArray key : (Iterable)response.getKey()) {
                MutableInt successCount = ((GetAllPipelineData)this.pipelineData).getSuccessCount(key);
                successCount.increment();
                List retrieved = (List)values.get(key);
                if (retrieved != null) {
                    List<Versioned<byte[]>> existing = ((GetAllPipelineData)this.pipelineData).getResult().get(key);
                    if (existing == null) {
                        ((GetAllPipelineData)this.pipelineData).getResult().put(key, Lists.newArrayList((Iterable)retrieved));
                    } else {
                        existing.addAll(retrieved);
                    }
                }
                HashSet<Integer> zoneResponses = null;
                zoneResponses = ((GetAllPipelineData)this.pipelineData).getKeyToZoneResponse().containsKey(key) ? ((GetAllPipelineData)this.pipelineData).getKeyToZoneResponse().get(key) : new HashSet<Integer>();
                zoneResponses.add(response.getNode().getZoneId());
            }
            ((GetAllPipelineData)this.pipelineData).getResponses().add(new Response(response.getNode(), response.getKey(), values, response.getRequestTime()));
            this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
        }
        pipeline.addEvent(this.completeEvent);
    }
}

