/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.cluster.Zone;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.routing.RoutingStrategy;
import voldemort.store.routed.BasicPipelineData;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.action.AbstractConfigureNodes;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureNodes<V, PD extends BasicPipelineData<V>>
extends AbstractConfigureNodes<ByteArray, V, PD> {
    private final ByteArray key;
    private final Zone clientZone;

    public ConfigureNodes(PD pipelineData, Pipeline.Event completeEvent, FailureDetector failureDetector, int required, RoutingStrategy routingStrategy, ByteArray key, Zone clientZone) {
        super(pipelineData, completeEvent, failureDetector, required, routingStrategy);
        this.key = key;
        this.clientZone = clientZone;
    }

    @Override
    public void execute(Pipeline pipeline) {
        List<Node> nodes = null;
        try {
            nodes = this.getNodes(this.key);
        }
        catch (VoldemortException e) {
            ((BasicPipelineData)this.pipelineData).setFatalError(e);
            pipeline.abort();
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding " + nodes.size() + " node(s) to preference list"));
        }
        if (((BasicPipelineData)this.pipelineData).getZonesRequired() != null) {
            List clientZoneNodes;
            if (((BasicPipelineData)this.pipelineData).getZonesRequired() > this.clientZone.getProximityList().size()) {
                throw new VoldemortException("Number of zones required should be less than the total number of zones");
            }
            if (((BasicPipelineData)this.pipelineData).getZonesRequired() > this.required) {
                throw new VoldemortException("Number of zones required should be less than the required number of " + pipeline.getOperation().getSimpleName() + "s");
            }
            HashMap zoneIdToNode = new HashMap();
            for (Node node : nodes) {
                List<Node> nodesList = null;
                if (zoneIdToNode.containsKey(node.getZoneId())) {
                    nodesList = (List)zoneIdToNode.get(node.getZoneId());
                } else {
                    nodesList = new ArrayList();
                    zoneIdToNode.put(node.getZoneId(), nodesList);
                }
                nodesList.add(node);
            }
            nodes = new ArrayList<Node>();
            LinkedList<Integer> zoneProximityList = this.clientZone.getProximityList();
            if (pipeline.getOperation() != Pipeline.Operation.PUT) {
                for (int index = 0; index < ((BasicPipelineData)this.pipelineData).getZonesRequired(); ++index) {
                    List zoneNodes = (List)zoneIdToNode.get(zoneProximityList.get(index));
                    if (zoneNodes == null || zoneNodes.size() <= 0) continue;
                    nodes.add((Node)zoneNodes.remove(0));
                }
            }
            if ((clientZoneNodes = (List)zoneIdToNode.get(this.clientZone.getId())) != null && clientZoneNodes.size() > 0) {
                nodes.addAll(clientZoneNodes);
            }
            for (int index = 0; index < zoneProximityList.size(); ++index) {
                List zoneNodes = (List)zoneIdToNode.get(zoneProximityList.get(index));
                if (zoneNodes == null || zoneNodes.size() <= 0) continue;
                nodes.addAll(zoneNodes);
            }
        }
        ((BasicPipelineData)this.pipelineData).setNodes(nodes);
        pipeline.addEvent(this.completeEvent);
    }
}

