/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortApplicationException;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.UnreachableStoreException;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PipelineData;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.Action;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAction<K, V, PD extends PipelineData<K, V>>
implements Action {
    protected final PD pipelineData;
    protected final Pipeline.Event completeEvent;
    protected final Logger logger = Logger.getLogger(this.getClass());

    protected AbstractAction(PD pipelineData, Pipeline.Event completeEvent) {
        this.pipelineData = (PipelineData)Utils.notNull(pipelineData);
        this.completeEvent = Utils.notNull(completeEvent);
    }

    protected boolean handleResponseError(Response<?, ?> response, Pipeline pipeline, FailureDetector failureDetector) {
        return this.handleResponseError((Exception)response.getValue(), response.getNode(), response.getRequestTime(), pipeline, failureDetector);
    }

    protected boolean handleResponseError(Exception e, Node node, long requestTime, Pipeline pipeline, FailureDetector failureDetector) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)("Error in " + pipeline.getOperation().getSimpleName() + " on node " + node.getId() + "(" + node.getHost() + ")"), (Throwable)e);
        }
        if (e instanceof UnreachableStoreException) {
            ((PipelineData)this.pipelineData).addFailedNode(node);
            ((PipelineData)this.pipelineData).recordFailure(e);
            failureDetector.recordException(node, requestTime, (UnreachableStoreException)e);
        } else {
            if (e instanceof VoldemortApplicationException) {
                ((PipelineData)this.pipelineData).setFatalError((VoldemortApplicationException)e);
                pipeline.abort();
                if (this.logger.isEnabledFor((Priority)Level.TRACE)) {
                    this.logger.trace((Object)"Error is terminal - aborting further pipeline processing");
                }
                return true;
            }
            ((PipelineData)this.pipelineData).recordFailure(e);
        }
        return false;
    }
}

