/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.mutable.MutableInt;
import voldemort.VoldemortApplicationException;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.store.routed.NodeValue;
import voldemort.store.routed.RoutedStore;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolRoutedStore
extends RoutedStore {
    private static final StoreOp<Versioned<byte[]>> VERSIONED_OP = new StoreOp<Versioned<byte[]>>(){

        @Override
        public List<Versioned<byte[]>> execute(Store<ByteArray, byte[], byte[]> store, ByteArray key, byte[] transforms) {
            return store.get(key, transforms);
        }
    };
    private static final StoreOp<Version> VERSION_OP = new StoreOp<Version>(){

        @Override
        public List<Version> execute(Store<ByteArray, byte[], byte[]> store, ByteArray key, byte[] transforms) {
            return store.getVersions(key);
        }
    };
    private final ExecutorService executor;

    public ThreadPoolRoutedStore(String name, Map<Integer, Store<ByteArray, byte[], byte[]>> innerStores, Cluster cluster, StoreDefinition storeDef, int numberOfThreads, boolean repairReads, long timeoutMs, FailureDetector failureDetector) {
        this(name, innerStores, cluster, storeDef, repairReads, Executors.newFixedThreadPool(numberOfThreads), timeoutMs, failureDetector, SystemTime.INSTANCE);
    }

    public ThreadPoolRoutedStore(String name, Map<Integer, Store<ByteArray, byte[], byte[]>> innerStores, Cluster cluster, StoreDefinition storeDef, boolean repairReads, ExecutorService threadPool, long timeoutMs, FailureDetector failureDetector, Time time) {
        super(name, innerStores, cluster, storeDef, repairReads, timeoutMs, failureDetector, time);
        this.executor = threadPool;
    }

    @Override
    public boolean delete(final ByteArray key, final Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        List<Node> nodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
        int numNodes = nodes.size();
        if (numNodes < this.storeDef.getRequiredWrites()) {
            throw new InsufficientOperationalNodesException("Only " + numNodes + " nodes in preference list, but " + this.storeDef.getRequiredWrites() + " writes required.");
        }
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicBoolean deletedSomething = new AtomicBoolean(false);
        final List failures = Collections.synchronizedList(new LinkedList());
        final Semaphore semaphore = new Semaphore(0, false);
        for (final Node node : nodes) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block6: {
                        long startNs = System.nanoTime();
                        try {
                            try {
                                boolean deleted = ((Store)ThreadPoolRoutedStore.this.innerStores.get(node.getId())).delete(key, version);
                                successes.incrementAndGet();
                                deletedSomething.compareAndSet(false, deleted);
                                ThreadPoolRoutedStore.this.recordSuccess(node, startNs);
                            }
                            catch (UnreachableStoreException e) {
                                failures.add(e);
                                ThreadPoolRoutedStore.this.recordException(node, startNs, e);
                                Object var5_7 = null;
                                semaphore.release();
                                break block6;
                            }
                            catch (VoldemortApplicationException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                failures.add(e);
                                ThreadPoolRoutedStore.this.logger.warn((Object)("Error in DELETE on node " + node.getId() + "(" + node.getHost() + ")"), (Throwable)e);
                                Object var5_8 = null;
                                semaphore.release();
                            }
                            Object var5_6 = null;
                            semaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var5_9 = null;
                            semaphore.release();
                            throw throwable;
                        }
                    }
                }
            });
        }
        int attempts = Math.min(this.storeDef.getPreferredWrites(), numNodes);
        if (this.storeDef.getPreferredWrites() <= 0) {
            return true;
        }
        for (int i = 0; i < numNodes; ++i) {
            try {
                boolean acquired = semaphore.tryAcquire(this.timeoutMs, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    this.logger.warn((Object)("Delete operation timed out waiting for operation " + i + " to complete after waiting " + this.timeoutMs + " ms."));
                }
                if (successes.get() < attempts) continue;
                return deletedSomething.get();
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("Delete operation interrupted!", e);
            }
        }
        if (successes.get() < this.storeDef.getRequiredWrites()) {
            throw new InsufficientOperationalNodesException(this.storeDef.getRequiredWrites() + " deletes required, but " + successes.get() + " succeeded.", failures);
        }
        return deletedSomething.get();
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        List futures;
        StoreUtils.assertValidKeys(keys);
        HashMap<ByteArray, List<Versioned<byte[]>>> result = StoreUtils.newEmptyHashMap(keys);
        HashMap nodeToKeysMap = Maps.newHashMap();
        HashMap keyToExtraNodesMap = Maps.newHashMap();
        for (ByteArray key : keys) {
            List<Node> availableNodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
            this.checkRequiredReads(availableNodes);
            int preferredReads = this.storeDef.getPreferredReads();
            ArrayList preferredNodes = Lists.newArrayListWithCapacity((int)preferredReads);
            ArrayList extraNodes = Lists.newArrayListWithCapacity((int)3);
            for (Node node : availableNodes) {
                if (preferredNodes.size() < preferredReads) {
                    preferredNodes.add(node);
                    continue;
                }
                extraNodes.add(node);
            }
            for (Node node : preferredNodes) {
                List nodeKeys = (List)nodeToKeysMap.get(node);
                if (nodeKeys == null) {
                    nodeKeys = Lists.newArrayList();
                    nodeToKeysMap.put(node, nodeKeys);
                }
                nodeKeys.add(key);
            }
            if (extraNodes.isEmpty()) continue;
            List list = (List)keyToExtraNodesMap.get(key);
            if (list == null) {
                keyToExtraNodesMap.put(key, extraNodes);
                continue;
            }
            list.addAll(extraNodes);
        }
        ArrayList callables = Lists.newArrayList();
        for (Map.Entry entry : nodeToKeysMap.entrySet()) {
            Node node = (Node)entry.getKey();
            Collection nodeKeys = (Collection)entry.getValue();
            if (!this.failureDetector.isAvailable(node)) continue;
            callables.add(new GetAllCallable(node, nodeKeys, transforms));
        }
        ArrayList failures = Lists.newArrayList();
        ArrayList nodeValues = Lists.newArrayList();
        HashMap keyToSuccessCount = Maps.newHashMap();
        for (ByteArray key : keys) {
            keyToSuccessCount.put(key, new MutableInt(0));
        }
        try {
            futures = this.executor.invokeAll(callables, this.timeoutMs * 3L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InsufficientOperationalNodesException("getAll operation interrupted.", e);
        }
        for (Future future : futures) {
            if (future.isCancelled()) {
                this.logger.warn((Object)("Get operation timed out after " + this.timeoutMs + " ms."));
                continue;
            }
            try {
                GetAllResult getResult = (GetAllResult)future.get();
                if (getResult.exception != null) {
                    if (getResult.exception instanceof VoldemortApplicationException) {
                        throw (VoldemortException)getResult.exception;
                    }
                    failures.add(getResult.exception);
                    continue;
                }
                for (ByteArray key : getResult.callable.nodeKeys) {
                    List<Versioned<byte[]>> retrieved = getResult.retrieved.get(key);
                    MutableInt successCount = (MutableInt)keyToSuccessCount.get(key);
                    successCount.increment();
                    if (retrieved == null) continue;
                    List existing = (List)result.get(key);
                    if (existing == null) {
                        result.put(key, Lists.newArrayList(retrieved));
                        continue;
                    }
                    existing.addAll(retrieved);
                }
                nodeValues.addAll(getResult.nodeValues);
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("getAll operation interrupted.", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (ByteArray byteArray : keys) {
            List extraNodes;
            MutableInt successCountWrapper = (MutableInt)keyToSuccessCount.get(byteArray);
            int successCount = successCountWrapper.intValue();
            if (successCount < this.storeDef.getPreferredReads() && (extraNodes = (List)keyToExtraNodesMap.get(byteArray)) != null) {
                for (Node node : extraNodes) {
                    long startNs = System.nanoTime();
                    try {
                        List<Versioned<byte[]>> values = ((Store)this.innerStores.get(node.getId())).get(byteArray, transforms == null ? null : transforms.get(byteArray));
                        this.fillRepairReadsValues(nodeValues, byteArray, node, values);
                        List versioneds = (List)result.get(byteArray);
                        if (versioneds == null) {
                            result.put(byteArray, Lists.newArrayList(values));
                        } else {
                            versioneds.addAll(values);
                        }
                        this.recordSuccess(node, startNs);
                        if (++successCount < this.storeDef.getPreferredReads()) continue;
                        break;
                    }
                    catch (UnreachableStoreException e) {
                        failures.add(e);
                        this.recordException(node, startNs, e);
                    }
                    catch (VoldemortApplicationException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)("Error in GET_ALL on node " + node.getId() + "(" + node.getHost() + ")"), (Throwable)e);
                        failures.add(e);
                    }
                }
            }
            successCountWrapper.setValue(successCount);
        }
        this.repairReads(nodeValues, this.repairReads && (transforms == null || transforms.size() == 0));
        for (Map.Entry entry : keyToSuccessCount.entrySet()) {
            int successCount = ((MutableInt)entry.getValue()).intValue();
            if (successCount >= this.storeDef.getRequiredReads()) continue;
            throw new InsufficientOperationalNodesException(this.storeDef.getRequiredReads() + " reads required, but " + successCount + " succeeded.", failures);
        }
        return result;
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, final byte[] transforms) {
        Function<List<GetResult<Versioned<byte[]>>>, Void> readRepairFunction = new Function<List<GetResult<Versioned<byte[]>>>, Void>(){

            public Void apply(List<GetResult<Versioned<byte[]>>> nodeResults) {
                ArrayList nodeValues = Lists.newArrayListWithExpectedSize((int)nodeResults.size());
                for (GetResult<Versioned<byte[]>> getResult : nodeResults) {
                    ThreadPoolRoutedStore.this.fillRepairReadsValues(nodeValues, getResult.key, getResult.node, getResult.retrieved);
                }
                ThreadPoolRoutedStore.this.repairReads(nodeValues, ThreadPoolRoutedStore.this.repairReads && transforms == null);
                return null;
            }
        };
        return this.get(key, transforms, VERSIONED_OP, readRepairFunction);
    }

    private <R> List<R> get(ByteArray key, byte[] transforms, StoreOp<R> fetcher, Function<List<GetResult<R>>, Void> preReturnProcedure) throws VoldemortException {
        List futures;
        int nodeIndex;
        StoreUtils.assertValidKey(key);
        List<Node> nodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
        this.checkRequiredReads(nodes);
        ArrayList retrieved = Lists.newArrayList();
        int successes = 0;
        ArrayList failures = Lists.newArrayListWithCapacity((int)3);
        int attempts = Math.min(this.storeDef.getPreferredReads(), nodes.size());
        ArrayList callables = Lists.newArrayListWithCapacity((int)attempts);
        for (nodeIndex = 0; nodeIndex < attempts; ++nodeIndex) {
            Node node = nodes.get(nodeIndex);
            callables.add(new GetCallable<R>(node, key, transforms, fetcher));
        }
        try {
            futures = this.executor.invokeAll(callables, this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InsufficientOperationalNodesException("Get operation interrupted!", e);
        }
        for (Future f : futures) {
            if (f.isCancelled()) {
                this.logger.warn((Object)("Get operation timed out after " + this.timeoutMs + " ms."));
                continue;
            }
            try {
                GetResult getResult = (GetResult)f.get();
                if (getResult.exception != null) {
                    if (getResult.exception instanceof VoldemortApplicationException) {
                        throw (VoldemortException)getResult.exception;
                    }
                    failures.add(getResult.exception);
                    continue;
                }
                ++successes;
                retrieved.add(getResult);
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("Get operation interrupted!", e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        while (successes < this.storeDef.getPreferredReads() && nodeIndex < nodes.size()) {
            Node node = nodes.get(nodeIndex);
            long startNs = System.nanoTime();
            try {
                retrieved.add(new GetResult<R>(node, key, fetcher.execute((Store)this.innerStores.get(node.getId()), key, transforms), null));
                ++successes;
                this.recordSuccess(node, startNs);
            }
            catch (UnreachableStoreException e) {
                failures.add(e);
                this.recordException(node, startNs, e);
            }
            catch (VoldemortApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error in GET on node " + node.getId() + "(" + node.getHost() + ")"), (Throwable)e);
                failures.add(e);
            }
            ++nodeIndex;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("GET retrieved the following node values: " + this.formatNodeValues(retrieved)));
        }
        if (preReturnProcedure != null) {
            preReturnProcedure.apply((Object)retrieved);
        }
        if (successes >= this.storeDef.getRequiredReads()) {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)retrieved.size());
            for (GetResult getResult : retrieved) {
                result.addAll(getResult.retrieved);
            }
            return result;
        }
        throw new InsufficientOperationalNodesException(this.storeDef.getRequiredReads() + " reads required, but " + successes + " succeeded.", failures);
    }

    private void fillRepairReadsValues(List<NodeValue<ByteArray, byte[]>> nodeValues, ByteArray key, Node node, List<Versioned<byte[]>> fetched) {
        if (this.repairReads) {
            if (fetched.size() == 0) {
                nodeValues.add(this.nullValue(node, key));
            } else {
                for (Versioned<byte[]> f : fetched) {
                    nodeValues.add(new NodeValue<ByteArray, byte[]>(node.getId(), key, f));
                }
            }
        }
    }

    private NodeValue<ByteArray, byte[]> nullValue(Node node, ByteArray key) {
        return new NodeValue<ByteArray, Object>(node.getId(), key, new Versioned<Object>(null));
    }

    private void repairReads(List<NodeValue<ByteArray, byte[]>> nodeValues, boolean allowReadRepair) {
        if (!allowReadRepair || nodeValues.size() <= 1 || this.storeDef.getPreferredReads() <= 1) {
            return;
        }
        final ArrayList toReadRepair = Lists.newArrayList();
        for (NodeValue v : this.readRepairer.getRepairs(nodeValues)) {
            Versioned versioned = Versioned.value(v.getVersioned().getValue(), ((VectorClock)v.getVersion()).clone());
            toReadRepair.add(new NodeValue(v.getNodeId(), v.getKey(), versioned));
        }
        this.executor.execute(new Runnable(){

            public void run() {
                for (NodeValue v : toReadRepair) {
                    try {
                        if (ThreadPoolRoutedStore.this.logger.isDebugEnabled()) {
                            ThreadPoolRoutedStore.this.logger.debug((Object)("Doing read repair on node " + v.getNodeId() + " for key '" + v.getKey() + "' with version " + v.getVersion() + "."));
                        }
                        ((Store)ThreadPoolRoutedStore.this.innerStores.get(v.getNodeId())).put(v.getKey(), v.getVersioned(), null);
                    }
                    catch (VoldemortApplicationException e) {
                        if (!ThreadPoolRoutedStore.this.logger.isDebugEnabled()) continue;
                        ThreadPoolRoutedStore.this.logger.debug((Object)("Read repair cancelled due to application level exception on node " + v.getNodeId() + " for key '" + v.getKey() + "' with version " + v.getVersion() + ": " + e.getMessage()));
                    }
                    catch (Exception e) {
                        ThreadPoolRoutedStore.this.logger.debug((Object)"Read repair failed: ", (Throwable)e);
                    }
                }
            }
        });
    }

    private void checkRequiredReads(List<Node> nodes) throws InsufficientOperationalNodesException {
        if (nodes.size() < this.storeDef.getRequiredReads()) {
            throw new InsufficientOperationalNodesException("Only " + nodes.size() + " nodes in preference list, but " + this.storeDef.getRequiredReads() + " reads required.");
        }
    }

    private <R> String formatNodeValues(List<GetResult<R>> results) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (GetResult<R> r : results) {
            builder.append("GetResult(nodeId=" + r.node.getId() + ", key=" + r.key + ", retrieved= " + r.retrieved + ")");
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void put(final ByteArray key, Versioned<byte[]> versioned, final byte[] transforms) throws VoldemortException {
        int currentNode;
        long startNs = System.nanoTime();
        StoreUtils.assertValidKey(key);
        List<Node> nodes = this.availableNodes(this.routingStrategy.routeRequest(key.get()));
        int numNodes = nodes.size();
        if (numNodes < this.storeDef.getRequiredWrites()) {
            throw new InsufficientOperationalNodesException("Only " + numNodes + " nodes in preference list, but " + this.storeDef.getRequiredWrites() + " writes required.");
        }
        final AtomicInteger successes = new AtomicInteger(0);
        final List<Exception> failures = Collections.synchronizedList(new ArrayList(1));
        Node master = null;
        Versioned<byte[]> versionedCopy = null;
        for (currentNode = 0; currentNode < numNodes; ++currentNode) {
            Node current = nodes.get(currentNode);
            long startNsLocal = System.nanoTime();
            try {
                versionedCopy = this.incremented(versioned, current.getId());
                ((Store)this.innerStores.get(current.getId())).put(key, versionedCopy, transforms);
                successes.getAndIncrement();
                this.recordSuccess(current, startNsLocal);
                master = current;
                break;
            }
            catch (UnreachableStoreException e) {
                this.recordException(current, startNsLocal, e);
                failures.add(e);
                continue;
            }
            catch (VoldemortApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                failures.add(e);
            }
        }
        if (successes.get() < 1) {
            throw new InsufficientOperationalNodesException("No master node succeeded!", failures.size() > 0 ? (Exception)failures.get(0) : null);
        }
        ++currentNode;
        final Versioned<byte[]> finalVersionedCopy = versionedCopy;
        final Semaphore semaphore = new Semaphore(0, false);
        int attempts = 0;
        while (currentNode < numNodes) {
            ++attempts;
            final Node node = nodes.get(currentNode);
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block7: {
                        long startNsLocal = System.nanoTime();
                        try {
                            try {
                                ((Store)ThreadPoolRoutedStore.this.innerStores.get(node.getId())).put(key, finalVersionedCopy, transforms);
                                successes.incrementAndGet();
                                ThreadPoolRoutedStore.this.recordSuccess(node, startNsLocal);
                            }
                            catch (UnreachableStoreException e) {
                                ThreadPoolRoutedStore.this.recordException(node, startNsLocal, e);
                                failures.add(e);
                                Object var5_3 = null;
                                semaphore.release();
                                break block7;
                            }
                            catch (ObsoleteVersionException e) {
                                Object var5_4 = null;
                                semaphore.release();
                                break block7;
                            }
                            catch (VoldemortApplicationException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                ThreadPoolRoutedStore.this.logger.warn((Object)("Error in PUT on node " + node.getId() + "(" + node.getHost() + ")"), (Throwable)e);
                                failures.add(e);
                                Object var5_5 = null;
                                semaphore.release();
                            }
                            Object var5_2 = null;
                            semaphore.release();
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            semaphore.release();
                            throw throwable;
                        }
                    }
                }
            });
            ++currentNode;
        }
        int blockCount = Math.min(this.storeDef.getPreferredWrites() - 1, attempts);
        boolean noTimeout = this.blockOnPut(startNs, semaphore, 0, blockCount, successes, this.storeDef.getPreferredWrites());
        if (successes.get() < this.storeDef.getRequiredWrites()) {
            if (noTimeout) {
                int startingIndex = blockCount - 1;
                blockCount = Math.max(this.storeDef.getPreferredWrites() - 1, attempts);
                this.blockOnPut(startNs, semaphore, startingIndex, blockCount, successes, this.storeDef.getRequiredWrites());
            }
            if (successes.get() < this.storeDef.getRequiredWrites()) {
                throw new InsufficientOperationalNodesException(successes.get() + " writes succeeded, but " + this.storeDef.getRequiredWrites() + " are required.", failures);
            }
        }
        VectorClock versionedClock = (VectorClock)versioned.getVersion();
        versionedClock.incrementVersion(master.getId(), this.time.getMilliseconds());
    }

    private boolean blockOnPut(long startNs, Semaphore semaphore, int startingIndex, int blockCount, AtomicInteger successes, int successesRequired) {
        for (int i = startingIndex; i < blockCount; ++i) {
            try {
                long ellapsedNs = System.nanoTime() - startNs;
                long remainingNs = this.timeoutMs * 1000000L - ellapsedNs;
                boolean acquiredPermit = semaphore.tryAcquire(Math.max(remainingNs, 0L), TimeUnit.NANOSECONDS);
                if (!acquiredPermit) {
                    this.logger.warn((Object)("Timed out waiting for put # " + (i + 1) + " of " + blockCount + " to succeed."));
                    return false;
                }
                if (successes.get() < successesRequired) continue;
                break;
            }
            catch (InterruptedException e) {
                throw new InsufficientOperationalNodesException("Put operation interrupted", e);
            }
        }
        return true;
    }

    private Versioned<byte[]> incremented(Versioned<byte[]> versioned, int nodeId) {
        return new Versioned<byte[]>(versioned.getValue(), ((VectorClock)versioned.getVersion()).incremented(nodeId, this.time.getMilliseconds()));
    }

    private List<Node> availableNodes(List<Node> list) {
        ArrayList<Node> available = new ArrayList<Node>(list.size());
        for (Node node : list) {
            if (!this.failureDetector.isAvailable(node)) continue;
            available.add(node);
        }
        return available;
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.get(key, null, VERSION_OP, null);
    }

    private void recordException(Node node, long startNs, UnreachableStoreException e) {
        this.failureDetector.recordException(node, (System.nanoTime() - startNs) / 1000000L, e);
    }

    private void recordSuccess(Node node, long startNs) {
        this.failureDetector.recordSuccess(node, (System.nanoTime() - startNs) / 1000000L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface StoreOp<R> {
        public List<R> execute(Store<ByteArray, byte[], byte[]> var1, ByteArray var2, byte[] var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetAllResult {
        final GetAllCallable callable;
        final Map<ByteArray, List<Versioned<byte[]>>> retrieved;
        final Throwable exception;
        final List<NodeValue<ByteArray, byte[]>> nodeValues;

        private GetAllResult(GetAllCallable callable, Map<ByteArray, List<Versioned<byte[]>>> retrieved, List<NodeValue<ByteArray, byte[]>> nodeValues, Throwable exception) {
            this.callable = callable;
            this.exception = exception;
            this.retrieved = retrieved;
            this.nodeValues = nodeValues;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GetAllCallable
    implements Callable<GetAllResult> {
        private final Node node;
        private final Collection<ByteArray> nodeKeys;
        private final Map<ByteArray, byte[]> transforms;

        private GetAllCallable(Node node, Collection<ByteArray> nodeKeys, Map<ByteArray, byte[]> transforms) {
            this.node = node;
            this.nodeKeys = nodeKeys;
            this.transforms = transforms;
        }

        @Override
        public GetAllResult call() {
            Map<Object, Object> retrieved = Collections.emptyMap();
            Throwable exception = null;
            ArrayList nodeValues = Lists.newArrayList();
            long startNs = System.nanoTime();
            try {
                retrieved = ((Store)ThreadPoolRoutedStore.this.innerStores.get(this.node.getId())).getAll(this.nodeKeys, this.transforms);
                if (ThreadPoolRoutedStore.this.repairReads) {
                    for (Map.Entry<Object, Object> entry : retrieved.entrySet()) {
                        ThreadPoolRoutedStore.this.fillRepairReadsValues(nodeValues, (ByteArray)entry.getKey(), this.node, (List)entry.getValue());
                    }
                    for (ByteArray nodeKey : this.nodeKeys) {
                        if (retrieved.containsKey(nodeKey)) continue;
                        ThreadPoolRoutedStore.this.fillRepairReadsValues(nodeValues, nodeKey, this.node, Collections.emptyList());
                    }
                }
                ThreadPoolRoutedStore.this.recordSuccess(this.node, startNs);
            }
            catch (UnreachableStoreException e) {
                exception = e;
                ThreadPoolRoutedStore.this.recordException(this.node, startNs, e);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                exception = e;
                ThreadPoolRoutedStore.this.logger.warn((Object)("Error in GET on node " + this.node.getId() + "(" + this.node.getHost() + ")"), e);
            }
            return new GetAllResult(this, retrieved, nodeValues, exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetResult<R> {
        final Node node;
        final ByteArray key;
        final List<R> retrieved;
        final Throwable exception;

        public GetResult(Node node, ByteArray key, List<R> retrieved, Throwable exception) {
            this.node = node;
            this.key = key;
            this.retrieved = retrieved;
            this.exception = exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class GetCallable<R>
    implements Callable<GetResult<R>> {
        private final Node node;
        private final ByteArray key;
        private final byte[] transforms;
        private final StoreOp<R> fetcher;

        public GetCallable(Node node, ByteArray key, byte[] transforms, StoreOp<R> fetcher) {
            this.node = node;
            this.key = key;
            this.transforms = transforms;
            this.fetcher = fetcher;
        }

        @Override
        public GetResult<R> call() throws Exception {
            List<Object> fetched = Collections.emptyList();
            Throwable exception = null;
            long startNs = System.nanoTime();
            try {
                if (ThreadPoolRoutedStore.this.logger.isTraceEnabled()) {
                    ThreadPoolRoutedStore.this.logger.trace((Object)("Attempting get operation on node " + this.node.getId() + " for key '" + ByteUtils.toHexString(this.key.get()) + "'."));
                }
                fetched = this.fetcher.execute((Store)ThreadPoolRoutedStore.this.innerStores.get(this.node.getId()), this.key, this.transforms);
                ThreadPoolRoutedStore.this.recordSuccess(this.node, startNs);
            }
            catch (UnreachableStoreException e) {
                exception = e;
                ThreadPoolRoutedStore.this.recordException(this.node, startNs, e);
            }
            catch (Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                ThreadPoolRoutedStore.this.logger.warn((Object)("Error in GET on node " + this.node.getId() + "(" + this.node.getHost() + ")"), e);
                exception = e;
            }
            return new GetResult(this.node, this.key, fetched, exception);
        }
    }
}

