/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.ThreadPoolBasedNonblockingStoreImpl;
import voldemort.store.routed.PipelineRoutedStore;
import voldemort.store.routed.RoutedStore;
import voldemort.store.routed.ThreadPoolRoutedStore;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutedStoreFactory {
    private final boolean isPipelineRoutedStoreEnabled;
    private final ExecutorService threadPool;
    private final long routingTimeoutMs;
    private final Logger logger = Logger.getLogger(this.getClass());

    public RoutedStoreFactory(boolean isPipelineRoutedStoreEnabled, ExecutorService threadPool, long routingTimeoutMs) {
        this.isPipelineRoutedStoreEnabled = isPipelineRoutedStoreEnabled;
        this.threadPool = threadPool;
        this.routingTimeoutMs = routingTimeoutMs;
    }

    public NonblockingStore toNonblockingStore(Store<ByteArray, byte[], byte[]> store) {
        if (store instanceof NonblockingStore) {
            return (NonblockingStore)((Object)store);
        }
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)("Using pseudo NonblockingStore implementation for " + store.getClass()));
        }
        return new ThreadPoolBasedNonblockingStoreImpl(this.threadPool, store);
    }

    public RoutedStore create(Cluster cluster, StoreDefinition storeDefinition, Map<Integer, Store<ByteArray, byte[], byte[]>> nodeStores, Map<Integer, NonblockingStore> nonblockingStores, Map<Integer, Store<ByteArray, Slop, byte[]>> slopStores, Map<Integer, NonblockingStore> nonblockingSlopStores, boolean repairReads, int clientZoneId, FailureDetector failureDetector) {
        if (this.isPipelineRoutedStoreEnabled) {
            return new PipelineRoutedStore(storeDefinition.getName(), nodeStores, nonblockingStores, slopStores, nonblockingSlopStores, cluster, storeDefinition, repairReads, clientZoneId, this.routingTimeoutMs, failureDetector);
        }
        if (storeDefinition.getRoutingStrategyType().compareTo("zone-routing") == 0) {
            throw new VoldemortException("Zone Routing for store '" + storeDefinition.getName() + "' not supported using thread pool routed store.");
        }
        if (slopStores != null) {
            throw new VoldemortException("Hinted Handoff for store '" + storeDefinition.getName() + "' not supported using thread pool routed store.");
        }
        return new ThreadPoolRoutedStore(storeDefinition.getName(), nodeStores, cluster, storeDefinition, repairReads, this.threadPool, this.routingTimeoutMs, failureDetector, SystemTime.INSTANCE);
    }

    public RoutedStore create(Cluster cluster, StoreDefinition storeDefinition, Map<Integer, Store<ByteArray, byte[], byte[]>> nodeStores, boolean repairReads, FailureDetector failureDetector) {
        HashMap nonblockingStores = Maps.newHashMap();
        for (Map.Entry<Integer, Store<ByteArray, byte[], byte[]>> entry : nodeStores.entrySet()) {
            nonblockingStores.put(entry.getKey(), this.toNonblockingStore(entry.getValue()));
        }
        return this.create(cluster, storeDefinition, nodeStores, nonblockingStores, null, null, repairReads, 0, failureDetector);
    }
}

