/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreDefinition;
import voldemort.store.routed.ReadRepairer;
import voldemort.utils.ByteArray;
import voldemort.utils.Time;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RoutedStore
implements Store<ByteArray, byte[], byte[]> {
    protected final String name;
    protected final Map<Integer, Store<ByteArray, byte[], byte[]>> innerStores;
    protected final boolean repairReads;
    protected final ReadRepairer<ByteArray, byte[]> readRepairer;
    protected final long timeoutMs;
    protected final Time time;
    protected final StoreDefinition storeDef;
    protected final FailureDetector failureDetector;
    protected volatile RoutingStrategy routingStrategy;
    protected final Logger logger = Logger.getLogger(this.getClass());

    protected RoutedStore(String name, Map<Integer, Store<ByteArray, byte[], byte[]>> innerStores, Cluster cluster, StoreDefinition storeDef, boolean repairReads, long timeoutMs, FailureDetector failureDetector, Time time) {
        if (storeDef.getRequiredReads() < 1) {
            throw new IllegalArgumentException("Cannot have a storeDef.getRequiredReads() number less than 1.");
        }
        if (storeDef.getRequiredWrites() < 1) {
            throw new IllegalArgumentException("Cannot have a storeDef.getRequiredWrites() number less than 1.");
        }
        if (storeDef.getPreferredReads() < storeDef.getRequiredReads()) {
            throw new IllegalArgumentException("storeDef.getPreferredReads() must be greater or equal to storeDef.getRequiredReads().");
        }
        if (storeDef.getPreferredWrites() < storeDef.getRequiredWrites()) {
            throw new IllegalArgumentException("storeDef.getPreferredWrites() must be greater or equal to storeDef.getRequiredWrites().");
        }
        if (storeDef.getPreferredReads() > innerStores.size()) {
            throw new IllegalArgumentException("storeDef.getPreferredReads() is larger than the total number of nodes!");
        }
        if (storeDef.getPreferredWrites() > innerStores.size()) {
            throw new IllegalArgumentException("storeDef.getPreferredWrites() is larger than the total number of nodes!");
        }
        this.name = name;
        this.innerStores = new ConcurrentHashMap<Integer, Store<ByteArray, byte[], byte[]>>(innerStores);
        this.repairReads = repairReads;
        this.readRepairer = new ReadRepairer();
        this.timeoutMs = timeoutMs;
        this.time = Utils.notNull(time);
        this.storeDef = storeDef;
        this.failureDetector = failureDetector;
        this.routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDef, cluster);
    }

    public void updateRoutingStrategy(RoutingStrategy routingStrategy) {
        this.logger.info((Object)("Updating routing strategy for RoutedStore:" + this.getName()));
        this.routingStrategy = routingStrategy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        VoldemortException exception = null;
        for (Store<ByteArray, byte[], byte[]> store : this.innerStores.values()) {
            try {
                store.close();
            }
            catch (VoldemortException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public Map<Integer, Store<ByteArray, byte[], byte[]>> getInnerStores() {
        return this.innerStores;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        switch (capability) {
            case ROUTING_STRATEGY: {
                return this.routingStrategy;
            }
            case READ_REPAIRER: {
                return this.readRepairer;
            }
            case VERSION_INCREMENTING: {
                return true;
            }
        }
        throw new NoSuchCapabilityException(capability, this.getName());
    }
}

