/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.swapper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.swapper.StoreSwapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStoreSwapper
extends StoreSwapper {
    private static final Logger logger = Logger.getLogger(HttpStoreSwapper.class);
    private final HttpClient httpClient;
    private final String readOnlyMgmtPath;
    private boolean deleteFailedFetch = false;
    private boolean rollbackFailedSwap = false;

    public HttpStoreSwapper(Cluster cluster, ExecutorService executor, HttpClient httpClient, String readOnlyMgmtPath, boolean deleteFailedFetch, boolean rollbackFailedSwap) {
        super(cluster, executor);
        this.httpClient = httpClient;
        this.readOnlyMgmtPath = readOnlyMgmtPath;
        this.deleteFailedFetch = deleteFailedFetch;
        this.rollbackFailedSwap = rollbackFailedSwap;
    }

    public HttpStoreSwapper(Cluster cluster, ExecutorService executor, HttpClient httpClient, String readOnlyMgmtPath) {
        super(cluster, executor);
        this.httpClient = httpClient;
        this.readOnlyMgmtPath = readOnlyMgmtPath;
    }

    @Override
    protected List<String> invokeFetch(final String storeName, final String basePath, final long pushVersion) {
        HashMap<Integer, Future<String>> fetchDirs = new HashMap<Integer, Future<String>>();
        for (final Node node : this.cluster.getNodes()) {
            fetchDirs.put(node.getId(), this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String url = node.getHttpUrl() + "/" + HttpStoreSwapper.this.readOnlyMgmtPath;
                    PostMethod post = new PostMethod(url);
                    post.addParameter("operation", "fetch");
                    String storeDir = basePath + "/node-" + node.getId();
                    post.addParameter("dir", storeDir);
                    post.addParameter("store", storeName);
                    if (pushVersion > 0L) {
                        post.addParameter("pushVersion", Long.toString(pushVersion));
                    }
                    logger.info((Object)("Invoking fetch for node " + node.getId() + " for " + storeDir));
                    int responseCode = HttpStoreSwapper.this.httpClient.executeMethod((HttpMethod)post);
                    String response = post.getResponseBodyAsString(30000);
                    if (responseCode != 200) {
                        throw new VoldemortException("Fetch request on node " + node.getId() + " (" + url + ") failed: " + post.getStatusText());
                    }
                    logger.info((Object)("Fetch succeeded on node " + node.getId()));
                    return response.trim();
                }
            }));
        }
        TreeMap results = Maps.newTreeMap();
        HashMap exceptions = Maps.newHashMap();
        for (int nodeId = 0; nodeId < this.cluster.getNumberOfNodes(); ++nodeId) {
            Future val = (Future)fetchDirs.get(nodeId);
            try {
                results.put(nodeId, val.get());
                continue;
            }
            catch (Exception e) {
                exceptions.put(nodeId, new VoldemortException(e));
            }
        }
        if (!exceptions.isEmpty()) {
            if (this.deleteFailedFetch) {
                Iterator i$ = results.keySet().iterator();
                while (i$.hasNext()) {
                    int successfulNodeId = (Integer)i$.next();
                    try {
                        String url = this.cluster.getNodeById(successfulNodeId).getHttpUrl() + "/" + this.readOnlyMgmtPath;
                        PostMethod post = new PostMethod(url);
                        post.addParameter("operation", "failed-fetch");
                        post.addParameter("dir", (String)results.get(successfulNodeId));
                        post.addParameter("store", storeName);
                        logger.info((Object)("Deleting fetched data from node " + successfulNodeId));
                        int responseCode = this.httpClient.executeMethod((HttpMethod)post);
                        String response = post.getStatusText();
                        if (responseCode == 200) {
                            logger.info((Object)("Deleted successfully on node " + successfulNodeId));
                            continue;
                        }
                        throw new VoldemortException(response);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception thrown during delete operation on node " + successfulNodeId + " : "), (Throwable)e);
                    }
                }
            }
            Iterator i$ = exceptions.keySet().iterator();
            while (i$.hasNext()) {
                int failedNodeId = (Integer)i$.next();
                logger.error((Object)("Error on node " + failedNodeId + " during push : "), (Throwable)exceptions.get(failedNodeId));
            }
            throw new VoldemortException("Exception during pushes to nodes " + Joiner.on((String)",").join(exceptions.keySet()) + " failed");
        }
        return Lists.newArrayList(results.values());
    }

    @Override
    protected void invokeSwap(String storeName, List<String> fetchFiles) {
        PostMethod post;
        String url;
        HashMap<Integer, String> previousDirs = new HashMap<Integer, String>();
        HashMap exceptions = Maps.newHashMap();
        for (Node node : this.cluster.getNodes()) {
            try {
                url = node.getHttpUrl() + "/" + this.readOnlyMgmtPath;
                post = new PostMethod(url);
                post.addParameter("operation", "swap");
                String dir = fetchFiles.get(node.getId());
                logger.info((Object)("Attempting swap for node " + node.getId() + " dir = " + dir));
                post.addParameter("dir", dir);
                post.addParameter("store", storeName);
                int responseCode = this.httpClient.executeMethod((HttpMethod)post);
                String previousDir = post.getResponseBodyAsString(30000);
                if (responseCode != 200) {
                    throw new VoldemortException("Swap request on node " + node.getId() + " (" + url + ") failed: " + post.getStatusText());
                }
                logger.info((Object)("Swap succeeded on node " + node.getId()));
                previousDirs.put(node.getId(), previousDir);
            }
            catch (Exception e) {
                exceptions.put(node.getId(), e);
                logger.error((Object)("Exception thrown during swap operation on node " + node.getId() + ": "), (Throwable)e);
            }
        }
        if (!exceptions.isEmpty()) {
            Iterator<Node> i$;
            if (this.rollbackFailedSwap) {
                i$ = previousDirs.keySet().iterator();
                while (i$.hasNext()) {
                    int successfulNodeId = (Integer)((Object)i$.next());
                    try {
                        url = this.cluster.getNodeById(successfulNodeId).getHttpUrl() + "/" + this.readOnlyMgmtPath;
                        post = new PostMethod(url);
                        post.addParameter("operation", "rollback");
                        post.addParameter("store", storeName);
                        post.addParameter("pushVersion", Long.toString(ReadOnlyUtils.getVersionId(new File((String)previousDirs.get(successfulNodeId)))));
                        logger.info((Object)("Rolling back data on successful node " + successfulNodeId));
                        int responseCode = this.httpClient.executeMethod((HttpMethod)post);
                        String response = post.getStatusText();
                        if (responseCode == 200) {
                            logger.info((Object)("Rollback succeeded for node " + successfulNodeId));
                            continue;
                        }
                        throw new VoldemortException(response);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception thrown during rollback ( after swap ) operation on node " + successfulNodeId + " : "), (Throwable)e);
                    }
                }
            }
            i$ = exceptions.keySet().iterator();
            while (i$.hasNext()) {
                int failedNodeId = (Integer)((Object)i$.next());
                logger.error((Object)("Error on node " + failedNodeId + " during swap : "), (Throwable)exceptions.get(failedNodeId));
            }
            throw new VoldemortException("Exception during swaps on nodes " + Joiner.on((String)",").join(exceptions.keySet()) + " failed");
        }
    }

    @Override
    protected void invokeRollback(String storeName, long pushVersion) {
        Exception exception = null;
        for (Node node : this.cluster.getNodes()) {
            try {
                logger.info((Object)("Attempting rollback for node " + node.getId() + " storeName = " + storeName));
                String url = node.getHttpUrl() + "/" + this.readOnlyMgmtPath;
                PostMethod post = new PostMethod(url);
                post.addParameter("operation", "rollback");
                post.addParameter("store", storeName);
                post.addParameter("pushVersion", Long.toString(pushVersion));
                int responseCode = this.httpClient.executeMethod((HttpMethod)post);
                String response = post.getStatusText();
                if (responseCode == 200) {
                    logger.info((Object)("Rollback succeeded for node " + node.getId()));
                    continue;
                }
                throw new VoldemortException(response);
            }
            catch (Exception e) {
                exception = e;
                logger.error((Object)("Exception thrown during rollback operation on node " + node.getId() + ": "), (Throwable)e);
            }
        }
        if (exception != null) {
            throw new VoldemortException(exception);
        }
    }
}

