/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.swapper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.swapper.StoreSwapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminStoreSwapper
extends StoreSwapper {
    private static final Logger logger = Logger.getLogger(AdminStoreSwapper.class);
    private AdminClient adminClient;
    private long timeoutMs;
    private boolean deleteFailedFetch = false;
    private boolean rollbackFailedSwap = false;

    public AdminStoreSwapper(Cluster cluster, ExecutorService executor, AdminClient adminClient, long timeoutMs, boolean deleteFailedFetch, boolean rollbackFailedSwap) {
        super(cluster, executor);
        this.adminClient = adminClient;
        this.timeoutMs = timeoutMs;
        this.deleteFailedFetch = deleteFailedFetch;
        this.rollbackFailedSwap = rollbackFailedSwap;
    }

    public AdminStoreSwapper(Cluster cluster, ExecutorService executor, AdminClient adminClient, long timeoutMs) {
        super(cluster, executor);
        this.adminClient = adminClient;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public void invokeRollback(String storeName, long pushVersion) {
        Exception exception = null;
        for (Node node : this.cluster.getNodes()) {
            try {
                logger.info((Object)("Attempting rollback for node " + node.getId() + " storeName = " + storeName));
                this.adminClient.rollbackStore(node.getId(), storeName, pushVersion);
                logger.info((Object)("Rollback succeeded for node " + node.getId()));
            }
            catch (Exception e) {
                exception = e;
                logger.error((Object)("Exception thrown during rollback operation on node " + node.getId() + ": "), (Throwable)e);
            }
        }
        if (exception != null) {
            throw new VoldemortException(exception);
        }
    }

    @Override
    protected List<String> invokeFetch(final String storeName, final String basePath, final long pushVersion) {
        HashMap<Integer, Future<String>> fetchDirs = new HashMap<Integer, Future<String>>();
        for (final Node node : this.cluster.getNodes()) {
            fetchDirs.put(node.getId(), this.executor.submit(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String storeDir = basePath + "/node-" + node.getId();
                    logger.info((Object)("Invoking fetch for node " + node.getId() + " for " + storeDir));
                    String response = AdminStoreSwapper.this.adminClient.fetchStore(node.getId(), storeName, storeDir, pushVersion, AdminStoreSwapper.this.timeoutMs);
                    if (response == null) {
                        throw new VoldemortException("Fetch request on node " + node.getId() + " (" + node.getHost() + ") failed");
                    }
                    logger.info((Object)("Fetch succeeded on node " + node.getId()));
                    return response.trim();
                }
            }));
        }
        TreeMap results = Maps.newTreeMap();
        HashMap exceptions = Maps.newHashMap();
        for (int nodeId = 0; nodeId < this.cluster.getNumberOfNodes(); ++nodeId) {
            Future val = (Future)fetchDirs.get(nodeId);
            try {
                results.put(nodeId, val.get());
                continue;
            }
            catch (Exception e) {
                exceptions.put(nodeId, new VoldemortException(e));
            }
        }
        if (!exceptions.isEmpty()) {
            if (this.deleteFailedFetch) {
                Iterator i$ = results.keySet().iterator();
                while (i$.hasNext()) {
                    int successfulNodeId = (Integer)i$.next();
                    try {
                        logger.info((Object)("Deleting fetched data from node " + successfulNodeId));
                        this.adminClient.failedFetchStore(successfulNodeId, storeName, (String)results.get(successfulNodeId));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception thrown during delete operation on node " + successfulNodeId + " : "), (Throwable)e);
                    }
                }
            }
            Iterator i$ = exceptions.keySet().iterator();
            while (i$.hasNext()) {
                int failedNodeId = (Integer)i$.next();
                logger.error((Object)("Error on node " + failedNodeId + " during push : "), (Throwable)exceptions.get(failedNodeId));
            }
            throw new VoldemortException("Exception during pushes to nodes " + Joiner.on((String)",").join(exceptions.keySet()) + " failed");
        }
        return Lists.newArrayList(results.values());
    }

    @Override
    protected void invokeSwap(String storeName, List<String> fetchFiles) {
        HashMap<Integer, String> previousDirs = new HashMap<Integer, String>();
        HashMap exceptions = Maps.newHashMap();
        for (int nodeId = 0; nodeId < this.cluster.getNumberOfNodes(); ++nodeId) {
            try {
                String dir = fetchFiles.get(nodeId);
                logger.info((Object)("Attempting swap for node " + nodeId + " dir = " + dir));
                previousDirs.put(nodeId, this.adminClient.swapStore(nodeId, storeName, dir));
                logger.info((Object)("Swap succeeded for node " + nodeId));
                continue;
            }
            catch (Exception e) {
                exceptions.put(nodeId, e);
            }
        }
        if (!exceptions.isEmpty()) {
            if (this.rollbackFailedSwap) {
                Iterator i$ = previousDirs.keySet().iterator();
                while (i$.hasNext()) {
                    int successfulNodeId = (Integer)i$.next();
                    try {
                        logger.info((Object)("Rolling back data on successful node " + successfulNodeId));
                        this.adminClient.rollbackStore(successfulNodeId, storeName, ReadOnlyUtils.getVersionId(new File((String)previousDirs.get(successfulNodeId))));
                        logger.info((Object)("Rollback succeeded for node " + successfulNodeId));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Exception thrown during rollback ( after swap ) operation on node " + successfulNodeId + ": "), (Throwable)e);
                    }
                }
            }
            Iterator i$ = exceptions.keySet().iterator();
            while (i$.hasNext()) {
                int failedNodeId = (Integer)i$.next();
                logger.error((Object)("Error on node " + failedNodeId + " during swap : "), (Throwable)exceptions.get(failedNodeId));
            }
            throw new VoldemortException("Exception during swaps on nodes " + Joiner.on((String)",").join(exceptions.keySet()) + " failed");
        }
    }
}

