/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.http;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.utils.ByteArray;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStore
implements Store<ByteArray, byte[], byte[]> {
    private final String storeName;
    private final HttpClient httpClient;
    private final RequestFormat requestFormat;
    private final RequestRoutingType reroute;
    private final String storeUrl;

    public HttpStore(String storeName, String host, int port, HttpClient client, RequestFormat format, boolean reroute) {
        this.storeName = storeName;
        this.httpClient = client;
        this.requestFormat = format;
        this.reroute = RequestRoutingType.getRequestRoutingType(reroute, false);
        this.storeUrl = "http://" + host + ":" + port + "/stores";
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        boolean bl;
        block4: {
            StoreUtils.assertValidKey(key);
            PostMethod method = null;
            try {
                method = new PostMethod(this.storeUrl);
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                this.requestFormat.writeDeleteRequest(new DataOutputStream(outputBytes), this.storeName, key, (VectorClock)version, this.reroute);
                DataInputStream input = this.executeRequest(method, outputBytes);
                bl = this.requestFormat.readDeleteResponse(input);
                Object var8_8 = null;
                if (method == null) break block4;
            }
            catch (IOException e) {
                try {
                    throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var8_9 = null;
                        if (method == null) break block5;
                        method.releaseConnection();
                    }
                    throw throwable;
                }
            }
            method.releaseConnection();
        }
        return bl;
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        List<Versioned<byte[]>> list;
        block4: {
            StoreUtils.assertValidKey(key);
            PostMethod method = null;
            try {
                method = new PostMethod(this.storeUrl);
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                this.requestFormat.writeGetRequest(new DataOutputStream(outputBytes), this.storeName, key, transforms, this.reroute);
                DataInputStream input = this.executeRequest(method, outputBytes);
                list = this.requestFormat.readGetResponse(input);
                Object var8_8 = null;
                if (method == null) break block4;
            }
            catch (IOException e) {
                try {
                    throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var8_9 = null;
                        if (method == null) break block5;
                        method.releaseConnection();
                    }
                    throw throwable;
                }
            }
            method.releaseConnection();
        }
        return list;
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        Map<ByteArray, List<Versioned<byte[]>>> map;
        block4: {
            StoreUtils.assertValidKeys(keys);
            PostMethod method = null;
            try {
                method = new PostMethod(this.storeUrl);
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                this.requestFormat.writeGetAllRequest(new DataOutputStream(outputBytes), this.storeName, keys, transforms, this.reroute);
                DataInputStream input = this.executeRequest(method, outputBytes);
                map = this.requestFormat.readGetAllResponse(input);
                Object var8_8 = null;
                if (method == null) break block4;
            }
            catch (IOException e) {
                try {
                    throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var8_9 = null;
                        if (method == null) break block5;
                        method.releaseConnection();
                    }
                    throw throwable;
                }
            }
            method.releaseConnection();
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(ByteArray key, Versioned<byte[]> versioned, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        PostMethod method = null;
        try {
            try {
                method = new PostMethod(this.storeUrl);
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                this.requestFormat.writePutRequest(new DataOutputStream(outputBytes), this.storeName, key, versioned.getValue(), transforms, (VectorClock)versioned.getVersion(), this.reroute);
                DataInputStream input = this.executeRequest(method, outputBytes);
                this.requestFormat.readPutResponse(input);
            }
            catch (IOException e) {
                throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
            }
            Object var8_8 = null;
            if (method == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (method == null) throw throwable;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
    }

    private DataInputStream executeRequest(PostMethod method, ByteArrayOutputStream output) {
        try {
            method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(output.toByteArray()));
            int response = this.httpClient.executeMethod((HttpMethod)method);
            if (response != 200) {
                throw new UnreachableStoreException("HTTP request to store " + this.storeName + " returned status code " + response + " " + method.getStatusText());
            }
            return new DataInputStream(method.getResponseBodyAsStream());
        }
        catch (HttpException e) {
            throw new VoldemortException(e);
        }
        catch (IOException e) {
            throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return this.storeName;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        List<Version> list;
        block4: {
            StoreUtils.assertValidKey(key);
            PostMethod method = null;
            try {
                method = new PostMethod(this.storeUrl);
                ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
                this.requestFormat.writeGetVersionRequest(new DataOutputStream(outputBytes), this.storeName, key, this.reroute);
                DataInputStream input = this.executeRequest(method, outputBytes);
                list = this.requestFormat.readGetVersionResponse(input);
                Object var7_7 = null;
                if (method == null) break block4;
            }
            catch (IOException e) {
                try {
                    throw new UnreachableStoreException("Could not connect to " + this.storeUrl + " for " + this.storeName, e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var7_8 = null;
                        if (method == null) break block5;
                        method.releaseConnection();
                    }
                    throw throwable;
                }
            }
            method.releaseConnection();
        }
        return list;
    }
}

