/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.gzip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GzipStore<K>
extends DelegatingStore<K, byte[], byte[]>
implements Store<K, byte[], byte[]> {
    public GzipStore(Store<K, byte[], byte[]> innerStore) {
        super(innerStore);
    }

    @Override
    public List<Versioned<byte[]>> get(K key, byte[] transforms) throws VoldemortException {
        List found = this.getInnerStore().get(key, transforms);
        ArrayList<Versioned<byte[]>> results = new ArrayList<Versioned<byte[]>>(found.size());
        try {
            for (Versioned item : found) {
                results.add(new Versioned<byte[]>(IOUtils.toByteArray((InputStream)new GZIPInputStream(new ByteArrayInputStream((byte[])item.getValue()))), item.getVersion()));
            }
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        return results;
    }

    @Override
    public void put(K key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        try {
            this.getInnerStore().put(key, new Versioned<byte[]>(IOUtils.toByteArray((InputStream)new GZIPInputStream(new ByteArrayInputStream(value.getValue()))), value.getVersion()), transforms);
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }
}

