/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.compress.lzf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import voldemort.store.compress.lzf.LZFDecoder;
import voldemort.store.compress.lzf.LZFEncoder;

public class LZF {
    static final String SUFFIX = ".lzf";

    void process(String[] args) throws IOException {
        String oper;
        boolean compress;
        if (args.length == 2 && ((compress = "-c".equals(oper = args[0])) || "-d".equals(oper))) {
            String filename = args[1];
            File src = new File(filename);
            if (!src.exists()) {
                System.err.println("File '" + filename + "' does not exist.");
                System.exit(1);
            }
            if (!compress && !filename.endsWith(SUFFIX)) {
                System.err.println("File '" + filename + "' does end with expected suffix ('" + SUFFIX + "', won't decompress.");
                System.exit(1);
            }
            byte[] data = this.readData(src);
            System.out.println("Read " + data.length + " bytes.");
            byte[] result = compress ? LZFEncoder.encode(data) : LZFDecoder.decode(data);
            System.out.println("Processed into " + result.length + " bytes.");
            File resultFile = compress ? new File(filename + SUFFIX) : new File(filename.substring(0, filename.length() - SUFFIX.length()));
            FileOutputStream out = new FileOutputStream(resultFile);
            out.write(result);
            out.close();
            System.out.println("Wrote in file '" + resultFile.getAbsolutePath() + "'.");
            return;
        }
        System.err.println("Usage: java " + this.getClass().getName() + " -c/-d file");
        System.exit(1);
    }

    private byte[] readData(File in) throws IOException {
        int count;
        int len = (int)in.length();
        byte[] result = new byte[len];
        int offset = 0;
        FileInputStream fis = new FileInputStream(in);
        while (len > 0 && (count = fis.read(result, offset, len)) >= 0) {
            len -= count;
            offset += count;
        }
        fis.close();
        if (len > 0) {
            throw new IOException("Could not read the whole file -- received EOF when there was " + len + " bytes left to read");
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        new LZF().process(args);
    }
}

