/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.bdb;

import com.google.common.collect.Lists;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.serialization.IdentitySerializer;
import voldemort.serialization.Serializer;
import voldemort.serialization.VersionedSerializer;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.PersistenceFailureException;
import voldemort.store.StorageEngine;
import voldemort.store.StorageInitializationException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbStorageEngine
implements StorageEngine<ByteArray, byte[], byte[]> {
    private static final Logger logger = Logger.getLogger(BdbStorageEngine.class);
    private static final Hex hexCodec = new Hex();
    private final String name;
    private Database bdbDatabase;
    private final Environment environment;
    private final VersionedSerializer<byte[]> versionedSerializer;
    private final AtomicBoolean isOpen;
    private final boolean cursorPreload;
    private final LockMode readLockMode;
    private final Serializer<Version> versionSerializer;
    private final AtomicBoolean isTruncating = new AtomicBoolean(false);

    public BdbStorageEngine(String name, Environment environment, Database database, LockMode readLockMode) {
        this(name, environment, database, readLockMode, false);
    }

    public BdbStorageEngine(String name, Environment environment, Database database, LockMode readLockMode, boolean cursorPreload) {
        this.name = Utils.notNull(name);
        this.bdbDatabase = Utils.notNull(database);
        this.environment = Utils.notNull(environment);
        this.versionedSerializer = new VersionedSerializer<byte[]>(new IdentitySerializer());
        this.versionSerializer = new Serializer<Version>(){

            @Override
            public byte[] toBytes(Version object) {
                return ((VectorClock)object).toBytes();
            }

            @Override
            public Version toObject(byte[] bytes) {
                return BdbStorageEngine.this.versionedSerializer.getVersion(bytes);
            }
        };
        this.isOpen = new AtomicBoolean(true);
        this.cursorPreload = cursorPreload;
        this.readLockMode = readLockMode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        try {
            if (this.cursorPreload) {
                PreloadConfig preloadConfig = new PreloadConfig();
                preloadConfig.setLoadLNs(true);
                this.getBdbDatabase().preload(preloadConfig);
            }
            Cursor cursor = this.getBdbDatabase().openCursor(null, null);
            return new BdbEntriesIterator(cursor);
        }
        catch (DatabaseException e) {
            logger.error((Object)e);
            throw new PersistenceFailureException(e);
        }
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        try {
            Cursor cursor = this.getBdbDatabase().openCursor(null, null);
            return new BdbKeysIterator(cursor);
        }
        catch (DatabaseException e) {
            logger.error((Object)e);
            throw new PersistenceFailureException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate() {
        if (!this.isTruncating.compareAndSet(false, true)) throw new VoldemortException("Store " + this.getName() + " is already truncating, cannot start another one.");
        Transaction transaction = null;
        boolean succeeded = false;
        try {
            try {
                transaction = this.environment.beginTransaction(null, null);
                this.bdbDatabase.close();
                this.environment.truncateDatabase(transaction, this.getName(), false);
                succeeded = true;
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
                throw new VoldemortException("Failed to truncate Bdb store " + this.getName(), e);
            }
            Object var5_3 = null;
            this.commitOrAbort(succeeded, transaction);
            if (!this.reopenBdbDatabase()) throw new VoldemortException("Failed to reopen Bdb Database after truncation, All request will fail on store " + this.getName());
            this.isTruncating.compareAndSet(true, false);
            return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.commitOrAbort(succeeded, transaction);
            if (!this.reopenBdbDatabase()) throw new VoldemortException("Failed to reopen Bdb Database after truncation, All request will fail on store " + this.getName());
            this.isTruncating.compareAndSet(true, false);
            throw throwable;
        }
    }

    private void commitOrAbort(boolean succeeded, Transaction transaction) {
        try {
            if (succeeded) {
                this.attemptCommit(transaction);
            } else {
                this.attemptAbort(transaction);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private boolean reopenBdbDatabase() {
        try {
            this.bdbDatabase = this.environment.openDatabase(null, this.getName(), this.bdbDatabase.getConfig());
            return true;
        }
        catch (DatabaseException e) {
            throw new StorageInitializationException("Failed to reinitialize BdbStorageEngine for store:" + this.getName() + " after truncation.", e);
        }
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.get(key, null, this.readLockMode, this.versionSerializer);
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws PersistenceFailureException {
        return this.get(key, transforms, this.readLockMode, this.versionedSerializer);
    }

    private <T> List<T> get(ByteArray key, byte[] transforms, LockMode lockMode, Serializer<T> serializer) throws PersistenceFailureException {
        List<T> list;
        StoreUtils.assertValidKey(key);
        Cursor cursor = null;
        try {
            cursor = this.getBdbDatabase().openCursor(null, null);
            list = BdbStorageEngine.get(cursor, key, lockMode, serializer);
            Object var8_8 = null;
        }
        catch (DatabaseException e) {
            try {
                logger.error((Object)e);
                throw new PersistenceFailureException(e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                BdbStorageEngine.attemptClose(cursor);
                throw throwable;
            }
        }
        BdbStorageEngine.attemptClose(cursor);
        return list;
    }

    private Database getBdbDatabase() {
        if (this.isTruncating.get()) {
            throw new VoldemortException("Bdb Store " + this.getName() + " is currently truncating cannot serve any request.");
        }
        return this.bdbDatabase;
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        HashMap<ByteArray, List<Versioned<byte[]>>> result = StoreUtils.newEmptyHashMap(keys);
        Cursor cursor = null;
        try {
            try {
                cursor = this.getBdbDatabase().openCursor(null, null);
                for (ByteArray key : keys) {
                    List<byte[]> values = BdbStorageEngine.get(cursor, key, this.readLockMode, this.versionedSerializer);
                    if (values.isEmpty()) continue;
                    result.put(key, values);
                }
                Object var9_9 = null;
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
                throw new PersistenceFailureException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            BdbStorageEngine.attemptClose(cursor);
            throw throwable;
        }
        BdbStorageEngine.attemptClose(cursor);
        return result;
    }

    private static <T> List<T> get(Cursor cursor, ByteArray key, LockMode lockMode, Serializer<T> serializer) throws DatabaseException {
        StoreUtils.assertValidKey(key);
        DatabaseEntry keyEntry = new DatabaseEntry(key.get());
        DatabaseEntry valueEntry = new DatabaseEntry();
        ArrayList results = Lists.newArrayList();
        OperationStatus status = cursor.getSearchKey(keyEntry, valueEntry, lockMode);
        while (status == OperationStatus.SUCCESS) {
            results.add(serializer.toObject(valueEntry.getData()));
            status = cursor.getNextDup(keyEntry, valueEntry, lockMode);
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws PersistenceFailureException {
        StoreUtils.assertValidKey(key);
        DatabaseEntry keyEntry = new DatabaseEntry(key.get());
        boolean succeeded = false;
        Transaction transaction = null;
        Cursor cursor = null;
        try {
            try {
                transaction = this.environment.beginTransaction(null, null);
                DatabaseEntry valueEntry = new DatabaseEntry();
                cursor = this.getBdbDatabase().openCursor(transaction, null);
                OperationStatus status = cursor.getSearchKey(keyEntry, valueEntry, LockMode.RMW);
                while (status == OperationStatus.SUCCESS) {
                    VectorClock clock = new VectorClock(valueEntry.getData());
                    Occured occured = value.getVersion().compare(clock);
                    if (occured == Occured.BEFORE) {
                        throw new ObsoleteVersionException("Key " + new String(hexCodec.encode(key.get())) + " " + value.getVersion().toString() + " is obsolete, it is no greater than the current version of " + clock + ".");
                    }
                    if (occured == Occured.AFTER) {
                        cursor.delete();
                    }
                    status = cursor.getNextDup(keyEntry, valueEntry, LockMode.RMW);
                }
                valueEntry = new DatabaseEntry(this.versionedSerializer.toBytes(value));
                status = cursor.put(keyEntry, valueEntry);
                if (status != OperationStatus.SUCCESS) {
                    throw new PersistenceFailureException("Put operation failed with status: " + status);
                }
                succeeded = true;
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
                throw new PersistenceFailureException(e);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            BdbStorageEngine.attemptClose(cursor);
            if (succeeded) {
                this.attemptCommit(transaction);
                throw throwable;
            }
            this.attemptAbort(transaction);
            throw throwable;
        }
        BdbStorageEngine.attemptClose(cursor);
        if (succeeded) {
            this.attemptCommit(transaction);
            return;
        }
        this.attemptAbort(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(ByteArray key, Version version) throws PersistenceFailureException {
        boolean bl;
        StoreUtils.assertValidKey(key);
        boolean deletedSomething = false;
        Cursor cursor = null;
        Transaction transaction = null;
        try {
            try {
                transaction = this.environment.beginTransaction(null, null);
                DatabaseEntry keyEntry = new DatabaseEntry(key.get());
                DatabaseEntry valueEntry = new DatabaseEntry();
                cursor = this.getBdbDatabase().openCursor(transaction, null);
                OperationStatus status = cursor.getSearchKey(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
                while (status == OperationStatus.SUCCESS) {
                    if (new VectorClock(valueEntry.getData()).compare(version) == Occured.BEFORE) {
                        cursor.delete();
                        deletedSomething = true;
                    }
                    status = cursor.getNextDup(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
                }
                bl = deletedSomething;
                Object var11_11 = null;
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
                throw new PersistenceFailureException(e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                BdbStorageEngine.attemptClose(cursor);
                Object var13_15 = null;
                this.attemptCommit(transaction);
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var13_16 = null;
                this.attemptCommit(transaction);
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.attemptCommit(transaction);
            throw throwable;
        }
        BdbStorageEngine.attemptClose(cursor);
        Object var13_13 = null;
        this.attemptCommit(transaction);
        return bl;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !Store.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        Store s = (Store)o;
        return s.getName().equals(s.getName());
    }

    @Override
    public void close() throws PersistenceFailureException {
        try {
            if (this.isOpen.compareAndSet(true, false)) {
                this.getBdbDatabase().close();
            }
        }
        catch (DatabaseException e) {
            logger.error((Object)e);
            throw new PersistenceFailureException("Shutdown failed.", e);
        }
    }

    private void attemptAbort(Transaction transaction) {
        try {
            if (transaction != null) {
                transaction.abort();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Abort failed!", (Throwable)e);
        }
    }

    private void attemptCommit(Transaction transaction) {
        try {
            transaction.commit();
        }
        catch (DatabaseException e) {
            logger.error((Object)"Transaction commit failed!", (Throwable)e);
            this.attemptAbort(transaction);
            throw new PersistenceFailureException(e);
        }
    }

    private static void attemptClose(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (DatabaseException e) {
            logger.error((Object)"Error closing cursor.", (Throwable)e);
            throw new PersistenceFailureException(e.getMessage(), e);
        }
    }

    public DatabaseStats getStats(boolean setFast) {
        try {
            StatsConfig config = new StatsConfig();
            config.setFast(setFast);
            return this.getBdbDatabase().getStats(config);
        }
        catch (DatabaseException e) {
            logger.error((Object)e);
            throw new VoldemortException(e);
        }
    }

    @JmxOperation(description="A variety of stats about the BDB for this store.")
    public String getBdbStats() {
        String stats = this.getStats(false).toString();
        return stats;
    }

    @Override
    public boolean isPartitionAware() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BdbEntriesIterator
    extends BdbIterator<Pair<ByteArray, Versioned<byte[]>>> {
        public BdbEntriesIterator(Cursor cursor) {
            super(cursor, false);
        }

        @Override
        protected Pair<ByteArray, Versioned<byte[]>> get(DatabaseEntry key, DatabaseEntry value) {
            VectorClock clock = new VectorClock(value.getData());
            byte[] bytes = ByteUtils.copy(value.getData(), clock.sizeInBytes(), value.getData().length);
            return Pair.create(new ByteArray(key.getData()), new Versioned<byte[]>(bytes, clock));
        }

        @Override
        protected void moveCursor(DatabaseEntry key, DatabaseEntry value) throws DatabaseException {
            this.cursor.getNext(key, value, LockMode.READ_UNCOMMITTED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BdbKeysIterator
    extends BdbIterator<ByteArray> {
        public BdbKeysIterator(Cursor cursor) {
            super(cursor, true);
        }

        @Override
        protected ByteArray get(DatabaseEntry key, DatabaseEntry value) {
            return new ByteArray(key.getData());
        }

        @Override
        protected void moveCursor(DatabaseEntry key, DatabaseEntry value) throws DatabaseException {
            this.cursor.getNextNoDup(key, value, LockMode.READ_UNCOMMITTED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BdbIterator<T>
    implements ClosableIterator<T> {
        private final boolean noValues;
        final Cursor cursor;
        private T current;
        private volatile boolean isOpen;

        public BdbIterator(Cursor cursor, boolean noValues) {
            this.cursor = cursor;
            this.isOpen = true;
            this.noValues = noValues;
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            if (noValues) {
                valueEntry.setPartial(true);
            }
            try {
                cursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
                throw new PersistenceFailureException(e);
            }
            if (keyEntry.getData() != null) {
                this.current = this.get(keyEntry, valueEntry);
            }
        }

        protected abstract T get(DatabaseEntry var1, DatabaseEntry var2);

        protected abstract void moveCursor(DatabaseEntry var1, DatabaseEntry var2) throws DatabaseException;

        @Override
        public final boolean hasNext() {
            return this.current != null;
        }

        @Override
        public final T next() {
            if (!this.isOpen) {
                throw new PersistenceFailureException("Call to next() on a closed iterator.");
            }
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            if (this.noValues) {
                valueEntry.setPartial(true);
            }
            try {
                this.moveCursor(keyEntry, valueEntry);
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
                throw new PersistenceFailureException(e);
            }
            T previous = this.current;
            this.current = keyEntry.getData() == null ? null : this.get(keyEntry, valueEntry);
            return previous;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("No removal y'all.");
        }

        @Override
        public final void close() {
            try {
                this.cursor.close();
                this.isOpen = false;
            }
            catch (DatabaseException e) {
                logger.error((Object)e);
            }
        }

        protected final void finalize() {
            if (this.isOpen) {
                logger.error((Object)"Failure to close cursor, will be forcably closed.");
                this.close();
            }
        }
    }
}

