/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import voldemort.client.RoutingTier;
import voldemort.serialization.SerializerDefinition;
import voldemort.store.slop.strategy.HintedHandoffStrategyType;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String type;
    private final String description;
    private final SerializerDefinition keySerializer;
    private final SerializerDefinition valueSerializer;
    private final SerializerDefinition transformsSerializer;
    private final RoutingTier routingPolicy;
    private final int replicationFactor;
    private final Integer preferredWrites;
    private final int requiredWrites;
    private final Integer preferredReads;
    private final int requiredReads;
    private final Integer retentionPeriodDays;
    private final Integer retentionScanThrottleRate;
    private final String routingStrategyType;
    private final String viewOf;
    private final HashMap<Integer, Integer> zoneReplicationFactor;
    private final Integer zoneCountReads;
    private final Integer zoneCountWrites;
    private final String valueTransformation;
    private final String serializerFactory;
    private final HintedHandoffStrategyType hintedHandoffStrategyType;
    private final Integer hintPrefListSize;
    private final List<String> owners;

    public StoreDefinition(String name, String type, String description, SerializerDefinition keySerializer, SerializerDefinition valueSerializer, SerializerDefinition transformsSerializer, RoutingTier routingPolicy, String routingStrategyType, int replicationFactor, Integer preferredReads, int requiredReads, Integer preferredWrites, int requiredWrites, String viewOfStore, String valTrans, HashMap<Integer, Integer> zoneReplicationFactor, Integer zoneCountReads, Integer zoneCountWrites, Integer retentionDays, Integer retentionThrottleRate, String factory, HintedHandoffStrategyType hintedHandoffStrategyType, Integer hintPrefListSize, List<String> owners) {
        this.name = Utils.notNull(name);
        this.type = Utils.notNull(type);
        this.description = description;
        this.replicationFactor = replicationFactor;
        this.preferredReads = preferredReads;
        this.requiredReads = requiredReads;
        this.preferredWrites = preferredWrites;
        this.requiredWrites = requiredWrites;
        this.routingPolicy = Utils.notNull(routingPolicy);
        this.keySerializer = Utils.notNull(keySerializer);
        this.valueSerializer = Utils.notNull(valueSerializer);
        this.transformsSerializer = transformsSerializer;
        this.retentionPeriodDays = retentionDays;
        this.retentionScanThrottleRate = retentionThrottleRate;
        this.routingStrategyType = routingStrategyType;
        this.viewOf = viewOfStore;
        this.valueTransformation = valTrans;
        this.zoneReplicationFactor = zoneReplicationFactor;
        this.zoneCountReads = zoneCountReads;
        this.zoneCountWrites = zoneCountWrites;
        this.serializerFactory = factory;
        this.hintedHandoffStrategyType = hintedHandoffStrategyType;
        this.hintPrefListSize = hintPrefListSize;
        this.owners = owners;
        this.checkParameterLegality();
    }

    private void checkParameterLegality() {
        if (this.requiredReads < 1) {
            throw new IllegalArgumentException("Cannot have a requiredReads number less than 1.");
        }
        if (this.requiredReads > this.replicationFactor) {
            throw new IllegalArgumentException("Cannot have more requiredReads then there are replicas.");
        }
        if (this.requiredWrites < 1) {
            throw new IllegalArgumentException("Cannot have a requiredWrites number less than 1.");
        }
        if (this.requiredWrites > this.replicationFactor) {
            throw new IllegalArgumentException("Cannot have more requiredWrites then there are replicas.");
        }
        if (this.preferredWrites != null) {
            if (this.preferredWrites < this.requiredWrites) {
                throw new IllegalArgumentException("preferredWrites must be greater or equal to requiredWrites.");
            }
            if (this.preferredWrites > this.replicationFactor) {
                throw new IllegalArgumentException("Cannot have more preferredWrites then there are replicas.");
            }
        }
        if (this.preferredReads != null) {
            if (this.preferredReads < this.requiredReads) {
                throw new IllegalArgumentException("preferredReads must be greater or equal to requiredReads.");
            }
            if (this.preferredReads > this.replicationFactor) {
                throw new IllegalArgumentException("Cannot have more preferredReads then there are replicas.");
            }
        }
        if (this.retentionPeriodDays != null && this.retentionPeriodDays < 0) {
            throw new IllegalArgumentException("Retention days must be non-negative.");
        }
        if (this.zoneReplicationFactor != null && this.zoneReplicationFactor.size() != 0) {
            if (this.zoneCountReads == null || this.zoneCountReads < 0) {
                throw new IllegalArgumentException("Zone Counts reads must be non-negative / non-null");
            }
            if (this.zoneCountWrites == null || this.zoneCountWrites < 0) {
                throw new IllegalArgumentException("Zone Counts writes must be non-negative");
            }
            int sumZoneReplicationFactor = 0;
            int replicatingZones = 0;
            for (Integer zoneId : this.zoneReplicationFactor.keySet()) {
                int currentZoneRepFactor = this.zoneReplicationFactor.get(zoneId);
                sumZoneReplicationFactor += currentZoneRepFactor;
                if (currentZoneRepFactor <= 0) continue;
                ++replicatingZones;
            }
            if (replicatingZones <= 0) {
                throw new IllegalArgumentException("Cannot have no zones to replicate to. Should have some positive zoneReplicationFactor");
            }
            if (sumZoneReplicationFactor != this.replicationFactor) {
                throw new IllegalArgumentException("Sum total of zones (" + sumZoneReplicationFactor + ") does not match the total replication factor (" + this.replicationFactor + ")");
            }
            if (this.zoneCountReads >= replicatingZones) {
                throw new IllegalArgumentException("Number of zones to block for while reading (" + this.zoneCountReads + ") should be less then replicating zones (" + replicatingZones + ")");
            }
            if (this.zoneCountWrites >= replicatingZones) {
                throw new IllegalArgumentException("Number of zones to block for while writing (" + this.zoneCountWrites + ") should be less then replicating zones (" + replicatingZones + ")");
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getSerializerFactory() {
        return this.serializerFactory;
    }

    public boolean hasTransformsSerializer() {
        return this.transformsSerializer != null;
    }

    public String getName() {
        return this.name;
    }

    public int getRequiredWrites() {
        return this.requiredWrites;
    }

    public SerializerDefinition getKeySerializer() {
        return this.keySerializer;
    }

    public SerializerDefinition getValueSerializer() {
        return this.valueSerializer;
    }

    public SerializerDefinition getTransformsSerializer() {
        return this.transformsSerializer;
    }

    public RoutingTier getRoutingPolicy() {
        return this.routingPolicy;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public String getRoutingStrategyType() {
        return this.routingStrategyType;
    }

    public int getRequiredReads() {
        return this.requiredReads;
    }

    public boolean hasPreferredWrites() {
        return this.preferredWrites != null;
    }

    public int getPreferredWrites() {
        return this.preferredWrites == null ? this.getRequiredWrites() : this.preferredWrites.intValue();
    }

    public int getPreferredReads() {
        return this.preferredReads == null ? this.getRequiredReads() : this.preferredReads.intValue();
    }

    public boolean hasPreferredReads() {
        return this.preferredReads != null;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasRetentionPeriod() {
        return this.retentionPeriodDays != null;
    }

    public Integer getRetentionDays() {
        return this.retentionPeriodDays;
    }

    public boolean hasRetentionScanThrottleRate() {
        return this.retentionScanThrottleRate != null;
    }

    public Integer getRetentionScanThrottleRate() {
        return this.retentionScanThrottleRate;
    }

    public boolean isView() {
        return this.viewOf != null;
    }

    public String getViewTargetStoreName() {
        return this.viewOf;
    }

    public boolean hasValueTransformation() {
        return this.valueTransformation != null;
    }

    public String getValueTransformation() {
        return this.valueTransformation;
    }

    public HashMap<Integer, Integer> getZoneReplicationFactor() {
        return this.zoneReplicationFactor;
    }

    public Integer getZoneCountReads() {
        return this.zoneCountReads;
    }

    public boolean hasZoneCountReads() {
        return this.zoneCountReads != null;
    }

    public Integer getZoneCountWrites() {
        return this.zoneCountWrites;
    }

    public boolean hasZoneCountWrites() {
        return this.zoneCountWrites != null;
    }

    public HintedHandoffStrategyType getHintedHandoffStrategyType() {
        return this.hintedHandoffStrategyType;
    }

    public boolean hasHintedHandoffStrategyType() {
        return this.hintedHandoffStrategyType != null;
    }

    public Integer getHintPrefListSize() {
        return this.hintPrefListSize;
    }

    public boolean hasHintPreflistSize() {
        return this.hintPrefListSize != null;
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != StoreDefinition.class) {
            return false;
        }
        StoreDefinition def = (StoreDefinition)o;
        return this.getName().equals(def.getName()) && this.getType().equals(def.getType()) && this.getReplicationFactor() == def.getReplicationFactor() && this.getRequiredReads() == def.getRequiredReads() && Objects.equal((Object)this.getPreferredReads(), (Object)def.getPreferredReads()) && this.getRequiredWrites() == def.getRequiredWrites() && Objects.equal((Object)this.getPreferredWrites(), (Object)def.getPreferredWrites()) && this.getKeySerializer().equals(def.getKeySerializer()) && this.getValueSerializer().equals(def.getValueSerializer()) && Objects.equal((Object)(this.getTransformsSerializer() != null ? this.getTransformsSerializer() : null), (Object)(def.getTransformsSerializer() != null ? def.getTransformsSerializer() : null)) && this.getRoutingPolicy() == def.getRoutingPolicy() && Objects.equal((Object)this.getViewTargetStoreName(), (Object)def.getViewTargetStoreName()) && Objects.equal(this.getValueTransformation() != null ? this.getValueTransformation().getClass() : null, def.getValueTransformation() != null ? def.getValueTransformation().getClass() : null) && Objects.equal(this.getZoneReplicationFactor() != null ? this.getZoneReplicationFactor().getClass() : null, def.getZoneReplicationFactor() != null ? def.getZoneReplicationFactor().getClass() : null) && Objects.equal((Object)this.getZoneCountReads(), (Object)def.getZoneCountReads()) && Objects.equal((Object)this.getZoneCountWrites(), (Object)def.getZoneCountWrites()) && Objects.equal((Object)this.getRetentionDays(), (Object)def.getRetentionDays()) && Objects.equal((Object)this.getRetentionScanThrottleRate(), (Object)def.getRetentionScanThrottleRate()) && Objects.equal((Object)(this.getSerializerFactory() != null ? this.getSerializerFactory() : null), (Object)(def.getSerializerFactory() != null ? def.getSerializerFactory() : null)) && Objects.equal((Object)((Object)this.getHintedHandoffStrategyType()), (Object)((Object)def.getHintedHandoffStrategyType())) && Objects.equal((Object)this.getHintPrefListSize(), (Object)def.getHintPrefListSize());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getName(), this.getType(), this.getDescription(), this.getKeySerializer(), this.getValueSerializer(), this.getTransformsSerializer(), this.getRoutingPolicy(), this.getRoutingStrategyType(), this.getReplicationFactor(), this.getRequiredReads(), this.getRequiredWrites(), this.getPreferredReads(), this.getPreferredWrites(), this.getViewTargetStoreName(), this.getValueTransformation() == null ? null : this.getValueTransformation().getClass(), this.getZoneReplicationFactor() == null ? null : this.getZoneReplicationFactor().getClass(), this.getZoneCountReads(), this.getZoneCountWrites(), this.getRetentionDays(), this.getRetentionScanThrottleRate(), this.getSerializerFactory(), this.hasHintedHandoffStrategyType() ? this.getHintedHandoffStrategyType() : null, this.hasHintPreflistSize() ? this.getHintPrefListSize() : null, this.getOwners()});
    }

    public String toString() {
        return "StoreDefinition(name = " + this.getName() + ", type = " + this.getType() + ", description = " + this.getDescription() + ", key-serializer = " + this.getKeySerializer() + ", value-serializer = " + this.getValueSerializer() + ", routing = " + (Object)((Object)this.getRoutingPolicy()) + ", routing-strategy = " + this.getRoutingStrategyType() + ", replication = " + this.getReplicationFactor() + ", required-reads = " + this.getRequiredReads() + ", preferred-reads = " + this.getPreferredReads() + ", required-writes = " + this.getRequiredWrites() + ", preferred-writes = " + this.getPreferredWrites() + ", view-target = " + this.getViewTargetStoreName() + ", value-transformation = " + this.getValueTransformation() + ", retention-days = " + this.getRetentionDays() + ", throttle-rate = " + this.getRetentionScanThrottleRate() + ", zone-count-reads = " + this.getZoneCountReads() + ", zone-count-writes = " + this.getZoneCountWrites() + ", serializer factory = " + this.getSerializerFactory() + ")" + ", hinted-handoff-strategy = " + (Object)((Object)this.getHintedHandoffStrategyType()) + ", hint-preflist-size = " + this.getHintPrefListSize() + ", owners = " + this.getOwners() + ")";
    }
}

