/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormatType;
import voldemort.server.protocol.RequestHandler;
import voldemort.server.protocol.RequestHandlerFactory;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketServerSession
implements Runnable {
    private final Logger logger = Logger.getLogger(SocketServerSession.class);
    private final Map<Long, SocketServerSession> activeSessions;
    private final long sessionId;
    private final Socket socket;
    private final RequestHandlerFactory handlerFactory;
    private volatile boolean isClosed = false;

    public SocketServerSession(Map<Long, SocketServerSession> activeSessions, Socket socket, RequestHandlerFactory handlerFactory, long id) {
        this.activeSessions = activeSessions;
        this.socket = socket;
        this.handlerFactory = handlerFactory;
        this.sessionId = id;
    }

    public Socket getSocket() {
        return this.socket;
    }

    private boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block27: {
            block25: {
                this.activeSessions.put(this.sessionId, this);
                DataInputStream inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 64000));
                DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 64000));
                RequestFormatType protocol = this.negotiateProtocol(inputStream, outputStream);
                RequestHandler handler = this.handlerFactory.getRequestHandler(protocol);
                this.logger.info((Object)("Client " + this.socket.getRemoteSocketAddress() + " connected successfully with protocol " + protocol.getCode()));
                while (!(this.isInterrupted() || this.socket.isClosed() || this.isClosed)) {
                    block24: {
                        StreamRequestHandler srh = handler.handleRequest(inputStream, outputStream);
                        if (srh != null) {
                            Object var9_9;
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)"Request is streaming");
                            }
                            StreamRequestHandler.StreamRequestHandlerState srhs = null;
                            try {
                                do {
                                    if (this.logger.isTraceEnabled()) {
                                        this.logger.trace((Object)"About to enter streaming request handler");
                                    }
                                    srhs = srh.handleRequest(inputStream, outputStream);
                                    if (!this.logger.isTraceEnabled()) continue;
                                    this.logger.trace((Object)("Finished invocation of streaming request handler, result is " + (Object)((Object)srhs)));
                                } while (srhs != StreamRequestHandler.StreamRequestHandlerState.COMPLETE);
                                var9_9 = null;
                            }
                            catch (Throwable throwable) {
                                var9_9 = null;
                                srh.close(outputStream);
                                throw throwable;
                            }
                            srh.close(outputStream);
                            {
                                break block24;
                                catch (VoldemortException e) {
                                    srh.handleError(outputStream, e);
                                    outputStream.flush();
                                    var9_9 = null;
                                    srh.close(outputStream);
                                    break;
                                }
                            }
                        }
                    }
                    outputStream.flush();
                }
                if (!this.isInterrupted()) break block25;
                this.logger.info((Object)(Thread.currentThread().getName() + " has been interrupted, closing session."));
            }
            Object var11_12 = null;
            try {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (Exception e2) {
                this.logger.error((Object)"Error while closing socket", (Throwable)e2);
            }
            this.activeSessions.remove(this.sessionId);
            {
                break block27;
                catch (EOFException e) {
                    this.logger.info((Object)("Client " + this.socket.getRemoteSocketAddress() + " disconnected."));
                    Object var11_13 = null;
                    try {
                        if (!this.socket.isClosed()) {
                            this.socket.close();
                        }
                    }
                    catch (Exception e2) {
                        this.logger.error((Object)"Error while closing socket", (Throwable)e2);
                    }
                    this.activeSessions.remove(this.sessionId);
                    break block27;
                }
                catch (IOException e) {
                    if (!this.isClosed) {
                        this.logger.error((Object)e);
                    }
                    Object var11_14 = null;
                    try {
                        if (!this.socket.isClosed()) {
                            this.socket.close();
                        }
                    }
                    catch (Exception e2) {
                        this.logger.error((Object)"Error while closing socket", (Throwable)e2);
                    }
                    this.activeSessions.remove(this.sessionId);
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    if (!this.socket.isClosed()) {
                        this.socket.close();
                    }
                }
                catch (Exception e2) {
                    this.logger.error((Object)"Error while closing socket", (Throwable)e2);
                }
                this.activeSessions.remove(this.sessionId);
                throw throwable;
            }
        }
    }

    private RequestFormatType negotiateProtocol(InputStream input, OutputStream output) throws IOException {
        RequestFormatType requestFormat;
        input.mark(3);
        byte[] protoBytes = new byte[3];
        ByteUtils.read(input, protoBytes);
        try {
            String proto = ByteUtils.getString(protoBytes, "UTF-8");
            requestFormat = RequestFormatType.fromCode(proto);
            output.write(ByteUtils.getBytes("ok", "UTF-8"));
            output.flush();
        }
        catch (IllegalArgumentException e) {
            requestFormat = RequestFormatType.VOLDEMORT_V0;
            input.reset();
            this.logger.info((Object)("No protocol proposal given, assuming " + RequestFormatType.VOLDEMORT_V0.getDisplayName()));
        }
        return requestFormat;
    }

    public void close() throws IOException {
        this.isClosed = true;
        this.socket.close();
    }
}

