/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler.slop;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.Zone;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageEngine;
import voldemort.store.UnreachableStoreException;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.slop.Slop;
import voldemort.store.slop.SlopStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingSlopPusherJob
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)StreamingSlopPusherJob.class.getName());
    public static final String TYPE_NAME = "streaming";
    private static final Versioned<Slop> END = Versioned.value(null);
    private final MetadataStore metadataStore;
    private final StoreRepository storeRepo;
    private final FailureDetector failureDetector;
    private final ConcurrentMap<Integer, SynchronousQueue<Versioned<Slop>>> slopQueues;
    private final ExecutorService consumerExecutor;
    private final EventThrottler readThrottler;
    private AdminClient adminClient;
    private final Cluster cluster;
    private final List<Future> consumerResults;
    private final VoldemortConfig voldemortConfig;
    private final Map<Integer, Set<Integer>> zoneMapping;
    private final ConcurrentHashMap<Integer, Long> attemptedByNode;
    private final ConcurrentHashMap<Integer, Long> succeededByNode;
    private final Semaphore repairPermits;

    public StreamingSlopPusherJob(StoreRepository storeRepo, MetadataStore metadataStore, FailureDetector failureDetector, VoldemortConfig voldemortConfig, Semaphore repairPermits) {
        this.storeRepo = storeRepo;
        this.metadataStore = metadataStore;
        this.failureDetector = failureDetector;
        this.voldemortConfig = voldemortConfig;
        this.repairPermits = Utils.notNull(repairPermits);
        this.cluster = metadataStore.getCluster();
        this.slopQueues = new ConcurrentHashMap<Integer, SynchronousQueue<Versioned<Slop>>>(this.cluster.getNumberOfNodes());
        this.consumerExecutor = Executors.newFixedThreadPool(this.cluster.getNumberOfNodes(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("slop-pusher");
                return thread;
            }
        });
        this.readThrottler = new EventThrottler(voldemortConfig.getSlopMaxReadBytesPerSec());
        this.adminClient = null;
        this.consumerResults = Lists.newArrayList();
        this.attemptedByNode = new ConcurrentHashMap(this.cluster.getNumberOfNodes());
        this.succeededByNode = new ConcurrentHashMap(this.cluster.getNumberOfNodes());
        this.zoneMapping = Maps.newHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block65: {
            Exception e4222;
            if (this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER)) {
                logger.error((Object)"Cannot run slop pusher job since Voldemort server is rebalancing");
                return;
            }
            boolean terminatedEarly = false;
            Date startTime = new Date();
            logger.info((Object)("Started streaming slop pusher job at " + startTime));
            SlopStorageEngine slopStorageEngine = this.storeRepo.getSlopStore();
            ClosableIterator<Pair<ByteArray, Versioned<Slop>>> iterator = null;
            if (this.adminClient == null) {
                this.adminClient = new AdminClient(this.cluster, new AdminClientConfig().setMaxConnectionsPerNode(1));
            }
            if (this.voldemortConfig.getSlopZonesDownToTerminate() > 0) {
                this.zoneMapping.clear();
                for (Node n : this.cluster.getNodes()) {
                    if (!this.failureDetector.isAvailable(n)) continue;
                    HashSet nodes = this.zoneMapping.get(n.getZoneId());
                    if (nodes == null) {
                        nodes = Sets.newHashSet();
                        this.zoneMapping.put(n.getZoneId(), nodes);
                    }
                    nodes.add(n.getId());
                }
                int zonesDown = 0;
                for (Zone zone : this.cluster.getZones()) {
                    if (this.zoneMapping.get(zone.getId()) != null && this.zoneMapping.get(zone.getId()).size() != 0) continue;
                    ++zonesDown;
                }
                if (this.voldemortConfig.getSlopZonesDownToTerminate() <= this.zoneMapping.size() && zonesDown >= this.voldemortConfig.getSlopZonesDownToTerminate()) {
                    logger.info((Object)("Completed streaming slop pusher job at " + startTime + " early because " + zonesDown + " zones are down"));
                    this.stopAdminClient();
                    return;
                }
            }
            AtomicLong attemptedPushes = new AtomicLong(0L);
            for (Node node : this.cluster.getNodes()) {
                this.attemptedByNode.put(node.getId(), 0L);
                this.succeededByNode.put(node.getId(), 0L);
            }
            this.acquireRepairPermit();
            StorageEngine<ByteArray, Slop, byte[]> slopStore = slopStorageEngine.asSlopStore();
            iterator = slopStore.entries();
            while (iterator.hasNext()) {
                try {
                    Pair keyAndVal = (Pair)iterator.next();
                    Versioned versioned = (Versioned)keyAndVal.getSecond();
                    int nodeId = ((Slop)versioned.getValue()).getNodeId();
                    Node node = this.cluster.getNodeById(nodeId);
                    attemptedPushes.incrementAndGet();
                    Long attempted = this.attemptedByNode.get(nodeId);
                    this.attemptedByNode.put(nodeId, attempted + 1L);
                    if (attemptedPushes.get() % 10000L == 0L) {
                        logger.info((Object)("Attempted pushing " + attemptedPushes + " slops"));
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Pushing slop for " + ((Slop)versioned.getValue()).getNodeId() + " and store  " + ((Slop)versioned.getValue()).getStoreName()));
                    }
                    if (this.failureDetector.isAvailable(node)) {
                        boolean offered;
                        SynchronousQueue<Versioned<Slop>> slopQueue = (SynchronousQueue<Versioned<Slop>>)this.slopQueues.get(nodeId);
                        if (slopQueue == null) {
                            slopQueue = new SynchronousQueue<Versioned<Slop>>();
                            this.slopQueues.put(nodeId, slopQueue);
                            this.consumerResults.add(this.consumerExecutor.submit(new SlopConsumer(nodeId, slopQueue, slopStorageEngine)));
                        }
                        if (!(offered = slopQueue.offer(versioned, this.voldemortConfig.getClientRoutingTimeoutMs(), TimeUnit.MILLISECONDS)) && logger.isDebugEnabled()) {
                            logger.debug((Object)("No consumer appeared for slop in " + this.voldemortConfig.getClientConnectionTimeoutMs() + " ms"));
                        }
                        this.readThrottler.maybeThrottle(this.nBytesRead(keyAndVal));
                        continue;
                    }
                    logger.trace((Object)(node + " declared down, won't push slop"));
                }
                catch (RejectedExecutionException e2) {
                    throw new VoldemortException("Ran out of threads in executor", e2);
                }
            }
            Object var15_19 = null;
            try {
                if (iterator != null) {
                    iterator.close();
                }
            }
            catch (Exception e3) {
                logger.warn((Object)"Failed to close iterator cleanly as database might be closed", (Throwable)e3);
            }
            for (SynchronousQueue slopQueue : this.slopQueues.values()) {
                try {
                    slopQueue.put(END);
                }
                catch (InterruptedException e4222) {
                    logger.warn((Object)"Error putting poison pill", (Throwable)e4222);
                }
            }
            for (Future result : this.consumerResults) {
                try {
                    result.get();
                }
                catch (Exception e4222) {
                    logger.warn((Object)"Exception in consumer", (Throwable)e4222);
                }
            }
            if (!terminatedEarly) {
                HashMap outstanding = Maps.newHashMapWithExpectedSize((int)this.cluster.getNumberOfNodes());
                Iterator i$ = this.succeededByNode.keySet().iterator();
                while (i$.hasNext()) {
                    int nodeId = (Integer)i$.next();
                    logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                    outstanding.put(nodeId, this.attemptedByNode.get(nodeId) - this.succeededByNode.get(nodeId));
                }
                slopStorageEngine.resetStats(outstanding);
                logger.info((Object)("Completed streaming slop pusher job which started at " + startTime));
            } else {
                Iterator<Object> i$ = this.succeededByNode.keySet().iterator();
                while (i$.hasNext()) {
                    int nodeId = (Integer)i$.next();
                    logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                }
                logger.info((Object)("Completed early streaming slop pusher job which started at " + startTime));
            }
            this.consumerResults.clear();
            this.slopQueues.clear();
            this.stopAdminClient();
            this.repairPermits.release();
            {
                break block65;
                catch (InterruptedException e5) {
                    Exception e4222;
                    logger.warn((Object)"Interrupted exception", (Throwable)e5);
                    terminatedEarly = true;
                    Object var15_20 = null;
                    try {
                        if (iterator != null) {
                            iterator.close();
                        }
                    }
                    catch (Exception e3) {
                        logger.warn((Object)"Failed to close iterator cleanly as database might be closed", (Throwable)e3);
                    }
                    for (SynchronousQueue slopQueue : this.slopQueues.values()) {
                        try {
                            slopQueue.put(END);
                        }
                        catch (InterruptedException e4222) {
                            logger.warn((Object)"Error putting poison pill", (Throwable)e4222);
                        }
                    }
                    for (Future result : this.consumerResults) {
                        try {
                            result.get();
                        }
                        catch (Exception e4222) {
                            logger.warn((Object)"Exception in consumer", (Throwable)e4222);
                        }
                    }
                    if (!terminatedEarly) {
                        HashMap outstanding = Maps.newHashMapWithExpectedSize((int)this.cluster.getNumberOfNodes());
                        Iterator i$ = this.succeededByNode.keySet().iterator();
                        while (i$.hasNext()) {
                            int nodeId = (Integer)i$.next();
                            logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                            outstanding.put(nodeId, this.attemptedByNode.get(nodeId) - this.succeededByNode.get(nodeId));
                        }
                        slopStorageEngine.resetStats(outstanding);
                        logger.info((Object)("Completed streaming slop pusher job which started at " + startTime));
                    } else {
                        Iterator<Object> i$ = this.succeededByNode.keySet().iterator();
                        while (i$.hasNext()) {
                            int nodeId = (Integer)i$.next();
                            logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                        }
                        logger.info((Object)("Completed early streaming slop pusher job which started at " + startTime));
                    }
                    this.consumerResults.clear();
                    this.slopQueues.clear();
                    this.stopAdminClient();
                    this.repairPermits.release();
                    break block65;
                }
                catch (Exception e6) {
                    Exception e4222;
                    logger.error((Object)e6, (Throwable)e6);
                    terminatedEarly = true;
                    Object var15_21 = null;
                    try {
                        if (iterator != null) {
                            iterator.close();
                        }
                    }
                    catch (Exception e3) {
                        logger.warn((Object)"Failed to close iterator cleanly as database might be closed", (Throwable)e3);
                    }
                    for (SynchronousQueue slopQueue : this.slopQueues.values()) {
                        try {
                            slopQueue.put(END);
                        }
                        catch (InterruptedException e4222) {
                            logger.warn((Object)"Error putting poison pill", (Throwable)e4222);
                        }
                    }
                    for (Future result : this.consumerResults) {
                        try {
                            result.get();
                        }
                        catch (Exception e4222) {
                            logger.warn((Object)"Exception in consumer", (Throwable)e4222);
                        }
                    }
                    if (!terminatedEarly) {
                        HashMap outstanding = Maps.newHashMapWithExpectedSize((int)this.cluster.getNumberOfNodes());
                        Iterator i$ = this.succeededByNode.keySet().iterator();
                        while (i$.hasNext()) {
                            int nodeId = (Integer)i$.next();
                            logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                            outstanding.put(nodeId, this.attemptedByNode.get(nodeId) - this.succeededByNode.get(nodeId));
                        }
                        slopStorageEngine.resetStats(outstanding);
                        logger.info((Object)("Completed streaming slop pusher job which started at " + startTime));
                    } else {
                        Iterator<Object> i$ = this.succeededByNode.keySet().iterator();
                        while (i$.hasNext()) {
                            int nodeId = (Integer)i$.next();
                            logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                        }
                        logger.info((Object)("Completed early streaming slop pusher job which started at " + startTime));
                    }
                    this.consumerResults.clear();
                    this.slopQueues.clear();
                    this.stopAdminClient();
                    this.repairPermits.release();
                }
            }
            catch (Throwable throwable) {
                Exception e4222;
                Object var15_22 = null;
                try {
                    if (iterator != null) {
                        iterator.close();
                    }
                }
                catch (Exception e3) {
                    logger.warn((Object)"Failed to close iterator cleanly as database might be closed", (Throwable)e3);
                }
                for (SynchronousQueue slopQueue : this.slopQueues.values()) {
                    try {
                        slopQueue.put(END);
                    }
                    catch (InterruptedException e4222) {
                        logger.warn((Object)"Error putting poison pill", (Throwable)e4222);
                    }
                }
                for (Future result : this.consumerResults) {
                    try {
                        result.get();
                    }
                    catch (Exception e4222) {
                        logger.warn((Object)"Exception in consumer", (Throwable)e4222);
                    }
                }
                if (!terminatedEarly) {
                    HashMap outstanding = Maps.newHashMapWithExpectedSize((int)this.cluster.getNumberOfNodes());
                    Iterator i$ = this.succeededByNode.keySet().iterator();
                    while (i$.hasNext()) {
                        int nodeId = (Integer)i$.next();
                        logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                        outstanding.put(nodeId, this.attemptedByNode.get(nodeId) - this.succeededByNode.get(nodeId));
                    }
                    slopStorageEngine.resetStats(outstanding);
                    logger.info((Object)("Completed streaming slop pusher job which started at " + startTime));
                } else {
                    Iterator<Object> i$ = this.succeededByNode.keySet().iterator();
                    while (i$.hasNext()) {
                        int nodeId = (Integer)i$.next();
                        logger.info((Object)("Slops to node " + nodeId + " - Succeeded - " + this.succeededByNode.get(nodeId) + " - Attempted - " + this.attemptedByNode.get(nodeId)));
                    }
                    logger.info((Object)("Completed early streaming slop pusher job which started at " + startTime));
                }
                this.consumerResults.clear();
                this.slopQueues.clear();
                this.stopAdminClient();
                this.repairPermits.release();
                throw throwable;
            }
        }
    }

    private void stopAdminClient() {
        if (this.adminClient != null) {
            this.adminClient.stop();
            this.adminClient = null;
        }
    }

    private int nBytesRead(Pair<ByteArray, Versioned<Slop>> keyAndVal) {
        return keyAndVal.getFirst().length() + this.slopSize(keyAndVal.getSecond());
    }

    private int slopSize(Versioned<Slop> slopVersioned) {
        int nBytes = 0;
        Slop slop = slopVersioned.getValue();
        nBytes += slop.getKey().length();
        nBytes += ((VectorClock)slopVersioned.getVersion()).sizeInBytes();
        switch (slop.getOperation()) {
            case PUT: {
                nBytes += slop.getValue().length;
                break;
            }
            case DELETE: {
                break;
            }
            default: {
                logger.error((Object)("Unknown slop operation: " + (Object)((Object)slop.getOperation())));
            }
        }
        return nBytes;
    }

    private void acquireRepairPermit() {
        logger.info((Object)"Acquiring lock to perform streaming slop pusher job ");
        try {
            this.repairPermits.acquire();
            logger.info((Object)"Acquired lock to perform streaming slop pusher job ");
        }
        catch (InterruptedException e) {
            this.stopAdminClient();
            throw new IllegalStateException("Streaming slop pusher job interrupted while waiting for permit.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlopConsumer
    implements Runnable {
        private final int nodeId;
        private SynchronousQueue<Versioned<Slop>> slopQueue;
        private long startTime;
        private SlopStorageEngine slopStorageEngine;
        private List<Pair<ByteArray, Version>> previous;
        private List<Pair<ByteArray, Version>> current;

        public SlopConsumer(int nodeId, SynchronousQueue<Versioned<Slop>> slopQueue, SlopStorageEngine slopStorageEngine) {
            this.nodeId = nodeId;
            this.slopQueue = slopQueue;
            this.slopStorageEngine = slopStorageEngine;
            this.previous = Lists.newArrayList();
            this.current = Lists.newArrayList();
        }

        @Override
        public void run() {
            try {
                Long succeeded;
                SlopIterator iterator = null;
                do {
                    if (!this.current.isEmpty()) {
                        if (!this.previous.isEmpty()) {
                            for (Pair<ByteArray, Version> entry : this.previous) {
                                this.slopStorageEngine.delete(entry.getFirst(), entry.getSecond());
                            }
                            succeeded = (Long)StreamingSlopPusherJob.this.succeededByNode.get(this.nodeId);
                            succeeded = succeeded + (long)this.previous.size();
                            StreamingSlopPusherJob.this.succeededByNode.put(this.nodeId, succeeded);
                            this.previous.clear();
                        }
                        this.previous = null;
                        this.previous = this.current;
                        this.current = Lists.newArrayList();
                    }
                    this.startTime = System.currentTimeMillis();
                    iterator = new SlopIterator(this.slopQueue, this.current);
                    StreamingSlopPusherJob.this.adminClient.updateSlopEntries(this.nodeId, (Iterator<Versioned<Slop>>)((Object)iterator));
                } while (!iterator.isComplete());
                if (!this.previous.isEmpty()) {
                    for (Pair<ByteArray, Version> entry : this.previous) {
                        this.slopStorageEngine.delete(entry.getFirst(), entry.getSecond());
                    }
                    succeeded = (Long)StreamingSlopPusherJob.this.succeededByNode.get(this.nodeId);
                    succeeded = succeeded + (long)this.previous.size();
                    StreamingSlopPusherJob.this.succeededByNode.put(this.nodeId, succeeded);
                    this.previous.clear();
                }
                if (!this.current.isEmpty()) {
                    for (Pair<ByteArray, Version> entry : this.current) {
                        this.slopStorageEngine.delete(entry.getFirst(), entry.getSecond());
                    }
                    succeeded = (Long)StreamingSlopPusherJob.this.succeededByNode.get(this.nodeId);
                    succeeded = succeeded + (long)this.current.size();
                    StreamingSlopPusherJob.this.succeededByNode.put(this.nodeId, succeeded);
                    this.current.clear();
                }
            }
            catch (UnreachableStoreException e) {
                StreamingSlopPusherJob.this.failureDetector.recordException(StreamingSlopPusherJob.this.metadataStore.getCluster().getNodeById(this.nodeId), System.currentTimeMillis() - this.startTime, e);
                throw e;
            }
            finally {
                this.slopQueue.clear();
                StreamingSlopPusherJob.this.slopQueues.remove(this.nodeId);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlopIterator
    extends AbstractIterator<Versioned<Slop>> {
        private final SynchronousQueue<Versioned<Slop>> slopQueue;
        private final List<Pair<ByteArray, Version>> deleteBatch;
        private final EventThrottler writeThrottler;
        private int writtenLast = 0;
        private long slopsDone = 0L;
        private boolean shutDown = false;
        private boolean isComplete = false;

        public SlopIterator(SynchronousQueue<Versioned<Slop>> slopQueue, List<Pair<ByteArray, Version>> deleteBatch) {
            this.slopQueue = slopQueue;
            this.deleteBatch = deleteBatch;
            this.writeThrottler = new EventThrottler(StreamingSlopPusherJob.this.voldemortConfig.getSlopMaxWriteBytesPerSec());
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        protected Versioned<Slop> computeNext() {
            try {
                Versioned<Slop> head = null;
                if (!this.shutDown) {
                    head = this.slopQueue.take();
                    if (head.equals(END)) {
                        this.shutDown = true;
                        this.isComplete = true;
                    } else {
                        ++this.slopsDone;
                        if (this.slopsDone % (long)StreamingSlopPusherJob.this.voldemortConfig.getSlopBatchSize() == 0L) {
                            this.shutDown = true;
                        }
                        this.writeThrottler.maybeThrottle(this.writtenLast);
                        this.writtenLast = StreamingSlopPusherJob.this.slopSize(head);
                        this.deleteBatch.add(Pair.create(head.getValue().makeKey(), head.getVersion()));
                        return head;
                    }
                }
                return (Versioned)this.endOfData();
            }
            catch (Exception e) {
                logger.error((Object)("Got an exception " + e));
                return (Versioned)this.endOfData();
            }
        }
    }
}

