/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler.slop;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.server.StoreRepository;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairJob
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)RepairJob.class.getName());
    public static final List<String> blackList = Arrays.asList("mysql", "krati", "read-only");
    private final Semaphore repairPermits;
    private final StoreRepository storeRepo;
    private final MetadataStore metadataStore;
    private final Map<String, Long> storeStats;

    public RepairJob(StoreRepository storeRepo, MetadataStore metadataStore, Semaphore repairPermits) {
        this.storeRepo = storeRepo;
        this.metadataStore = metadataStore;
        this.repairPermits = Utils.notNull(repairPermits);
        this.storeStats = Maps.newHashMap();
    }

    @JmxOperation(description="Get repair slops per store", impact=1)
    public long getRepairSlopsPerStore(String storeName) {
        if (!this.storeStats.containsKey(storeName)) {
            return 0L;
        }
        return this.storeStats.get(storeName);
    }

    @JmxGetter(name="totalRepairSlops", description="total repair slops")
    public long totalRepairSlops() {
        Long totalRepairSlops = new Long(0L);
        for (Long repairSlops : this.storeStats.values()) {
            totalRepairSlops = totalRepairSlops + repairSlops;
        }
        return totalRepairSlops;
    }

    public void resetStats(Map<String, Long> storeStatistics) {
        this.storeStats.putAll(storeStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.NORMAL_SERVER)) {
            logger.error((Object)"Cannot run repair job since Voldemort server is not in normal state");
            return;
        }
        ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator = null;
        Date startTime = new Date();
        boolean terminatedEarly = false;
        logger.info((Object)("Started repair job at " + startTime));
        HashMap localStats = Maps.newHashMap();
        for (StoreDefinition storeDef : this.metadataStore.getStoreDefList()) {
            localStats.put(storeDef.getName(), 0L);
        }
        this.acquireRepairPermit();
        try {
            RoutingStrategyFactory routingStrategyFactory = new RoutingStrategyFactory();
            StorageEngine<ByteArray, Slop, byte[]> slopStorageEngine = this.storeRepo.getSlopStore().asSlopStore();
            for (StoreDefinition storeDef : this.metadataStore.getStoreDefList()) {
                if (!this.isWritableStore(storeDef)) continue;
                logger.info((Object)("Repairing store " + storeDef.getName()));
                StorageEngine<ByteArray, byte[], byte[]> engine = this.storeRepo.getStorageEngine(storeDef.getName());
                iterator = engine.entries();
                RoutingStrategy routingStrategy = routingStrategyFactory.updateRoutingStrategy(storeDef, this.metadataStore.getCluster());
                long repairSlops = 0L;
                while (iterator.hasNext()) {
                    Pair keyAndVal = (Pair)iterator.next();
                    List<Node> nodes = routingStrategy.routeRequest(((ByteArray)keyAndVal.getFirst()).get());
                    if (this.hasDestination(nodes)) continue;
                    for (Node node : nodes) {
                        Slop slop = new Slop(storeDef.getName(), Slop.Operation.PUT, (ByteArray)keyAndVal.getFirst(), (byte[])((Versioned)keyAndVal.getSecond()).getValue(), null, node.getId(), new Date());
                        Versioned<Slop> slopVersioned = new Versioned<Slop>(slop, ((Versioned)keyAndVal.getSecond()).getVersion());
                        slopStorageEngine.put(slop.makeKey(), slopVersioned, null);
                        ++repairSlops;
                    }
                    engine.delete((ByteArray)keyAndVal.getFirst(), ((Versioned)keyAndVal.getSecond()).getVersion());
                }
                this.closeIterator(iterator);
                localStats.put(storeDef.getName(), repairSlops);
                logger.info((Object)("Completed store " + storeDef.getName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            terminatedEarly = true;
        }
        finally {
            this.closeIterator(iterator);
            if (!terminatedEarly) {
                this.resetStats(localStats);
            }
            this.repairPermits.release();
            logger.info((Object)("Completed repair job started at " + startTime));
        }
    }

    private void closeIterator(ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> iterator) {
        try {
            if (iterator != null) {
                iterator.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error in closing iterator", (Throwable)e);
        }
    }

    private boolean hasDestination(List<Node> nodes) {
        for (Node node : nodes) {
            if (node.getId() != this.metadataStore.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isWritableStore(StoreDefinition storeDef) {
        return !storeDef.isView() && !blackList.contains(storeDef.getType());
    }

    private void acquireRepairPermit() {
        logger.info((Object)"Acquiring lock to perform repair job ");
        try {
            this.repairPermits.acquire();
            logger.info((Object)"Acquired lock to perform repair job ");
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Repair job interrupted while waiting for permit.", e);
        }
    }
}

