/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler.slop;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.UnreachableStoreException;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.slop.Slop;
import voldemort.store.slop.SlopStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

public class BlockingSlopPusherJob
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)BlockingSlopPusherJob.class.getName());
    public static final String TYPE_NAME = "blocking";
    private final StoreRepository storeRepo;
    private final MetadataStore metadataStore;
    private final FailureDetector failureDetector;
    private final long maxWriteBytesPerSec;
    private final Semaphore repairPermits;

    public BlockingSlopPusherJob(StoreRepository storeRepo, MetadataStore metadataStore, FailureDetector failureDetector, VoldemortConfig voldemortConfig, Semaphore repairPermits) {
        this.storeRepo = storeRepo;
        this.metadataStore = metadataStore;
        this.repairPermits = Utils.notNull(repairPermits);
        this.failureDetector = failureDetector;
        this.maxWriteBytesPerSec = voldemortConfig.getSlopMaxWriteBytesPerSec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER)) {
            logger.error((Object)"Cannot run slop pusher job since Voldemort server is rebalancing");
            return;
        }
        logger.info((Object)("Started blocking slop pusher job at " + new Date()));
        Cluster cluster = this.metadataStore.getCluster();
        ClosableIterator<Pair<ByteArray, Versioned<Slop>>> iterator = null;
        HashMap attemptedByNode = Maps.newHashMapWithExpectedSize((int)cluster.getNumberOfNodes());
        HashMap succeededByNode = Maps.newHashMapWithExpectedSize((int)cluster.getNumberOfNodes());
        long slopsPushed = 0L;
        long attemptedPushes = 0L;
        for (Node node : cluster.getNodes()) {
            attemptedByNode.put(node.getId(), 0L);
            succeededByNode.put(node.getId(), 0L);
        }
        this.acquireRepairPermit();
        try {
            SlopStorageEngine slopStorageEngine = this.storeRepo.getSlopStore();
            StorageEngine<ByteArray, Slop, byte[]> slopStore = slopStorageEngine.asSlopStore();
            EventThrottler throttler = new EventThrottler(this.maxWriteBytesPerSec);
            iterator = slopStore.entries();
            while (iterator.hasNext()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Slop pusher job cancelled");
                }
                try {
                    Pair keyAndVal;
                    try {
                        keyAndVal = (Pair)iterator.next();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception in iterator, escaping the loop ", (Throwable)e);
                        break;
                    }
                    Versioned versioned = (Versioned)keyAndVal.getSecond();
                    Slop slop = (Slop)versioned.getValue();
                    int nodeId = slop.getNodeId();
                    Node node = cluster.getNodeById(nodeId);
                    if (++attemptedPushes % 10000L == 0L) {
                        logger.info((Object)("Attempted pushing " + attemptedPushes + " slops"));
                    }
                    Long attempted = (Long)attemptedByNode.get(nodeId);
                    attemptedByNode.put(nodeId, attempted + 1L);
                    if (!this.failureDetector.isAvailable(node)) continue;
                    Store<ByteArray, byte[], byte[]> store = this.storeRepo.getNodeStore(slop.getStoreName(), node.getId());
                    Long startNs = System.nanoTime();
                    int nBytes = 0;
                    try {
                        nBytes = slop.getKey().length();
                        if (slop.getOperation() == Slop.Operation.PUT) {
                            store.put(slop.getKey(), new Versioned<byte[]>(slop.getValue(), versioned.getVersion()), slop.getTransforms());
                            nBytes += slop.getValue().length + ((VectorClock)versioned.getVersion()).sizeInBytes() + 1;
                        } else if (slop.getOperation() == Slop.Operation.DELETE) {
                            nBytes += ((VectorClock)versioned.getVersion()).sizeInBytes() + 1;
                            store.delete(slop.getKey(), versioned.getVersion());
                        } else {
                            logger.error((Object)("Unknown slop operation: " + (Object)((Object)slop.getOperation())));
                            continue;
                        }
                        this.failureDetector.recordSuccess(node, this.deltaMs(startNs));
                        slopStore.delete(slop.makeKey(), versioned.getVersion());
                        ++slopsPushed;
                        Long succeeded = (Long)succeededByNode.get(nodeId);
                        succeededByNode.put(nodeId, succeeded + 1L);
                        throttler.maybeThrottle(nBytes);
                    }
                    catch (ObsoleteVersionException e) {
                        slopStore.delete(slop.makeKey(), versioned.getVersion());
                        ++slopsPushed;
                        Long succeeded = (Long)succeededByNode.get(nodeId);
                        succeededByNode.put(nodeId, succeeded + 1L);
                        throttler.maybeThrottle(nBytes);
                    }
                    catch (UnreachableStoreException e) {
                        this.failureDetector.recordException(node, this.deltaMs(startNs), e);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
            logger.log((Priority)(attemptedPushes > 0L ? Level.INFO : Level.DEBUG), (Object)("Attempted " + attemptedPushes + " hinted handoff pushes of which " + slopsPushed + " succeeded."));
            HashMap outstanding = Maps.newHashMapWithExpectedSize((int)cluster.getNumberOfNodes());
            Iterator i$ = succeededByNode.keySet().iterator();
            while (i$.hasNext()) {
                int nodeId = (Integer)i$.next();
                outstanding.put(nodeId, (Long)attemptedByNode.get(nodeId) - (Long)succeededByNode.get(nodeId));
            }
            slopStorageEngine.resetStats(outstanding);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                if (iterator != null) {
                    iterator.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to close iterator.", (Throwable)e);
            }
            this.repairPermits.release();
        }
    }

    private void acquireRepairPermit() {
        logger.info((Object)"Acquiring lock to perform blocking slop pusher job ");
        try {
            this.repairPermits.acquire();
            logger.info((Object)"Acquired lock to perform blocking slop pusher job ");
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Blocking slop pusher job interrupted while waiting for permit.", e);
        }
    }

    private long deltaMs(Long startNs) {
        return (System.nanoTime() - startNs) / 1000000L;
    }
}

