/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.scheduler;

import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import voldemort.store.StorageEngine;
import voldemort.utils.ClosableIterator;
import voldemort.utils.EventThrottler;
import voldemort.utils.Pair;
import voldemort.utils.Time;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCleanupJob<K, V, T>
implements Runnable {
    private static final Logger logger = Logger.getLogger(DataCleanupJob.class);
    private final StorageEngine<K, V, T> store;
    private final Semaphore cleanupPermits;
    private final long maxAgeMs;
    private final Time time;
    private final EventThrottler throttler;

    public DataCleanupJob(StorageEngine<K, V, T> store, Semaphore cleanupPermits, long maxAgeMs, Time time, EventThrottler throttler) {
        this.store = Utils.notNull(store);
        this.cleanupPermits = Utils.notNull(cleanupPermits);
        this.maxAgeMs = maxAgeMs;
        this.time = time;
        this.throttler = throttler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.acquireCleanupPermit();
        ClosableIterator<Pair<K, Versioned<V>>> iterator = null;
        try {
            logger.info((Object)("Starting data cleanup on store \"" + this.store.getName() + "\"..."));
            int deleted = 0;
            long now = this.time.getMilliseconds();
            iterator = this.store.entries();
            while (iterator.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    logger.info((Object)"Datacleanup job halted.");
                    return;
                }
                Pair keyAndVal = (Pair)iterator.next();
                VectorClock clock = (VectorClock)((Versioned)keyAndVal.getSecond()).getVersion();
                if (now - clock.getTimestamp() > this.maxAgeMs) {
                    this.store.delete(keyAndVal.getFirst(), clock);
                    if (++deleted % 10000 == 0) {
                        logger.debug((Object)("Deleted item " + deleted));
                    }
                }
                this.throttler.maybeThrottle(1);
            }
            logger.info((Object)("Data cleanup on store \"" + this.store.getName() + "\" is complete; " + deleted + " items deleted."));
        }
        catch (Exception e) {
            logger.error((Object)("Error in data cleanup job for store " + this.store.getName() + ": "), (Throwable)e);
        }
        finally {
            this.closeIterator(iterator);
            logger.info((Object)("Releasing lock  after data cleanup on \"" + this.store.getName() + "\"."));
            this.cleanupPermits.release();
        }
    }

    private void closeIterator(ClosableIterator<Pair<K, Versioned<V>>> iterator) {
        try {
            if (iterator != null) {
                iterator.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error in closing iterator " + this.store.getName() + " "), (Throwable)e);
        }
    }

    private void acquireCleanupPermit() {
        logger.info((Object)("Acquiring lock to perform data cleanup on \"" + this.store.getName() + "\"."));
        try {
            this.cleanupPermits.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Datacleanup interrupted while waiting for cleanup permit.", e);
        }
    }
}

