/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.rebalance;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.rebalance.AlreadyRebalancingException;
import voldemort.server.rebalance.RebalanceAsyncOperation;
import voldemort.store.StoreDefinition;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rebalancer
implements Runnable {
    private static final Logger logger = Logger.getLogger(Rebalancer.class);
    private final MetadataStore metadataStore;
    private final AsyncOperationService asyncService;
    private final VoldemortConfig voldemortConfig;
    private final StoreRepository storeRepository;
    private final Set<Integer> rebalancePermits = Collections.synchronizedSet(new HashSet());

    public Rebalancer(StoreRepository storeRepository, MetadataStore metadataStore, VoldemortConfig voldemortConfig, AsyncOperationService asyncService) {
        this.storeRepository = storeRepository;
        this.metadataStore = metadataStore;
        this.asyncService = asyncService;
        this.voldemortConfig = voldemortConfig;
    }

    public AsyncOperationService getAsyncOperationService() {
        return this.asyncService;
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public void run() {
    }

    public synchronized boolean acquireRebalancingPermit(int nodeId) {
        boolean added = this.rebalancePermits.add(nodeId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Acquiring rebalancing permit for node id " + nodeId + ", returned: " + added));
        }
        return added;
    }

    public synchronized void releaseRebalancingPermit(int nodeId) {
        boolean removed = this.rebalancePermits.remove(nodeId);
        logger.info((Object)("Releasing rebalancing permit for node id " + nodeId + ", returned: " + removed));
        if (!removed) {
            throw new VoldemortException(new IllegalStateException("Invalid state, must hold a permit to release"));
        }
    }

    public void rebalanceStateChange(Cluster cluster, List<RebalancePartitionsInfo> rebalancePartitionsInfo, boolean swapRO, boolean changeClusterMetadata, boolean changeRebalanceState, boolean rollback) {
        block25: {
            Cluster currentCluster = this.metadataStore.getCluster();
            logger.info((Object)("Doing rebalance state change with options [ cluster metadata change - " + changeClusterMetadata + " ], [ changing rebalancing state - " + changeRebalanceState + " ], [ changing swapping RO - " + swapRO + " ], [ rollback - " + rollback + " ]"));
            ArrayList completedRebalancePartitionsInfo = Lists.newArrayList();
            ArrayList swappedStoreNames = Lists.newArrayList();
            boolean completedClusterChange = false;
            try {
                if (changeClusterMetadata) {
                    this.changeCluster(cluster);
                    completedClusterChange = true;
                }
                if (swapRO) {
                    this.swapROStores(swappedStoreNames, false);
                }
                if (!changeRebalanceState) break block25;
                try {
                    if (!rollback) {
                        for (RebalancePartitionsInfo info : rebalancePartitionsInfo) {
                            this.metadataStore.addRebalancingState(info);
                            completedRebalancePartitionsInfo.add(info);
                        }
                    } else {
                        for (RebalancePartitionsInfo info : rebalancePartitionsInfo) {
                            this.metadataStore.deleteRebalancingState(info);
                            completedRebalancePartitionsInfo.add(info);
                        }
                    }
                }
                catch (Exception e) {
                    throw new VoldemortException(e);
                }
            }
            catch (VoldemortException e) {
                logger.error((Object)"Got exception while changing state, now rolling back changes", (Throwable)e);
                if (completedClusterChange) {
                    try {
                        this.changeCluster(currentCluster);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error while rolling back cluster metadata to " + currentCluster), (Throwable)exception);
                    }
                }
                if (swappedStoreNames.size() > 0) {
                    try {
                        this.swapROStores(swappedStoreNames, true);
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error while swapping back to old state ", (Throwable)exception);
                    }
                }
                if (completedRebalancePartitionsInfo.size() > 0) {
                    if (!rollback) {
                        for (RebalancePartitionsInfo info : completedRebalancePartitionsInfo) {
                            try {
                                this.metadataStore.deleteRebalancingState(info);
                            }
                            catch (Exception exception) {
                                logger.error((Object)("Error while deleting back rebalance info during error rollback " + info), (Throwable)exception);
                            }
                        }
                    } else {
                        for (RebalancePartitionsInfo info : completedRebalancePartitionsInfo) {
                            try {
                                this.metadataStore.addRebalancingState(info);
                            }
                            catch (Exception exception) {
                                logger.error((Object)("Error while adding back rebalance info during error rollback " + info), (Throwable)exception);
                            }
                        }
                    }
                }
                throw e;
            }
        }
    }

    private void swapROStores(List<String> swappedStoreNames, boolean useSwappedStoreNames) {
        try {
            for (StoreDefinition storeDef : this.metadataStore.getStoreDefList()) {
                if (storeDef.getType().compareTo("read-only") != 0 || useSwappedStoreNames && !swappedStoreNames.contains(storeDef.getName())) continue;
                ReadOnlyStorageEngine engine = (ReadOnlyStorageEngine)this.storeRepository.getStorageEngine(storeDef.getName());
                if (engine == null) {
                    throw new VoldemortException("Could not find storage engine for " + storeDef.getName() + " to swap ");
                }
                logger.info((Object)("Swapping RO store " + storeDef.getName()));
                engine.swapFiles(engine.getCurrentDirPath());
                if (useSwappedStoreNames) continue;
                swappedStoreNames.add(storeDef.getName());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while swapping RO store");
            throw new VoldemortException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeCluster(Cluster cluster) {
        try {
            this.metadataStore.writeLock.lock();
            try {
                VectorClock updatedVectorClock = ((VectorClock)this.metadataStore.get("cluster.xml", null).get(0).getVersion()).incremented(0, System.currentTimeMillis());
                logger.info((Object)("Switching metadata from " + this.metadataStore.getCluster() + " to " + cluster + " [ " + updatedVectorClock + " ]"));
                this.metadataStore.put("cluster.xml", Versioned.value(cluster, updatedVectorClock));
            }
            finally {
                this.metadataStore.writeLock.unlock();
            }
        }
        catch (Exception e) {
            logger.info((Object)("Error while changing cluster to " + cluster));
            throw new VoldemortException(e);
        }
    }

    public int rebalanceNode(RebalancePartitionsInfo stealInfo) {
        RebalancePartitionsInfo info = this.metadataStore.getRebalancerState().find(stealInfo.getDonorId());
        if (info == null) {
            throw new VoldemortException("Could not find plan " + stealInfo + " in the server state on " + this.metadataStore.getNodeId());
        }
        if (!info.equals(stealInfo)) {
            throw new VoldemortException("The plan in server state " + info + " is not the same as the process passed " + stealInfo);
        }
        if (!this.acquireRebalancingPermit(stealInfo.getDonorId())) {
            throw new AlreadyRebalancingException("Node " + this.metadataStore.getNodeId() + " is already rebalancing from donor " + info.getDonorId() + " with info " + info);
        }
        int requestId = this.asyncService.getUniqueRequestId();
        this.asyncService.submitOperation(requestId, new RebalanceAsyncOperation(this, this.voldemortConfig, this.metadataStore, requestId, info));
        return requestId;
    }
}

