/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.rebalance;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.admin.AsyncOperation;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.rebalance.VoldemortRebalancingException;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;

class RebalanceAsyncOperation
extends AsyncOperation {
    private static final Logger logger = Logger.getLogger(RebalanceAsyncOperation.class);
    private List<Integer> rebalanceStatusList;
    private AdminClient adminClient;
    private final ExecutorService executors;
    private final RebalancePartitionsInfo stealInfo;
    private final VoldemortConfig voldemortConfig;
    private final MetadataStore metadataStore;
    private Rebalancer rebalancer;

    protected ExecutorService createExecutors(int numThreads) {
        return Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(r.getClass().getName());
                return thread;
            }
        });
    }

    public RebalanceAsyncOperation(Rebalancer rebalancer, VoldemortConfig voldemortConfig, MetadataStore metadataStore, int requestId, RebalancePartitionsInfo stealInfo) {
        super(requestId, "Rebalance operation: " + stealInfo.toString());
        this.rebalancer = rebalancer;
        this.voldemortConfig = voldemortConfig;
        this.metadataStore = metadataStore;
        this.stealInfo = stealInfo;
        this.rebalanceStatusList = new ArrayList<Integer>();
        this.adminClient = null;
        this.executors = this.createExecutors(voldemortConfig.getMaxParallelStoresRebalancing());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operate() throws Exception {
        block5: {
            this.adminClient = RebalanceUtils.createTempAdminClient(this.voldemortConfig, this.metadataStore.getCluster(), this.voldemortConfig.getMaxParallelStoresRebalancing());
            final ArrayList<Exception> failures = new ArrayList<Exception>();
            try {
                for (final String storeName : ImmutableList.copyOf(this.stealInfo.getUnbalancedStoreList())) {
                    this.executors.submit(new Runnable(){

                        public void run() {
                            try {
                                boolean isReadOnlyStore = RebalanceAsyncOperation.this.metadataStore.getStoreDef(storeName).getType().compareTo("read-only") == 0;
                                logger.info((Object)(RebalanceAsyncOperation.this.getHeader(RebalanceAsyncOperation.this.stealInfo) + "Working on store " + storeName));
                                RebalanceAsyncOperation.this.rebalanceStore(storeName, RebalanceAsyncOperation.this.adminClient, RebalanceAsyncOperation.this.stealInfo, isReadOnlyStore);
                                RebalanceAsyncOperation.this.stealInfo.removeStore(storeName);
                                logger.info((Object)(RebalanceAsyncOperation.this.getHeader(RebalanceAsyncOperation.this.stealInfo) + "Completed working on store " + storeName));
                            }
                            catch (Exception e) {
                                logger.error((Object)(RebalanceAsyncOperation.this.getHeader(RebalanceAsyncOperation.this.stealInfo) + "Error while rebalancing for store " + storeName + " - " + e.getMessage()), (Throwable)e);
                                failures.add(e);
                            }
                        }
                    });
                }
                this.waitForShutdown();
                ArrayList unbalancedStores = Lists.newArrayList(this.stealInfo.getUnbalancedStoreList());
                if (unbalancedStores.isEmpty()) {
                    logger.info((Object)(this.getHeader(this.stealInfo) + "Rebalance of " + this.stealInfo + " completed successfully."));
                    this.updateStatus(this.getHeader(this.stealInfo) + "Rebalance of " + this.stealInfo + " completed successfully.");
                    this.metadataStore.deleteRebalancingState(this.stealInfo);
                    break block5;
                }
                throw new VoldemortRebalancingException(this.getHeader(this.stealInfo) + "Failed to rebalance task " + this.stealInfo, failures);
            }
            finally {
                logger.info((Object)(this.getHeader(this.stealInfo) + "Releasing permit for donor node " + this.stealInfo.getDonorId()));
                this.rebalancer.releaseRebalancingPermit(this.stealInfo.getDonorId());
                this.adminClient.stop();
                this.adminClient = null;
            }
        }
    }

    private void waitForShutdown() {
        try {
            this.executors.shutdown();
            this.executors.awaitTermination(this.voldemortConfig.getRebalancingTimeoutSec(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted while awaiting termination for executors.", (Throwable)e);
        }
    }

    public void stop() {
        this.updateStatus(this.getHeader(this.stealInfo) + "Stop called on rebalance operation");
        if (null != this.adminClient) {
            for (int asyncID : this.rebalanceStatusList) {
                this.adminClient.stopAsyncRequest(this.metadataStore.getNodeId(), asyncID);
            }
        }
        this.executors.shutdownNow();
    }

    private String getHeader(RebalancePartitionsInfo stealInfo) {
        return "Stealer " + stealInfo.getStealerId() + ", Donor " + stealInfo.getDonorId() + "] ";
    }

    private void rebalanceStore(String storeName, AdminClient adminClient, RebalancePartitionsInfo stealInfo, boolean isReadOnlyStore) {
        logger.info((Object)(this.getHeader(stealInfo) + "Starting partitions migration for store " + storeName + " from donor node " + stealInfo.getDonorId()));
        this.updateStatus(this.getHeader(stealInfo) + "Started partition migration for store " + storeName + " from donor node " + stealInfo.getDonorId());
        int asyncId = adminClient.migratePartitions(stealInfo.getDonorId(), this.metadataStore.getNodeId(), storeName, stealInfo.getReplicaToAddPartitionList(storeName), null, stealInfo.getInitialCluster(), true);
        this.rebalanceStatusList.add(asyncId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getHeader(stealInfo) + "Waiting for completion for " + storeName + " with async id " + asyncId));
        }
        adminClient.waitForCompletion(this.metadataStore.getNodeId(), asyncId, this.voldemortConfig.getRebalancingTimeoutSec(), TimeUnit.SECONDS, this.getStatus());
        this.rebalanceStatusList.remove((Object)asyncId);
        logger.info((Object)(this.getHeader(stealInfo) + "Completed partition migration for store " + storeName + " from donor node " + stealInfo.getDonorId()));
        this.updateStatus(this.getHeader(stealInfo) + "Completed partition migration for store " + storeName + " from donor node " + stealInfo.getDonorId());
        if (stealInfo.getReplicaToDeletePartitionList(storeName) != null && stealInfo.getReplicaToDeletePartitionList(storeName).size() > 0 && !isReadOnlyStore) {
            logger.info((Object)(this.getHeader(stealInfo) + "Deleting partitions for store " + storeName + " on donor node " + stealInfo.getDonorId()));
            this.updateStatus(this.getHeader(stealInfo) + "Deleting partitions for store " + storeName + " on donor node " + stealInfo.getDonorId());
            adminClient.deletePartitions(stealInfo.getDonorId(), storeName, stealInfo.getReplicaToDeletePartitionList(storeName), stealInfo.getInitialCluster(), null);
            logger.info((Object)(this.getHeader(stealInfo) + "Deleted partitions for store " + storeName + " on donor node " + stealInfo.getDonorId()));
            this.updateStatus(this.getHeader(stealInfo) + "Deleted partitions for store " + storeName + " on donor node " + stealInfo.getDonorId());
        }
        logger.info((Object)(this.getHeader(stealInfo) + "Finished all migration for store " + storeName));
        this.updateStatus(this.getHeader(stealInfo) + "Finished all migration for store " + storeName);
    }
}

