/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.protocol.vold;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.server.RequestRoutingType;
import voldemort.server.StoreRepository;
import voldemort.server.protocol.AbstractRequestHandler;
import voldemort.server.protocol.RequestHandler;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.Store;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteBufferBackedInputStream;
import voldemort.utils.ByteUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortNativeRequestHandler
extends AbstractRequestHandler
implements RequestHandler {
    private final Logger logger = Logger.getLogger(VoldemortNativeRequestHandler.class);
    private final int protocolVersion;

    public VoldemortNativeRequestHandler(ErrorCodeMapper errorMapper, StoreRepository repository, int protocolVersion) {
        super(errorMapper, repository);
        if (protocolVersion < 0 || protocolVersion > 3) {
            throw new IllegalArgumentException("Unknown protocol version: " + protocolVersion);
        }
        this.protocolVersion = protocolVersion;
    }

    @Override
    public StreamRequestHandler handleRequest(DataInputStream inputStream, DataOutputStream outputStream) throws IOException {
        RequestRoutingType routingType;
        byte opCode = inputStream.readByte();
        String storeName = inputStream.readUTF();
        Store<ByteArray, byte[], byte[]> store = this.getStore(storeName, routingType = this.getRoutingType(inputStream));
        if (store == null) {
            this.writeException(outputStream, new VoldemortException("No store named '" + storeName + "'."));
        } else {
            switch (opCode) {
                case 1: {
                    this.handleGet(inputStream, outputStream, store);
                    break;
                }
                case 4: {
                    this.handleGetAll(inputStream, outputStream, store);
                    break;
                }
                case 2: {
                    this.handlePut(inputStream, outputStream, store);
                    break;
                }
                case 3: {
                    this.handleDelete(inputStream, outputStream, store);
                    break;
                }
                case 10: {
                    this.handleGetVersion(inputStream, outputStream, store);
                    break;
                }
                default: {
                    throw new IOException("Unknown op code: " + opCode);
                }
            }
        }
        outputStream.flush();
        return null;
    }

    private RequestRoutingType getRoutingType(DataInputStream inputStream) throws IOException {
        RequestRoutingType routingType = RequestRoutingType.NORMAL;
        if (this.protocolVersion > 0) {
            boolean isRouted = inputStream.readBoolean();
            routingType = RequestRoutingType.getRequestRoutingType(isRouted, false);
        }
        if (this.protocolVersion > 1) {
            byte routingTypeCode = inputStream.readByte();
            routingType = RequestRoutingType.getRequestRoutingType(routingTypeCode);
        }
        return routingType;
    }

    private void handleGetVersion(DataInputStream inputStream, DataOutputStream outputStream, Store<ByteArray, byte[], byte[]> store) throws IOException {
        ByteArray key = this.readKey(inputStream);
        List<Version> results = null;
        try {
            results = store.getVersions(key);
            outputStream.writeShort(0);
        }
        catch (VoldemortException e) {
            this.logger.error((Object)e.getMessage());
            this.writeException(outputStream, e);
            return;
        }
        outputStream.writeInt(results.size());
        for (Version v : results) {
            byte[] clock = ((VectorClock)v).toBytes();
            outputStream.writeInt(clock.length);
            outputStream.write(clock);
        }
    }

    @Override
    public boolean isCompleteRequest(ByteBuffer buffer) {
        DataInputStream inputStream = new DataInputStream(new ByteBufferBackedInputStream(buffer));
        try {
            byte opCode = inputStream.readByte();
            inputStream.readUTF();
            if (this.protocolVersion > 0) {
                boolean routed = inputStream.readBoolean();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("isRouted=" + routed));
                }
            }
            if (this.protocolVersion > 1) {
                byte routingTypeCode = inputStream.readByte();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("routingTypeCode=" + routingTypeCode));
                }
            }
            switch (opCode) {
                case 10: {
                    this.readKey(inputStream);
                    break;
                }
                case 1: {
                    boolean hasTransform;
                    this.readKey(inputStream);
                    if (this.protocolVersion <= 2 || !(hasTransform = inputStream.readBoolean())) break;
                    this.readTransforms(inputStream);
                    break;
                }
                case 4: {
                    boolean hasTransform;
                    int numKeys = inputStream.readInt();
                    for (int i = 0; i < numKeys; ++i) {
                        this.readKey(inputStream);
                    }
                    if (this.protocolVersion <= 2 || !(hasTransform = inputStream.readBoolean())) break;
                    int numTrans = inputStream.readInt();
                    for (int i = 0; i < numTrans; ++i) {
                        this.readTransforms(inputStream);
                    }
                    break;
                }
                case 2: {
                    boolean hasTransform;
                    this.readKey(inputStream);
                    int dataSize = inputStream.readInt();
                    int newPosition = buffer.position() + dataSize;
                    if (newPosition > buffer.limit() || newPosition < 0) {
                        throw new Exception("Data inconsistency on put - dataSize: " + dataSize + ", position: " + buffer.position() + ", limit: " + buffer.limit());
                    }
                    buffer.position(newPosition);
                    if (this.protocolVersion <= 2 || !(hasTransform = inputStream.readBoolean())) break;
                    this.readTransforms(inputStream);
                    break;
                }
                case 3: {
                    this.readKey(inputStream);
                    short versionSize = inputStream.readShort();
                    int newPosition = buffer.position() + versionSize;
                    if (newPosition > buffer.limit() || newPosition < 0) {
                        throw new Exception("Data inconsistency on delete - versionSize: " + versionSize + ", position: " + buffer.position() + ", limit: " + buffer.limit());
                    }
                    buffer.position(newPosition);
                    break;
                }
            }
            return !buffer.hasRemaining();
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Probable partial read occurred causing exception", (Throwable)e);
            }
            return false;
        }
    }

    private ByteArray readKey(DataInputStream inputStream) throws IOException {
        int keySize = inputStream.readInt();
        byte[] key = new byte[keySize];
        inputStream.readFully(key);
        return new ByteArray(key);
    }

    private byte[] readTransforms(DataInputStream inputStream) throws IOException {
        int size = inputStream.readInt();
        if (size == 0) {
            return null;
        }
        byte[] transforms = new byte[size];
        inputStream.readFully(transforms);
        return transforms;
    }

    private void writeResults(DataOutputStream outputStream, List<Versioned<byte[]>> values) throws IOException {
        outputStream.writeInt(values.size());
        for (Versioned<byte[]> v : values) {
            byte[] clock = ((VectorClock)v.getVersion()).toBytes();
            byte[] value = v.getValue();
            outputStream.writeInt(clock.length + value.length);
            outputStream.write(clock);
            outputStream.write(value);
        }
    }

    private void handleGet(DataInputStream inputStream, DataOutputStream outputStream, Store<ByteArray, byte[], byte[]> store) throws IOException {
        ByteArray key = this.readKey(inputStream);
        byte[] transforms = null;
        if (this.protocolVersion > 2 && inputStream.readBoolean()) {
            transforms = this.readTransforms(inputStream);
        }
        List<Versioned<byte[]>> results = null;
        try {
            results = store.get(key, transforms);
            outputStream.writeShort(0);
        }
        catch (VoldemortException e) {
            this.logger.error((Object)e.getMessage());
            this.writeException(outputStream, e);
            return;
        }
        this.writeResults(outputStream, results);
    }

    private void handleGetAll(DataInputStream inputStream, DataOutputStream outputStream, Store<ByteArray, byte[], byte[]> store) throws IOException {
        int numKeys = inputStream.readInt();
        ArrayList<ByteArray> keys = new ArrayList<ByteArray>(numKeys);
        for (int i = 0; i < numKeys; ++i) {
            keys.add(this.readKey(inputStream));
        }
        HashMap<ByteArray, byte[]> transforms = null;
        if (this.protocolVersion > 2 && inputStream.readBoolean()) {
            int size = inputStream.readInt();
            transforms = new HashMap<ByteArray, byte[]>(size);
            for (int i = 0; i < size; ++i) {
                transforms.put(this.readKey(inputStream), this.readTransforms(inputStream));
            }
        }
        Map<ByteArray, List<Versioned<byte[]>>> results = null;
        try {
            results = store.getAll(keys, transforms);
            outputStream.writeShort(0);
        }
        catch (VoldemortException e) {
            this.logger.error((Object)e.getMessage());
            this.writeException(outputStream, e);
            return;
        }
        outputStream.writeInt(results.size());
        for (Map.Entry<ByteArray, List<Versioned<byte[]>>> entry : results.entrySet()) {
            outputStream.writeInt(entry.getKey().length());
            outputStream.write(entry.getKey().get());
            this.writeResults(outputStream, entry.getValue());
        }
    }

    private void handlePut(DataInputStream inputStream, DataOutputStream outputStream, Store<ByteArray, byte[], byte[]> store) throws IOException {
        ByteArray key = this.readKey(inputStream);
        int valueSize = inputStream.readInt();
        byte[] bytes = new byte[valueSize];
        ByteUtils.read(inputStream, bytes);
        VectorClock clock = new VectorClock(bytes);
        byte[] value = ByteUtils.copy(bytes, clock.sizeInBytes(), bytes.length);
        byte[] transforms = null;
        if (this.protocolVersion > 2 && inputStream.readBoolean()) {
            transforms = this.readTransforms(inputStream);
        }
        try {
            store.put(key, new Versioned<byte[]>(value, clock), transforms);
            outputStream.writeShort(0);
        }
        catch (VoldemortException e) {
            this.writeException(outputStream, e);
        }
    }

    private void handleDelete(DataInputStream inputStream, DataOutputStream outputStream, Store<ByteArray, byte[], byte[]> store) throws IOException {
        ByteArray key = this.readKey(inputStream);
        short versionSize = inputStream.readShort();
        byte[] versionBytes = new byte[versionSize];
        ByteUtils.read(inputStream, versionBytes);
        VectorClock version = new VectorClock(versionBytes);
        try {
            boolean succeeded = store.delete(key, version);
            outputStream.writeShort(0);
            outputStream.writeBoolean(succeeded);
        }
        catch (VoldemortException e) {
            this.writeException(outputStream, e);
        }
    }

    private void writeException(DataOutputStream stream, VoldemortException e) throws IOException {
        short code = this.getErrorMapper().getCode(e);
        stream.writeShort(code);
        stream.writeUTF(e.getMessage());
    }
}

