/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.niosocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormatType;
import voldemort.server.protocol.RequestHandler;
import voldemort.server.protocol.RequestHandlerFactory;
import voldemort.server.protocol.StreamRequestHandler;
import voldemort.utils.ByteUtils;
import voldemort.utils.SelectorManagerWorker;

public class AsyncRequestHandler
extends SelectorManagerWorker {
    private final RequestHandlerFactory requestHandlerFactory;
    private RequestHandler requestHandler;
    private StreamRequestHandler streamRequestHandler;

    public AsyncRequestHandler(Selector selector, SocketChannel socketChannel, RequestHandlerFactory requestHandlerFactory, int socketBufferSize) {
        super(selector, socketChannel, socketBufferSize);
        this.requestHandlerFactory = requestHandlerFactory;
    }

    protected void read(SelectionKey selectionKey) throws IOException {
        int count = 0;
        count = this.socketChannel.read(this.inputStream.getBuffer());
        if (count == -1) {
            throw new EOFException("EOF for " + this.socketChannel.socket());
        }
        if (this.logger.isTraceEnabled()) {
            this.traceInputBufferState("Read " + count + " bytes");
        }
        if (count == 0) {
            return;
        }
        int position = this.inputStream.getBuffer().position();
        this.inputStream.getBuffer().flip();
        if (this.requestHandler == null && !this.initRequestHandler(selectionKey)) {
            return;
        }
        if (this.streamRequestHandler != null) {
            this.handleStreamRequest(selectionKey);
            return;
        }
        if (!this.requestHandler.isCompleteRequest(this.inputStream.getBuffer())) {
            this.handleIncompleteRequest(position);
            return;
        }
        this.inputStream.getBuffer().rewind();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Starting execution for " + this.socketChannel.socket()));
        }
        this.streamRequestHandler = this.requestHandler.handleRequest(new DataInputStream(this.inputStream), new DataOutputStream(this.outputStream));
        if (this.streamRequestHandler != null) {
            this.handleStreamRequest(selectionKey);
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Finished execution for " + this.socketChannel.socket()));
        }
        this.prepForWrite(selectionKey);
    }

    /*
     * Unable to fully structure code
     */
    protected void write(SelectionKey selectionKey) throws IOException {
        if (this.outputStream.getBuffer().hasRemaining()) {
            try {
                count = this.socketChannel.write(this.outputStream.getBuffer());
                if (!this.logger.isTraceEnabled()) ** GOTO lbl14
                this.logger.trace((Object)("Wrote " + count + " bytes, remaining: " + this.outputStream.getBuffer().remaining() + " for " + this.socketChannel.socket()));
            }
            catch (IOException e) {
                if (this.streamRequestHandler != null) {
                    this.streamRequestHandler.close(new DataOutputStream(this.outputStream));
                    this.streamRequestHandler = null;
                }
                throw e;
            }
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Wrote no bytes for " + this.socketChannel.socket()));
        }
lbl14:
        // 5 sources

        if (this.outputStream.getBuffer().hasRemaining()) {
            return;
        }
        if (this.outputStream.getBuffer().capacity() >= this.resizeThreshold) {
            this.outputStream.setBuffer(ByteBuffer.allocate(this.socketBufferSize));
        } else {
            this.outputStream.getBuffer().clear();
        }
        if (this.streamRequestHandler != null && this.streamRequestHandler.getDirection() == StreamRequestHandler.StreamRequestDirection.WRITING) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Request is streaming for " + this.socketChannel.socket()));
            }
            this.handleStreamRequest(selectionKey);
        } else {
            selectionKey.interestOps(1);
        }
    }

    private void handleStreamRequest(SelectionKey selectionKey) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.inputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(this.outputStream);
        int preRequestPosition = this.inputStream.getBuffer().position();
        StreamRequestHandler.StreamRequestHandlerState state = this.handleStreamRequestInternal(selectionKey, dataInputStream, dataOutputStream);
        if (state == StreamRequestHandler.StreamRequestHandlerState.READING) {
            do {
                preRequestPosition = this.inputStream.getBuffer().position();
            } while ((state = this.handleStreamRequestInternal(selectionKey, dataInputStream, dataOutputStream)) == StreamRequestHandler.StreamRequestHandlerState.READING);
        } else if (state == StreamRequestHandler.StreamRequestHandlerState.WRITING) {
            while ((state = this.handleStreamRequestInternal(selectionKey, dataInputStream, dataOutputStream)) == StreamRequestHandler.StreamRequestHandlerState.WRITING && !this.outputStream.wasExpanded()) {
            }
            if (state != StreamRequestHandler.StreamRequestHandlerState.COMPLETE) {
                this.prepForWrite(selectionKey);
            }
        }
        if (state == null) {
            return;
        }
        if (state == StreamRequestHandler.StreamRequestHandlerState.INCOMPLETE_READ) {
            int currentPosition = this.inputStream.getBuffer().position();
            this.inputStream.getBuffer().position(preRequestPosition);
            this.inputStream.getBuffer().compact();
            this.handleIncompleteRequest(currentPosition - preRequestPosition);
        } else if (state == StreamRequestHandler.StreamRequestHandlerState.COMPLETE) {
            this.streamRequestHandler.close(dataOutputStream);
            this.streamRequestHandler = null;
            this.prepForWrite(selectionKey);
        }
    }

    private StreamRequestHandler.StreamRequestHandlerState handleStreamRequestInternal(SelectionKey selectionKey, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        StreamRequestHandler.StreamRequestHandlerState state = null;
        try {
            if (this.logger.isTraceEnabled()) {
                this.traceInputBufferState("Before streaming request handler");
            }
            state = this.streamRequestHandler.handleRequest(dataInputStream, dataOutputStream);
            if (this.logger.isTraceEnabled()) {
                this.traceInputBufferState("After streaming request handler");
            }
        }
        catch (Exception e) {
            if (this.logger.isEnabledFor((Priority)Level.WARN)) {
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            VoldemortException error = e instanceof VoldemortException ? (VoldemortException)e : new VoldemortException(e);
            this.streamRequestHandler.handleError(dataOutputStream, error);
            this.streamRequestHandler.close(dataOutputStream);
            this.streamRequestHandler = null;
            this.prepForWrite(selectionKey);
            this.close();
        }
        return state;
    }

    private boolean initRequestHandler(SelectionKey selectionKey) {
        ByteBuffer inputBuffer = this.inputStream.getBuffer();
        int remaining = inputBuffer.remaining();
        if (remaining < 3) {
            return true;
        }
        byte[] protoBytes = new byte[]{inputBuffer.get(0), inputBuffer.get(1), inputBuffer.get(2)};
        try {
            String proto = ByteUtils.getString(protoBytes, "UTF-8");
            RequestFormatType requestFormatType = RequestFormatType.fromCode(proto);
            this.requestHandler = this.requestHandlerFactory.getRequestHandler(requestFormatType);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Protocol negotiated for " + this.socketChannel.socket() + ": " + requestFormatType.getDisplayName()));
            }
            this.outputStream.getBuffer().put(ByteUtils.getBytes("ok", "UTF-8"));
            this.prepForWrite(selectionKey);
            return false;
        }
        catch (IllegalArgumentException e) {
            RequestFormatType requestFormatType = RequestFormatType.VOLDEMORT_V0;
            this.requestHandler = this.requestHandlerFactory.getRequestHandler(requestFormatType);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("No protocol proposal given for " + this.socketChannel.socket() + ", assuming " + requestFormatType.getDisplayName()));
            }
            return true;
        }
    }
}

