/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.cluster.Cluster;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortServer;
import voldemort.server.VoldemortService;
import voldemort.store.StorageEngine;
import voldemort.utils.JmxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="The JMX service")
public class JmxService
extends AbstractService {
    private final Logger logger = Logger.getLogger(JmxService.class);
    private final MBeanServer mbeanServer;
    private final VoldemortServer server;
    private final Cluster cluster;
    private final List<VoldemortService> services;
    private final Set<ObjectName> registeredBeans;
    private final StoreRepository storeRepository;

    public JmxService(VoldemortServer server, Cluster cluster, StoreRepository storeRepository, Collection<VoldemortService> services) {
        super(ServiceType.JMX);
        this.server = server;
        this.cluster = cluster;
        this.services = new ArrayList<VoldemortService>(services);
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registeredBeans = new HashSet<ObjectName>();
        this.storeRepository = storeRepository;
    }

    @Override
    protected void startInner() {
        this.registerBean(this.server, JmxUtils.createObjectName(VoldemortServer.class));
        this.registerBean(this.cluster, JmxUtils.createObjectName(Cluster.class));
        for (VoldemortService voldemortService : this.services) {
            this.registerBean(voldemortService, JmxUtils.createObjectName(voldemortService.getClass()));
        }
        for (StorageEngine storageEngine : this.storeRepository.getAllStorageEngines()) {
            this.registerBean(storageEngine, JmxUtils.createObjectName(JmxUtils.getPackageName(storageEngine.getClass()), storageEngine.getName()));
        }
    }

    @Override
    protected void stopInner() {
        for (ObjectName name : this.registeredBeans) {
            JmxUtils.unregisterMbean(this.mbeanServer, name);
        }
        this.registeredBeans.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBean(Object o, ObjectName name) {
        Set<ObjectName> set = this.registeredBeans;
        synchronized (set) {
            try {
                if (this.mbeanServer.isRegistered(name)) {
                    this.logger.warn((Object)("Overwriting mbean " + name));
                    JmxUtils.unregisterMbean(this.mbeanServer, name);
                }
                JmxUtils.registerMbean(this.mbeanServer, JmxUtils.createModelMBean(o), name);
                this.registeredBeans.add(name);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error registering bean with name '" + name + "':"), (Throwable)e);
            }
        }
    }
}

