/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortServer;
import voldemort.server.http.gui.VelocityEngine;
import voldemort.server.storage.StorageService;
import voldemort.store.StorageEngine;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.readonly.FileFetcher;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.Props;
import voldemort.utils.ReflectUtils;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStoreManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ReadOnlyStoreManagementServlet.class);
    private volatile List<ReadOnlyStorageEngine> stores;
    private VelocityEngine velocityEngine;
    private FileFetcher fileFetcher;
    private MetadataStore metadataStore;

    public ReadOnlyStoreManagementServlet() {
    }

    public ReadOnlyStoreManagementServlet(VoldemortServer server, VelocityEngine engine) {
        this.stores = this.getReadOnlyStores(server);
        this.velocityEngine = Utils.notNull(engine);
        this.setFetcherClass(server);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        VoldemortServer server = (VoldemortServer)config.getServletContext().getAttribute("vldmt_server");
        this.initMetadataStore(server);
        this.initStores(server);
        this.initVelocity(config);
        this.setFetcherClass(server);
    }

    public void initMetadataStore(VoldemortServer server) {
        this.metadataStore = Utils.notNull(server).getMetadataStore();
    }

    public void initStores(VoldemortServer server) {
        this.stores = this.getReadOnlyStores(server);
    }

    public void initVelocity(ServletConfig config) {
        this.velocityEngine = (VelocityEngine)Utils.notNull(config.getServletContext().getAttribute("vldmt_velocity_engine"));
    }

    private void setFetcherClass(VoldemortServer server) {
        String className = server.getVoldemortConfig().getAllProps().getString("file.fetcher.class", null);
        if (className == null || className.trim().length() == 0) {
            this.fileFetcher = null;
        } else {
            try {
                logger.info((Object)("Loading fetcher " + className));
                Class<?> cls = Class.forName(className.trim());
                this.fileFetcher = (FileFetcher)ReflectUtils.callConstructor(cls, new Class[]{Props.class}, new Object[]{server.getVoldemortConfig().getAllProps()});
            }
            catch (Exception e) {
                throw new VoldemortException("Error loading file fetcher class " + className, e);
            }
        }
    }

    private List<ReadOnlyStorageEngine> getReadOnlyStores(VoldemortServer server) {
        StorageService storage = (StorageService)Utils.notNull(server).getService(ServiceType.STORAGE);
        ArrayList l = Lists.newArrayList();
        for (StorageEngine<ByteArray, byte[], byte[]> engine : storage.getStoreRepository().getStorageEnginesByClass(ReadOnlyStorageEngine.class)) {
            l.add((ReadOnlyStorageEngine)engine);
        }
        return l;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap params = Maps.newHashMap();
        params.put("stores", this.stores);
        this.velocityEngine.render("read-only-mgmt.vm", params, (OutputStream)resp.getOutputStream());
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block6: {
            try {
                String operation = this.getRequired(req, "operation").toLowerCase();
                if ("swap".equals(operation)) {
                    this.doSwap(req, resp);
                    break block6;
                }
                if ("fetch".equals(operation)) {
                    this.doFetch(req, resp);
                    break block6;
                }
                if ("rollback".equals(operation)) {
                    this.doRollback(req);
                    break block6;
                }
                if ("failed-fetch".equals(operation)) {
                    this.doFailedFetch(req);
                    break block6;
                }
                throw new IllegalArgumentException("Unknown operation parameter: " + req.getParameter("operation"));
            }
            catch (Exception e) {
                logger.error((Object)"Error while performing operation.", (Throwable)e);
                resp.sendError(500, "Error while performing operation: " + e.getMessage());
            }
        }
    }

    private void doFailedFetch(HttpServletRequest req) throws ServletException {
        String dir = this.getRequired(req, "dir");
        String storeName = this.getRequired(req, "store");
        try {
            if (!Utils.isReadableDir(dir)) {
                throw new ServletException("Could not read folder " + dir + " correctly to delete it");
            }
            ReadOnlyStorageEngine store = this.getStore(storeName);
            if (store.getCurrentVersionId() == ReadOnlyUtils.getVersionId(new File(dir))) {
                logger.warn((Object)("Cannot delete " + dir + " for " + storeName + " since it is the current dir"));
                return;
            }
            Utils.rm(new File(dir));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void doSwap(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        String dir = this.getRequired(req, "dir");
        String storeName = this.getRequired(req, "store");
        if (this.metadataStore != null && !this.metadataStore.getServerState().equals((Object)MetadataStore.VoldemortState.NORMAL_SERVER)) {
            throw new ServletException("Voldemort server not in normal state");
        }
        ReadOnlyStorageEngine store = this.getStore(storeName);
        if (store == null) {
            throw new ServletException("'" + storeName + "' is not a registered read-only store.");
        }
        if (!Utils.isReadableDir(dir)) {
            throw new ServletException("Store directory '" + dir + "' is not a readable directory.");
        }
        String currentDirPath = store.getCurrentDirPath();
        store.swapFiles(dir);
        resp.getWriter().write(currentDirPath);
    }

    private void doFetch(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        long pushVersion;
        String fetchUrl = this.getRequired(req, "dir");
        String storeName = this.getRequired(req, "store");
        String pushVersionString = this.getOptional(req, "pushVersion");
        ReadOnlyStorageEngine store = this.getStore(storeName);
        if (store == null) {
            throw new ServletException("'" + storeName + "' is not a registered read-only store.");
        }
        if (pushVersionString == null) {
            File[] storeDirList = ReadOnlyUtils.getVersionDirs(new File(store.getStoreDirPath()));
            if (storeDirList == null || storeDirList.length == 0) {
                throw new ServletException("Push version required since no version folders exist");
            }
            long maxVersion = ReadOnlyUtils.getVersionId(ReadOnlyUtils.findKthVersionedDir(storeDirList, storeDirList.length - 1, storeDirList.length - 1)[0]);
            pushVersion = maxVersion + 1L;
        } else {
            pushVersion = Long.parseLong(pushVersionString);
            if (pushVersion <= store.getCurrentVersionId()) {
                throw new ServletException("Version of push specified (" + pushVersion + ") should be greater than current version " + store.getCurrentVersionId());
            }
        }
        File fetchDir = null;
        if (this.fileFetcher == null) {
            logger.warn((Object)"File fetcher class has not instantiated correctly. Assuming local file");
            if (!Utils.isReadableDir(fetchUrl)) {
                throw new ServletException("Fetch url " + fetchUrl + " is not readable");
            }
            fetchDir = new File(store.getStoreDirPath(), "version-" + Long.toString(pushVersion));
            if (fetchDir.exists()) {
                throw new ServletException("Version directory " + fetchDir.getAbsolutePath() + " already exists");
            }
            Utils.move(new File(fetchUrl), fetchDir);
        } else {
            logger.info((Object)("Executing fetch of " + fetchUrl));
            try {
                fetchDir = this.fileFetcher.fetch(fetchUrl, store.getStoreDirPath() + File.separator + "version-" + Long.toString(pushVersion));
                if (fetchDir == null) {
                    throw new ServletException("File fetcher failed for " + fetchUrl + " and store name = " + storeName + " due to incorrect input path/checksum error");
                }
                logger.info((Object)"Fetch complete.");
            }
            catch (Exception e) {
                throw new ServletException("Exception in Fetcher = " + e.getMessage());
            }
        }
        resp.getWriter().write(fetchDir.getAbsolutePath());
    }

    private void doRollback(HttpServletRequest req) throws ServletException {
        String storeName = this.getRequired(req, "store");
        long pushVersion = Long.parseLong(this.getRequired(req, "pushVersion"));
        ReadOnlyStorageEngine store = this.getStore(storeName);
        if (store == null) {
            throw new ServletException("'" + storeName + "' is not a registered read-only store.");
        }
        try {
            File rollbackVersionDir = new File(store.getStoreDirPath(), "version-" + pushVersion);
            store.rollback(rollbackVersionDir);
        }
        catch (Exception e) {
            throw new ServletException("Exception in rollback = " + e.getMessage());
        }
    }

    private String getOptional(HttpServletRequest req, String name) {
        return req.getParameter(name);
    }

    private String getRequired(HttpServletRequest req, String name) throws ServletException {
        String val = req.getParameter(name);
        if (val == null) {
            throw new ServletException("Missing required parameter '" + name + "'.");
        }
        return val;
    }

    private ReadOnlyStorageEngine getStore(String storeName) throws ServletException {
        for (ReadOnlyStorageEngine store : this.stores) {
            if (!store.getName().equals(storeName)) continue;
            return store;
        }
        throw new ServletException("'" + storeName + "' is not a registered read-only store.");
    }
}

