/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http.gui;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import voldemort.client.ClientConfig;
import voldemort.client.HttpStoreClientFactory;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.server.http.gui.VelocityEngine;

public class QueryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private VelocityEngine engine;
    private StoreClientFactory clientFactory;

    public QueryServlet() {
    }

    public QueryServlet(VelocityEngine engine, URI bootstrap) {
        this.engine = engine;
        this.clientFactory = new HttpStoreClientFactory(new ClientConfig().setBootstrapUrls(bootstrap.toString()).setMaxThreads(1));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
        HashMap m = Maps.newHashMap();
        this.engine.render("query.vm", m, (OutputStream)resp.getOutputStream());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doPost(req, resp);
        String storeName = req.getParameter("store");
        String key = req.getParameter("key");
        String keyType = req.getParameter("key_type");
        String value = req.getParameter("value");
        String action = req.getParameter("action");
        Object keyObj = this.parseKey(keyType, key);
        HashMap<String, Object> params = new HashMap<String, Object>();
        StoreClient client = this.clientFactory.getStoreClient(storeName);
        this.engine.render("query.vm", params, (OutputStream)resp.getOutputStream());
    }

    public void init() throws ServletException {
        super.init();
    }

    private Object parseKey(String keyType, String key) {
        if ("int8".equals(keyType)) {
            return Byte.valueOf(key);
        }
        if ("int16".equals(keyType)) {
            return Short.valueOf(key);
        }
        if ("int32".equals(keyType)) {
            return Integer.valueOf(key);
        }
        if ("int64".equals(keyType)) {
            return Long.valueOf(key);
        }
        if ("string".equals(keyType)) {
            return key;
        }
        throw new IllegalArgumentException("Unsupported key type: " + keyType);
    }
}

