/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import voldemort.VoldemortException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RequestRoutingType {
    NORMAL(0),
    ROUTED(1),
    IGNORE_CHECKS(2);

    private final int routingTypeCode;

    private RequestRoutingType(int routingType) {
        this.routingTypeCode = routingType;
    }

    public static RequestRoutingType getRequestRoutingType(boolean should_route, boolean ignore_checks) {
        if (ignore_checks) {
            return IGNORE_CHECKS;
        }
        if (should_route) {
            return ROUTED;
        }
        return NORMAL;
    }

    public int getRoutingTypeCode() {
        return this.routingTypeCode;
    }

    public static RequestRoutingType getRequestRoutingType(int routingCode) {
        switch (routingCode) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return ROUTED;
            }
            case 2: {
                return IGNORE_CHECKS;
            }
        }
        throw new VoldemortException("Invalid RequestRoutingType code passed " + routingCode);
    }
}

