/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.json;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import voldemort.serialization.SerializationException;
import voldemort.serialization.json.EndOfFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonReader {
    private final Reader reader;
    private final char lineBreak;
    private int line;
    private int lineOffset;
    private int charsRead;
    private int current;
    private final char[] contextBuffer;
    private int contextOffset;

    public JsonReader(Reader reader) {
        this(reader, 50);
    }

    public JsonReader(Reader reader, int contextBufferSize) {
        this.reader = reader;
        String newline = System.getProperty("line.separator");
        this.lineBreak = newline.contains("\n") ? (char)10 : (char)13;
        this.line = 1;
        this.lineOffset = 0;
        this.charsRead = 0;
        this.contextBuffer = new char[contextBufferSize];
        for (int i = 0; i < contextBufferSize; ++i) {
            this.contextBuffer[i] = 32;
        }
        this.next();
    }

    public boolean hasMore() {
        return this.current() != -1;
    }

    public Object read() {
        this.skipWhitespace();
        Object o = null;
        switch (this.current()) {
            case 123: {
                o = this.readObject();
                break;
            }
            case 91: {
                o = this.readArray();
                break;
            }
            case 34: 
            case 39: {
                o = this.readString();
                break;
            }
            case 102: 
            case 116: {
                o = this.readBoolean();
                break;
            }
            case 110: {
                o = this.readNull();
                break;
            }
            case -1: {
                throw new EndOfFileException();
            }
            default: {
                if (Character.isDigit(this.current()) || this.current() == 45) {
                    o = this.readNumber();
                    break;
                }
                throw new SerializationException("Unacceptable initial character " + this.currentChar() + " found when parsing object at line " + this.getCurrentLineNumber() + " character " + this.getCurrentLineOffset());
            }
        }
        this.skipWhitespace();
        return o;
    }

    public Map<String, ?> readObject() {
        this.skip(123);
        this.skipWhitespace();
        HashMap<String, Object> values = new HashMap<String, Object>();
        while (this.current() != 125) {
            this.skipWhitespace();
            String key = this.readString();
            this.skipWhitespace();
            this.skip(58);
            this.skipWhitespace();
            Object value = this.read();
            values.put(key, value);
            this.skipWhitespace();
            if (this.current() == 44) {
                this.next();
                this.skipWhitespace();
                continue;
            }
            if (this.current() == 125) break;
            throw new SerializationException("Unexpected character '" + this.currentChar() + "' in object definition, expected '}' or ',' but found: " + this.getCurrentContext());
        }
        this.skip(125);
        return values;
    }

    public List<?> readArray() {
        this.skip(91);
        this.skipWhitespace();
        ArrayList<Object> l = new ArrayList<Object>();
        while (this.current() != 93 && this.hasMore()) {
            l.add(this.read());
            this.skipWhitespace();
            if (this.current() != 44) continue;
            this.next();
            this.skipWhitespace();
        }
        this.skip(93);
        return l;
    }

    public Object readNull() {
        this.skip("null");
        return null;
    }

    public Boolean readBoolean() {
        if (this.current() == 116) {
            this.skip("true");
            return Boolean.TRUE;
        }
        this.skip("false");
        return Boolean.FALSE;
    }

    public String readString() {
        int quote = this.current();
        StringBuilder buffer = new StringBuilder();
        this.next();
        while (this.current() != quote && this.hasMore()) {
            if (this.current() == 92) {
                this.appendControlSequence(buffer);
            } else {
                buffer.append(this.currentChar());
            }
            this.next();
        }
        this.skip(quote);
        return buffer.toString();
    }

    private void appendControlSequence(StringBuilder buffer) {
        this.skip(92);
        switch (this.current()) {
            case 34: 
            case 47: 
            case 92: {
                buffer.append(this.currentChar());
                break;
            }
            case 98: {
                buffer.append('\b');
                break;
            }
            case 102: {
                buffer.append('\f');
                break;
            }
            case 110: {
                buffer.append('\n');
                break;
            }
            case 114: {
                buffer.append('\r');
                break;
            }
            case 116: {
                buffer.append('\t');
                break;
            }
            case 117: {
                buffer.append(this.readUnicodeLiteral());
                break;
            }
            default: {
                throw new SerializationException("Unrecognized control sequence on line " + this.getCurrentLineNumber() + ": '\\" + this.currentChar() + "'.");
            }
        }
    }

    private char readUnicodeLiteral() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            this.next();
            value <<= 4;
            if (Character.isDigit(this.current())) {
                value += this.current() - 48;
                continue;
            }
            if (97 <= this.current() && 102 >= this.current()) {
                value += 10 + this.current() - 97;
                continue;
            }
            if (65 <= this.current() && 70 >= this.current()) {
                value += 10 + this.current() - 65;
                continue;
            }
            throw new SerializationException("Invalid character in unicode sequence on line " + this.getCurrentLineNumber() + ": " + this.currentChar());
        }
        return (char)value;
    }

    public Number readNumber() {
        this.skipWhitespace();
        int intPiece = this.readInt();
        if (this.isTerminator(this.current())) {
            return intPiece;
        }
        double doublePiece = intPiece;
        if (this.current() == 46) {
            doublePiece += this.readFraction();
        }
        if (this.current() == 101 || this.current() == 69) {
            this.next();
            this.skipIf('+');
            int frac = this.readInt();
            doublePiece *= Math.pow(10.0, frac);
        }
        if (this.isTerminator(this.current())) {
            return doublePiece;
        }
        throw new SerializationException("Invalid number format for number on line " + this.lineOffset + ": " + this.getCurrentContext());
    }

    private boolean isTerminator(int ch) {
        return Character.isWhitespace(ch) || ch == 123 || ch == 125 || ch == 91 || ch == 93 || ch == 44 || ch == -1;
    }

    public int readInt() {
        boolean isPositive;
        this.skipWhitespace();
        int val = 0;
        if (this.current() == 45) {
            isPositive = false;
            this.next();
        } else if (this.current() == 43) {
            isPositive = true;
            this.next();
        } else {
            isPositive = true;
        }
        this.skipWhitespace();
        if (!Character.isDigit(this.current())) {
            throw new SerializationException("Expected a digit while trying to parse number, but got '" + this.currentChar() + "' at line " + this.getCurrentLineNumber() + " character " + this.getCurrentLineOffset() + ": " + this.getCurrentContext());
        }
        while (Character.isDigit(this.current())) {
            val *= 10;
            val += this.current() - 48;
            this.next();
        }
        if (!isPositive) {
            val = -val;
        }
        return val;
    }

    public double readFraction() {
        this.skip(46);
        double position = 0.1;
        double val = 0.0;
        while (Character.isDigit(this.current())) {
            val += position * (double)(this.current() - 48);
            position *= 0.1;
            this.next();
        }
        return val;
    }

    private int current() {
        return this.current;
    }

    private char currentChar() {
        return (char)this.current;
    }

    private int next() {
        try {
            this.current = this.reader.read();
            ++this.charsRead;
            ++this.lineOffset;
            if (this.current == this.lineBreak) {
                ++this.line;
                this.lineOffset = 1;
            }
            this.contextBuffer[this.contextOffset] = (char)this.current;
            this.contextOffset = (this.contextOffset + 1) % this.contextBuffer.length;
            return this.current;
        }
        catch (IOException e) {
            throw new SerializationException("Error reading from JSON stream.", e);
        }
    }

    private void skipIf(char c) {
        if (this.current() == c) {
            this.next();
        }
    }

    private void skip(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.skip(s.charAt(i));
        }
    }

    private void skipWhitespace() {
        while (Character.isWhitespace(this.current())) {
            this.next();
        }
    }

    private void skip(int c) {
        if (this.current() != c) {
            throw new SerializationException("Expected '" + (char)c + "' but current character is '" + this.currentChar() + "' on line " + this.line + " character " + this.lineOffset + ": " + this.getCurrentContext());
        }
        this.next();
    }

    public int getCurrentLineNumber() {
        return this.line;
    }

    public int getCurrentLineOffset() {
        return this.lineOffset;
    }

    public String getCurrentContext() {
        int i;
        StringBuilder builder = new StringBuilder(this.contextBuffer.length);
        for (i = this.contextOffset; i < this.contextBuffer.length; ++i) {
            builder.append(this.contextBuffer[i]);
        }
        for (i = 0; i < this.contextOffset; ++i) {
            builder.append(this.contextBuffer[i]);
        }
        if (this.charsRead < this.contextBuffer.length) {
            return builder.toString().substring(this.contextBuffer.length - this.charsRead, this.contextBuffer.length);
        }
        return builder.toString();
    }
}

