/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import voldemort.serialization.SerializationException;
import voldemort.serialization.SerializationUtils;
import voldemort.serialization.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvroGenericSerializer
implements Serializer<Object> {
    private final Schema typeDef;

    public AvroGenericSerializer(String schema) {
        this.typeDef = Schema.parse((String)schema);
    }

    @Override
    public byte[] toBytes(Object object) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder((OutputStream)output);
        GenericDatumWriter datumWriter = null;
        try {
            datumWriter = new GenericDatumWriter(this.typeDef);
            datumWriter.write(object, (Encoder)encoder);
            encoder.flush();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            SerializationUtils.close(output);
        }
        return output.toByteArray();
    }

    @Override
    public Object toObject(byte[] bytes) {
        BinaryDecoder decoder = DecoderFactory.defaultFactory().createBinaryDecoder(bytes, null);
        GenericDatumReader reader = null;
        try {
            reader = new GenericDatumReader(this.typeDef);
            return reader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }
}

