/*
 * Decompiled with CFR 0.152.
 */
package voldemort.serialization;

import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.serialization.SerializationException;
import voldemort.serialization.Serializer;
import voldemort.serialization.VSlopProto;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopSerializer
implements Serializer<Slop> {
    @Override
    public byte[] toBytes(Slop slop) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(byteOutput);
        try {
            VSlopProto.Slop.Builder builder = VSlopProto.Slop.newBuilder().setStore(slop.getStoreName()).setOperation(slop.getOperation().toString()).setKey(ProtoUtils.encodeBytes(slop.getKey())).setNodeId(slop.getNodeId()).setArrived(slop.getArrived().getTime());
            if (slop.getValue() != null) {
                builder.setValue(ProtoUtils.encodeBytes(new ByteArray(slop.getValue())));
            }
            ProtoUtils.writeMessage(data, (Message)builder.build());
            return byteOutput.toByteArray();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public Slop toObject(byte[] bytes) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            VSlopProto.Slop proto = ProtoUtils.readToBuilder(input, VSlopProto.Slop.newBuilder()).build();
            String storeName = proto.getStore();
            Slop.Operation op = Slop.Operation.valueOf(proto.getOperation());
            byte[] key = ProtoUtils.decodeBytes(proto.getKey()).get();
            byte[] value = null;
            if (proto.hasValue()) {
                value = ProtoUtils.decodeBytes(proto.getValue()).get();
            }
            int nodeId = proto.getNodeId();
            Date arrived = new Date(proto.getArrived());
            return new Slop(storeName, op, key, value, nodeId, arrived);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }
}

