/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import java.util.Map;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.StoreVerifier;
import voldemort.store.Store;
import voldemort.store.UnreachableStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStoreVerifier<K, V, T>
implements StoreVerifier {
    private final Map<Integer, Store<K, V, T>> stores;
    private final K key;

    public BasicStoreVerifier(Map<Integer, Store<K, V, T>> stores, K key) {
        this.stores = stores;
        this.key = key;
    }

    @Override
    public void verifyStore(Node node) throws UnreachableStoreException, VoldemortException {
        Store<K, V, Object> store = this.stores.get(node.getId());
        if (store == null) {
            throw new VoldemortException("Node " + node.getId() + " store is null; cannot determine node availability");
        }
        store.get(this.key, null);
    }
}

