/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.AbstractFailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.NodeStatus;
import voldemort.store.UnreachableStoreException;

@JmxManaged(description="Detects the availability of the nodes on which a Voldemort cluster runs")
public class BannagePeriodFailureDetector
extends AbstractFailureDetector {
    public BannagePeriodFailureDetector(FailureDetectorConfig failureDetectorConfig) {
        super(failureDetectorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(Node node) {
        NodeStatus nodeStatus;
        this.checkNodeArg(node);
        long bannagePeriod = this.failureDetectorConfig.getBannagePeriod();
        long currentTime = this.failureDetectorConfig.getTime().getMilliseconds();
        NodeStatus nodeStatus2 = nodeStatus = this.getNodeStatus(node);
        synchronized (nodeStatus2) {
            if (nodeStatus.isAvailable()) {
                return true;
            }
            if (nodeStatus.getLastChecked() + bannagePeriod < currentTime) {
                this.setAvailable(node);
                return true;
            }
            return false;
        }
    }

    public void recordException(Node node, long requestTime, UnreachableStoreException e) {
        this.checkArgs(node, requestTime);
        this.setUnavailable(node, e);
    }

    public void recordSuccess(Node node, long requestTime) {
        this.checkArgs(node, requestTime);
        this.setAvailable(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JmxGetter(name="unavailableNodesBannageExpiration", description="List of unavailable nodes and their respective bannage expiration")
    public String getUnavailableNodesBannageExpiration() {
        ArrayList<String> list = new ArrayList<String>();
        long bannagePeriod = this.failureDetectorConfig.getBannagePeriod();
        long currentTime = this.failureDetectorConfig.getTime().getMilliseconds();
        for (Node node : this.getConfig().getNodes()) {
            if (this.isAvailable(node)) continue;
            NodeStatus nodeStatus = this.getNodeStatus(node);
            long millis = 0L;
            NodeStatus nodeStatus2 = nodeStatus;
            synchronized (nodeStatus2) {
                millis = nodeStatus.getLastChecked() + bannagePeriod - currentTime;
            }
            list.add(node.getId() + "=" + millis);
        }
        return StringUtils.join(list, (String)",");
    }
}

