/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster.failuredetector;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.AbstractFailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.NodeStatus;
import voldemort.cluster.failuredetector.StoreVerifier;
import voldemort.store.UnreachableStoreException;

@JmxManaged(description="Detects the availability of the nodes on which a Voldemort cluster runs")
public class AsyncRecoveryFailureDetector
extends AbstractFailureDetector
implements Runnable {
    private volatile boolean isRunning = true;

    public AsyncRecoveryFailureDetector(FailureDetectorConfig failureDetectorConfig) {
        super(failureDetectorConfig);
        Thread recoveryThread = new Thread((Runnable)this, "AsyncNodeRecoverer");
        recoveryThread.setDaemon(true);
        recoveryThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                if (AsyncRecoveryFailureDetector.this.logger.isEnabledFor((Priority)Level.ERROR)) {
                    AsyncRecoveryFailureDetector.this.logger.error((Object)"Uncaught exception in failure detector recovery thread:", e);
                }
            }
        });
        recoveryThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(Node node) {
        NodeStatus nodeStatus;
        this.checkNodeArg(node);
        NodeStatus nodeStatus2 = nodeStatus = this.getNodeStatus(node);
        synchronized (nodeStatus2) {
            return nodeStatus.isAvailable();
        }
    }

    public void recordException(Node node, long requestTime, UnreachableStoreException e) {
        this.checkArgs(node, requestTime);
        this.setUnavailable(node, e);
    }

    public void recordSuccess(Node node, long requestTime) {
        this.checkArgs(node, requestTime);
    }

    public void destroy() {
        this.isRunning = false;
    }

    public void run() {
        long asyncRecoveryInterval = this.getConfig().getAsyncRecoveryInterval();
        while (!Thread.currentThread().isInterrupted() && this.isRunning) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sleeping for " + asyncRecoveryInterval + " ms before checking node availability"));
                }
                this.getConfig().getTime().sleep(asyncRecoveryInterval);
            }
            catch (InterruptedException e) {
                break;
            }
            for (Node node : this.getConfig().getNodes()) {
                if (this.isAvailable(node)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Checking previously unavailable node " + node.getId()));
                }
                StoreVerifier storeVerifier = this.getConfig().getStoreVerifier();
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Verifying previously unavailable node " + node.getId()));
                    }
                    storeVerifier.verifyStore(node);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Verified previously unavailable node " + node.getId() + ", will mark as available..."));
                    }
                    this.nodeRecovered(node);
                }
                catch (UnreachableStoreException e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) continue;
                    this.logger.warn((Object)("Node " + node.getId() + " still unavailable"), (Throwable)e);
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    this.logger.error((Object)("Node " + node.getId() + " unavailable due to error"), (Throwable)e);
                }
            }
        }
    }

    protected void nodeRecovered(Node node) {
        this.setAvailable(node);
    }
}

