/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zone
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_ZONE_ID = 0;
    private int zoneId;
    private LinkedList<Integer> proximityList;

    public Zone(int zoneId, LinkedList<Integer> proximityList) {
        this.zoneId = zoneId;
        this.proximityList = proximityList;
    }

    public Zone() {
        this.zoneId = 0;
        this.proximityList = new LinkedList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Zone Id " + this.zoneId + " - ");
        builder.append("Proximity List - [" + this.proximityList + "]");
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)object;
        if (this.getId() != zone.getId()) {
            return false;
        }
        if (this.getProximityList().size() != zone.getProximityList().size()) {
            return false;
        }
        Iterator proxListFirst = this.getProximityList().iterator();
        Iterator proxListSecond = zone.getProximityList().iterator();
        while (proxListFirst.hasNext() && proxListSecond.hasNext()) {
            Integer second;
            Integer first = (Integer)proxListFirst.next();
            if (first.equals(second = (Integer)proxListSecond.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getId() ^ this.getProximityList().size();
    }

    public int getId() {
        return this.zoneId;
    }

    public LinkedList<Integer> getProximityList() {
        return this.proximityList;
    }
}

