/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Threadsafe
public class Node
implements Serializable,
Comparable<Node> {
    private static final Logger logger = Logger.getLogger((String)Node.class.getName());
    private static final long serialVersionUID = 1L;
    private final int id;
    private final String host;
    private final int httpPort;
    private final int socketPort;
    private final int adminPort;
    private final int zoneId;
    private final List<Integer> partitions;

    public Node(int id, String host, int httpPort, int socketPort, int adminPort, List<Integer> partitions) {
        this(id, host, httpPort, socketPort, adminPort, 0, partitions);
    }

    public Node(int id, String host, int httpPort, int socketPort, int adminPort, int zoneId, List<Integer> partitions) {
        this.id = id;
        this.host = Utils.notNull(host);
        this.httpPort = httpPort;
        this.socketPort = socketPort;
        this.zoneId = zoneId;
        this.partitions = ImmutableList.copyOf(partitions);
        if (adminPort == -1) {
            adminPort = socketPort + 1;
            logger.warn((Object)("admin-port not defined for node:" + id + " using default value(socket_port + 1):" + adminPort));
        }
        this.adminPort = adminPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getSocketPort() {
        return this.socketPort;
    }

    public int getZoneId() {
        return this.zoneId;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public int getId() {
        return this.id;
    }

    public List<Integer> getPartitionIds() {
        return this.partitions;
    }

    public int getNumberOfPartitions() {
        return this.partitions.size();
    }

    public URI getHttpUrl() {
        try {
            return new URI("http://" + this.getHost() + ":" + this.getHttpPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid host format for node " + this.id + ".", e);
        }
    }

    public URI getSocketUrl() {
        try {
            return new URI("tcp://" + this.getHost() + ":" + this.getSocketPort());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid host format for node " + this.id + ".", e);
        }
    }

    public String toString() {
        return "Node" + this.getId() + " in zone " + this.getZoneId() + " partitionList:" + this.partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node n = (Node)o;
        return this.getId() == n.getId();
    }

    public int hashCode() {
        return this.getId();
    }

    @Override
    public int compareTo(Node other) {
        return Integer.valueOf(this.id).compareTo(other.getId());
    }
}

