/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.rebalance.RebalanceClientConfig;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.server.rebalance.AlreadyRebalancingException;
import voldemort.store.UnreachableStoreException;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.RebalanceUtils;

class RebalanceTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(RebalanceTask.class);
    private static final int INVALID_REBALANCE_ID = -1;
    private final RebalancePartitionsInfo stealInfo;
    private Exception exception;
    private final RebalanceClientConfig config;
    private final AdminClient adminClient;

    public RebalanceTask(RebalancePartitionsInfo stealInfo, RebalanceClientConfig config, AdminClient adminClient) {
        this.stealInfo = stealInfo;
        this.config = config;
        this.adminClient = adminClient;
        this.exception = null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Exception getError() {
        return this.exception;
    }

    public RebalancePartitionsInfo getRebalancePartitionsInfo() {
        return this.stealInfo;
    }

    private int startNodeRebalancing(RebalancePartitionsInfo stealInfo) {
        AlreadyRebalancingException rebalanceException = null;
        for (int nTries = 0; nTries < this.config.getMaxTriesRebalancing(); ++nTries) {
            try {
                logger.info((Object)("Starting on node " + stealInfo.getStealerId() + " rebalancing task " + stealInfo));
                int asyncOperationId = this.adminClient.rebalanceNode(stealInfo);
                return asyncOperationId;
            }
            catch (AlreadyRebalancingException e) {
                RebalanceUtils.printLog(stealInfo.getStealerId(), logger, "Node " + stealInfo.getStealerId() + " is currently rebalancing. Waiting till completion");
                this.adminClient.waitForCompletion(stealInfo.getStealerId(), "server.state", MetadataStore.VoldemortState.NORMAL_SERVER.toString(), this.config.getRebalancingClientTimeoutSeconds(), TimeUnit.SECONDS);
                rebalanceException = e;
                continue;
            }
        }
        throw new VoldemortException("Failed to start rebalancing with plan: " + stealInfo, rebalanceException);
    }

    public void run() {
        int rebalanceAsyncId = -1;
        int stealerNodeId = this.stealInfo.getStealerId();
        try {
            rebalanceAsyncId = this.startNodeRebalancing(this.stealInfo);
            this.adminClient.waitForCompletion(this.stealInfo.getStealerId(), rebalanceAsyncId, this.config.getRebalancingClientTimeoutSeconds(), TimeUnit.SECONDS);
            RebalanceUtils.printLog(this.stealInfo.getStealerId(), logger, "Succesfully finished rebalance for async operation id " + rebalanceAsyncId);
        }
        catch (UnreachableStoreException e) {
            this.exception = e;
            logger.error((Object)("StealerNode " + stealerNodeId + " is unreachable, please make sure it is up and running - " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            this.exception = e;
            logger.error((Object)("Rebalance failed: " + e.getMessage()), (Throwable)e);
        }
    }
}

