/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import voldemort.VoldemortException;
import voldemort.client.rebalance.RebalanceNodePlan;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.StoreDefinition;
import voldemort.utils.Pair;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalanceClusterPlan {
    private final Queue<RebalanceNodePlan> rebalanceTaskQueue = new ConcurrentLinkedQueue<RebalanceNodePlan>();
    private final Map<Integer, Set<Pair<Integer, Integer>>> currentAllStoresNodeIdToAllPartitionTuples = Maps.newHashMap();
    private final Map<Integer, Set<Pair<Integer, Integer>>> targetAllStoresNodeIdToAllPartitionTuples = Maps.newHashMap();

    public RebalanceClusterPlan(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefs, boolean enabledDeletePartition) {
        if (currentCluster.getNumberOfPartitions() != targetCluster.getNumberOfPartitions()) {
            throw new VoldemortException("Total number of partitions should be equal [ Current cluster (" + currentCluster.getNumberOfPartitions() + ") not equal to Target cluster (" + targetCluster.getNumberOfPartitions() + ") ]");
        }
        if (currentCluster.getNumberOfNodes() != targetCluster.getNumberOfNodes()) {
            throw new VoldemortException("Total number of nodes should be equal [ Current cluster (" + currentCluster.getNumberOfNodes() + ") not equal to Target cluster (" + targetCluster.getNumberOfNodes() + ") ]");
        }
        for (Node node : targetCluster.getNodes()) {
            List<RebalancePartitionsInfo> rebalanceNodeList = this.getRebalancePartitionsInfo(currentCluster, targetCluster, storeDefs, node.getId(), enabledDeletePartition);
            if (rebalanceNodeList.size() <= 0) continue;
            this.rebalanceTaskQueue.offer(new RebalanceNodePlan(node.getId(), rebalanceNodeList));
        }
    }

    public Queue<RebalanceNodePlan> getRebalancingTaskQueue() {
        return this.rebalanceTaskQueue;
    }

    private List<RebalancePartitionsInfo> getRebalancePartitionsInfo(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefs, int stealerNodeId, boolean enableDeletePartition) {
        HashMap donorNodeToStoreToStealPartition = Maps.newHashMap();
        HashMap donorNodeToStoreToDeletePartition = Maps.newHashMap();
        block0: for (StoreDefinition storeDef : storeDefs) {
            Map<Integer, Set<Pair<Integer, Integer>>> currentNodeIdToAllPartitionTuples = RebalanceUtils.getNodeIdToAllPartitions(currentCluster, storeDef, true);
            RebalanceUtils.combinePartitionTuples(this.currentAllStoresNodeIdToAllPartitionTuples, currentNodeIdToAllPartitionTuples);
            Map<Integer, Set<Pair<Integer, Integer>>> targetNodeIdToAllPartitionTuples = RebalanceUtils.getNodeIdToAllPartitions(targetCluster, storeDef, true);
            RebalanceUtils.combinePartitionTuples(this.targetAllStoresNodeIdToAllPartitionTuples, targetNodeIdToAllPartitionTuples);
            Map<Integer, Set<Pair<Integer, Integer>>> stealerNodeIdToStolenPartitionTuples = RebalanceUtils.getStolenPartitionTuples(currentCluster, targetCluster, storeDef);
            if (stealerNodeIdToStolenPartitionTuples.get(stealerNodeId) == null) continue;
            HashSet haveToStealTuples = Sets.newHashSet((Iterable)stealerNodeIdToStolenPartitionTuples.get(stealerNodeId));
            for (Node donorNode : currentCluster.getNodes()) {
                if (donorNode.getId() == stealerNodeId) continue;
                if (this.haveFinishedPartitions(haveToStealTuples)) continue block0;
                HashSet<Pair<Integer, Integer>> trackStealPartitionsTuples = new HashSet<Pair<Integer, Integer>>();
                HashSet<Pair<Integer, Integer>> trackDeletePartitionsTuples = new HashSet<Pair<Integer, Integer>>();
                this.donatePartitionTuple(donorNode, haveToStealTuples, trackStealPartitionsTuples, currentNodeIdToAllPartitionTuples.get(donorNode.getId()));
                this.donateDeletePartitionTuple(donorNode, trackStealPartitionsTuples, trackDeletePartitionsTuples, stealerNodeIdToStolenPartitionTuples.get(donorNode.getId()), enableDeletePartition);
                if (trackStealPartitionsTuples.size() > 0) {
                    this.addPartitionsToPlan(trackStealPartitionsTuples, donorNodeToStoreToStealPartition, donorNode.getId(), storeDef.getName());
                }
                if (trackDeletePartitionsTuples.size() <= 0) continue;
                this.addPartitionsToPlan(trackDeletePartitionsTuples, donorNodeToStoreToDeletePartition, donorNode.getId(), storeDef.getName());
            }
        }
        ArrayList<RebalancePartitionsInfo> result = new ArrayList<RebalancePartitionsInfo>();
        Iterator i$ = donorNodeToStoreToStealPartition.keySet().iterator();
        while (i$.hasNext()) {
            int donorNodeId = (Integer)i$.next();
            HashMap storeToStealPartition = (HashMap)donorNodeToStoreToStealPartition.get(donorNodeId);
            HashMap storeToDeletePartition = donorNodeToStoreToDeletePartition.containsKey(donorNodeId) ? (HashMap)donorNodeToStoreToDeletePartition.get(donorNodeId) : new HashMap();
            result.add(new RebalancePartitionsInfo(stealerNodeId, donorNodeId, storeToStealPartition, storeToDeletePartition, currentCluster, 0));
        }
        return result;
    }

    private void addPartitionsToPlan(Set<Pair<Integer, Integer>> trackPartitionsTuples, HashMap<Integer, HashMap<String, HashMap<Integer, List<Integer>>>> donorNodeToStoreToPartitionTuples, int donorNodeId, String name) {
        HashMap<String, HashMap<Integer, List<Integer>>> storeToStealPartitionTuples = null;
        if (donorNodeToStoreToPartitionTuples.containsKey(donorNodeId)) {
            storeToStealPartitionTuples = donorNodeToStoreToPartitionTuples.get(donorNodeId);
        } else {
            storeToStealPartitionTuples = Maps.newHashMap();
            donorNodeToStoreToPartitionTuples.put(donorNodeId, storeToStealPartitionTuples);
        }
        storeToStealPartitionTuples.put(name, RebalanceUtils.flattenPartitionTuples(trackPartitionsTuples));
    }

    private void donatePartitionTuple(Node donorNode, Set<Pair<Integer, Integer>> haveToStealTuples, Set<Pair<Integer, Integer>> trackStealPartitionsTuples, Set<Pair<Integer, Integer>> donorPartitionTuples) {
        Iterator<Pair<Integer, Integer>> iter = haveToStealTuples.iterator();
        while (iter.hasNext()) {
            Pair<Integer, Integer> partitionTupleToSteal = iter.next();
            if (!donorPartitionTuples.contains(partitionTupleToSteal)) continue;
            trackStealPartitionsTuples.add(partitionTupleToSteal);
            iter.remove();
        }
    }

    private void donateDeletePartitionTuple(Node donor, Set<Pair<Integer, Integer>> trackStealPartitionsTuples, Set<Pair<Integer, Integer>> trackDeletePartitionsTuples, Set<Pair<Integer, Integer>> donorPartitionTuples, boolean enableDeletePartition) {
        if (enableDeletePartition && trackStealPartitionsTuples.size() > 0) {
            List<Integer> partitionsStolenByDonor = RebalanceUtils.getPartitionsFromTuples(donorPartitionTuples);
            for (Pair<Integer, Integer> tuple : trackStealPartitionsTuples) {
                if (partitionsStolenByDonor.contains(tuple.getSecond())) continue;
                trackDeletePartitionsTuples.add(tuple);
            }
        }
    }

    private boolean haveFinishedPartitions(Set<Pair<Integer, Integer>> set) {
        return set == null || set.size() == 0;
    }

    public String toString() {
        if (this.rebalanceTaskQueue.isEmpty()) {
            return "No rebalancing required since rebalance task is empty";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Cluster Rebalancing Plan : ").append(Utils.NEWLINE);
        if (this.rebalanceTaskQueue == null || this.rebalanceTaskQueue.isEmpty()) {
            return "";
        }
        for (RebalanceNodePlan nodePlan : this.rebalanceTaskQueue) {
            builder.append("Stealer node " + nodePlan.getStealerNode());
            for (RebalancePartitionsInfo rebalancePartitionsInfo : nodePlan.getRebalanceTaskList()) {
                builder.append(rebalancePartitionsInfo).append(Utils.NEWLINE);
            }
        }
        return builder.toString();
    }

    public String printPartitionDistribution() {
        StringBuilder sb = new StringBuilder();
        sb.append("Current Cluster: ").append(Utils.NEWLINE).append(RebalanceUtils.printMap(this.currentAllStoresNodeIdToAllPartitionTuples)).append(Utils.NEWLINE);
        sb.append("Target Cluster: ").append(Utils.NEWLINE).append(RebalanceUtils.printMap(this.targetAllStoresNodeIdToAllPartitionTuples));
        return sb.toString();
    }
}

