/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import java.util.Properties;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.utils.Props;

public class RebalanceClientConfig
extends AdminClientConfig {
    public static final int MAX_PARALLEL_REBALANCING = 1;
    public static final int MAX_TRIES = 2;
    public static final long REBALANCING_CLIENT_TIMEOUT_SEC = 604800L;
    private int maxParallelRebalancing = 1;
    private int maxTriesRebalancing = 2;
    private long rebalancingClientTimeoutSeconds = 604800L;
    private boolean deleteAfterRebalancingEnabled;
    private boolean enabledShowPlan;
    private String outputDirectory = null;
    public static final String MaxParallelRebalancingString = "max.parallel.rebalancing";
    public static final String RebalancingClientTimeoutSeconds = "rebalancing.client.timeout.seconds";
    public static final String EnableDeleteAfterRebalancing = "enable.delete.after.rebalancing";
    public static final String MaxTriesRebalancingString = "max.tries.rebalancing";
    public static final String OutputDirectoryString = "rebalancing.output.dir";

    public RebalanceClientConfig(Properties properties) {
        super(properties);
        Props props = new Props(properties);
        if (props.containsKey(MaxParallelRebalancingString)) {
            this.setMaxParallelRebalancing(props.getInt(MaxParallelRebalancingString));
        }
        if (props.containsKey(RebalancingClientTimeoutSeconds)) {
            this.setRebalancingClientTimeoutSeconds(props.getInt(RebalancingClientTimeoutSeconds));
        }
        if (props.containsKey(EnableDeleteAfterRebalancing)) {
            this.setDeleteAfterRebalancingEnabled(props.getBoolean(EnableDeleteAfterRebalancing));
        }
        if (props.containsKey(MaxTriesRebalancingString)) {
            this.setMaxTriesRebalancing(props.getInt(MaxTriesRebalancingString));
        }
        if (props.containsKey(OutputDirectoryString)) {
            this.setOutputDirectory(props.getString(OutputDirectoryString));
        }
    }

    public RebalanceClientConfig() {
        this(new Properties());
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean hasOutputDirectory() {
        return this.outputDirectory != null;
    }

    public void setMaxParallelRebalancing(int maxParallelRebalancing) {
        this.maxParallelRebalancing = maxParallelRebalancing;
    }

    public int getMaxParallelRebalancing() {
        return this.maxParallelRebalancing;
    }

    public void setMaxTriesRebalancing(int maxTriesRebalancing) {
        this.maxTriesRebalancing = maxTriesRebalancing;
    }

    public int getMaxTriesRebalancing() {
        return this.maxTriesRebalancing;
    }

    public void setRebalancingClientTimeoutSeconds(long rebalancingTimeoutSeconds) {
        this.rebalancingClientTimeoutSeconds = rebalancingTimeoutSeconds;
    }

    public long getRebalancingClientTimeoutSeconds() {
        return this.rebalancingClientTimeoutSeconds;
    }

    public boolean isDeleteAfterRebalancingEnabled() {
        return this.deleteAfterRebalancingEnabled;
    }

    public void setDeleteAfterRebalancingEnabled(boolean deleteAfterRebalancingEnabled) {
        this.deleteAfterRebalancingEnabled = deleteAfterRebalancingEnabled;
    }

    public void setEnableShowPlan(boolean enable) {
        this.enabledShowPlan = enable;
    }

    public boolean isShowPlanEnabled() {
        return this.enabledShowPlan;
    }
}

