/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import voldemort.client.rebalance.RebalanceClusterPlan;
import voldemort.client.rebalance.RebalanceNodePlan;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.store.StoreDefinition;
import voldemort.utils.ByteArray;
import voldemort.utils.KeyDistributionGenerator;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedClusterTransition {
    private static final AtomicInteger idGen = new AtomicInteger(0);
    private final Cluster currentCluster;
    private final Cluster targetCluster;
    private final RebalanceClusterPlan rebalanceClusterPlan;
    private final List<RebalanceNodePlan> orderedRebalanceNodePlanList;
    private final List<StoreDefinition> storeDefs;
    private String printedContent;
    private final int id = idGen.incrementAndGet();

    public OrderedClusterTransition(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefs, RebalanceClusterPlan rebalanceClusterPlan) {
        this.currentCluster = currentCluster;
        this.targetCluster = targetCluster;
        this.storeDefs = storeDefs;
        this.rebalanceClusterPlan = rebalanceClusterPlan;
        this.orderedRebalanceNodePlanList = this.orderedClusterPlan(rebalanceClusterPlan);
    }

    public List<StoreDefinition> getStoreDefs() {
        return this.storeDefs;
    }

    public int getId() {
        return this.id;
    }

    public Cluster getTargetCluster() {
        return this.targetCluster;
    }

    public Cluster getCurrentCluster() {
        return this.currentCluster;
    }

    public List<RebalanceNodePlan> getOrderedRebalanceNodePlanList() {
        return this.orderedRebalanceNodePlanList;
    }

    public String toString() {
        if (this.printedContent == null) {
            StringBuilder sb = new StringBuilder();
            List<ByteArray> keys = KeyDistributionGenerator.generateKeys(10000);
            sb.append("- Rebalance Task Id : ").append(this.getId()).append(Utils.NEWLINE);
            sb.append("- Current cluster : ").append(KeyDistributionGenerator.printOverallDistribution(this.getCurrentCluster(), this.getStoreDefs(), keys)).append(Utils.NEWLINE);
            sb.append("- Target cluster : ").append(KeyDistributionGenerator.printOverallDistribution(this.getTargetCluster(), this.getStoreDefs(), keys)).append(Utils.NEWLINE);
            sb.append("- Partition distribution : ").append(Utils.NEWLINE).append(this.getRebalanceClusterPlan().printPartitionDistribution()).append(Utils.NEWLINE);
            sb.append("- Ordered rebalance node plan : ").append(Utils.NEWLINE).append(this.printRebalanceNodePlan(this.getOrderedRebalanceNodePlanList()));
            this.printedContent = sb.toString();
        }
        return this.printedContent;
    }

    private String printRebalanceNodePlan(List<RebalanceNodePlan> rebalanceNodePlanList) {
        StringBuilder builder = new StringBuilder();
        for (RebalanceNodePlan plan : rebalanceNodePlanList) {
            for (RebalancePartitionsInfo partitionInfo : plan.getRebalanceTaskList()) {
                builder.append(partitionInfo).append(Utils.NEWLINE);
            }
        }
        return builder.toString();
    }

    private RebalanceClusterPlan getRebalanceClusterPlan() {
        return this.rebalanceClusterPlan;
    }

    private List<RebalanceNodePlan> orderedClusterPlan(RebalanceClusterPlan rebalanceClusterPlan) {
        Queue<RebalanceNodePlan> rebalancingTaskQueue = rebalanceClusterPlan.getRebalancingTaskQueue();
        RebalanceNodePlan[] array = new RebalanceNodePlan[rebalancingTaskQueue.size()];
        rebalancingTaskQueue.toArray(array);
        ArrayList<RebalanceNodePlan> plans = new ArrayList<RebalanceNodePlan>();
        for (RebalanceNodePlan rebalanceNodePlan : rebalancingTaskQueue) {
            List<RebalancePartitionsInfo> orderedRebalancePartitionsInfos = this.orderedPartitionInfos(rebalanceNodePlan);
            plans.add(new RebalanceNodePlan(rebalanceNodePlan.getStealerNode(), orderedRebalancePartitionsInfos));
        }
        return this.orderedNodePlans(plans);
    }

    private List<RebalanceNodePlan> orderedNodePlans(List<RebalanceNodePlan> rebalanceNodePlans) {
        ArrayList<RebalanceNodePlan> first = new ArrayList<RebalanceNodePlan>();
        ArrayList<RebalanceNodePlan> second = new ArrayList<RebalanceNodePlan>();
        for (RebalanceNodePlan plan : rebalanceNodePlans) {
            boolean found = false;
            for (RebalancePartitionsInfo partitionInfo : plan.getRebalanceTaskList()) {
                List<Integer> stealMasterPartitions = partitionInfo.getStealMasterPartitions();
                if (stealMasterPartitions == null || stealMasterPartitions.isEmpty()) continue;
                found = true;
                break;
            }
            if (found) {
                first.add(plan);
                continue;
            }
            second.add(plan);
        }
        first.addAll(second);
        return first;
    }

    private List<RebalancePartitionsInfo> orderedPartitionInfos(RebalanceNodePlan rebalanceNodePlan) {
        ArrayList<RebalancePartitionsInfo> listPrimaries = new ArrayList<RebalancePartitionsInfo>();
        ArrayList<RebalancePartitionsInfo> listReplicas = new ArrayList<RebalancePartitionsInfo>();
        List<RebalancePartitionsInfo> partitionInfos = rebalanceNodePlan.getRebalanceTaskList();
        for (RebalancePartitionsInfo partitionInfo : partitionInfos) {
            List<Integer> stealMasterPartitions = partitionInfo.getStealMasterPartitions();
            if (stealMasterPartitions != null && !stealMasterPartitions.isEmpty()) {
                listPrimaries.add(partitionInfo);
                continue;
            }
            listReplicas.add(partitionInfo);
        }
        listPrimaries.addAll(listReplicas);
        return listPrimaries;
    }
}

