/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.pb;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.client.protocol.pb.VProto;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.store.ErrorCodeMapper;
import voldemort.utils.ByteArray;
import voldemort.versioning.ClockEntry;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoUtils {
    public static RebalancePartitionsInfo decodeRebalancePartitionInfoMap(VAdminProto.RebalancePartitionInfoMap rebalancePartitionInfoMap) {
        RebalancePartitionsInfo rebalanceStealInfo = new RebalancePartitionsInfo(rebalancePartitionInfoMap.getStealerId(), rebalancePartitionInfoMap.getDonorId(), ProtoUtils.decodePerStorePartitionTuple(rebalancePartitionInfoMap.getReplicaToAddPartitionList()), ProtoUtils.decodePerStorePartitionTuple(rebalancePartitionInfoMap.getReplicaToDeletePartitionList()), new ClusterMapper().readCluster(new StringReader(rebalancePartitionInfoMap.getInitialCluster())), rebalancePartitionInfoMap.getAttempt());
        return rebalanceStealInfo;
    }

    public static VAdminProto.RebalancePartitionInfoMap encodeRebalancePartitionInfoMap(RebalancePartitionsInfo stealInfo) {
        return VAdminProto.RebalancePartitionInfoMap.newBuilder().setStealerId(stealInfo.getStealerId()).setDonorId(stealInfo.getDonorId()).addAllReplicaToAddPartition(ProtoUtils.encodePerStorePartitionTuple(stealInfo.getStoreToReplicaToAddPartitionList())).addAllReplicaToDeletePartition(ProtoUtils.encodePerStorePartitionTuple(stealInfo.getStoreToReplicaToDeletePartitionList())).setInitialCluster(new ClusterMapper().writeCluster(stealInfo.getInitialCluster())).setAttempt(stealInfo.getAttempt()).build();
    }

    public static Map<String, String> encodeROMap(List<VAdminProto.ROStoreVersionDirMap> metadataMap) {
        HashMap storeToValue = Maps.newHashMap();
        for (VAdminProto.ROStoreVersionDirMap currentStore : metadataMap) {
            storeToValue.put(currentStore.getStoreName(), currentStore.getStoreDir());
        }
        return storeToValue;
    }

    public static List<VAdminProto.PartitionTuple> encodePartitionTuple(HashMap<Integer, List<Integer>> replicaToPartitionList) {
        ArrayList tuples = Lists.newArrayList();
        for (Map.Entry<Integer, List<Integer>> entry : replicaToPartitionList.entrySet()) {
            VAdminProto.PartitionTuple.Builder tupleBuilder = VAdminProto.PartitionTuple.newBuilder();
            tupleBuilder.setReplicaType(entry.getKey());
            tupleBuilder.addAllPartitions((Iterable<? extends Integer>)entry.getValue());
            tuples.add(tupleBuilder.build());
        }
        return tuples;
    }

    public static HashMap<Integer, List<Integer>> decodePartitionTuple(List<VAdminProto.PartitionTuple> partitionTuples) {
        HashMap replicaToPartitionList = Maps.newHashMap();
        for (VAdminProto.PartitionTuple tuple : partitionTuples) {
            replicaToPartitionList.put(tuple.getReplicaType(), tuple.getPartitionsList());
        }
        return replicaToPartitionList;
    }

    public static List<VAdminProto.PerStorePartitionTuple> encodePerStorePartitionTuple(HashMap<String, HashMap<Integer, List<Integer>>> storeToReplicaToPartitionList) {
        ArrayList perStorePartitionTuples = Lists.newArrayList();
        for (Map.Entry<String, HashMap<Integer, List<Integer>>> entry : storeToReplicaToPartitionList.entrySet()) {
            VAdminProto.PerStorePartitionTuple.Builder tupleBuilder = VAdminProto.PerStorePartitionTuple.newBuilder();
            tupleBuilder.setStoreName(entry.getKey());
            tupleBuilder.addAllReplicaToPartition(ProtoUtils.encodePartitionTuple(entry.getValue()));
            perStorePartitionTuples.add(tupleBuilder.build());
        }
        return perStorePartitionTuples;
    }

    public static HashMap<String, HashMap<Integer, List<Integer>>> decodePerStorePartitionTuple(List<VAdminProto.PerStorePartitionTuple> perStorePartitionTuples) {
        HashMap storeToReplicaToPartitionList = Maps.newHashMap();
        for (VAdminProto.PerStorePartitionTuple tuple : perStorePartitionTuples) {
            storeToReplicaToPartitionList.put(tuple.getStoreName(), ProtoUtils.decodePartitionTuple(tuple.getReplicaToPartitionList()));
        }
        return storeToReplicaToPartitionList;
    }

    public static VProto.Error.Builder encodeError(ErrorCodeMapper mapper, VoldemortException e) {
        return VProto.Error.newBuilder().setErrorCode(mapper.getCode(e)).setErrorMessage(e.getMessage());
    }

    public static VProto.Versioned.Builder encodeVersioned(Versioned<byte[]> versioned) {
        return VProto.Versioned.newBuilder().setValue(ByteString.copyFrom((byte[])versioned.getValue())).setVersion(ProtoUtils.encodeClock(versioned.getVersion()));
    }

    public static Versioned<byte[]> decodeVersioned(VProto.Versioned versioned) {
        return new Versioned<byte[]>(versioned.getValue().toByteArray(), ProtoUtils.decodeClock(versioned.getVersion()));
    }

    public static List<Versioned<byte[]>> decodeVersions(List<VProto.Versioned> versioned) {
        ArrayList<Versioned<byte[]>> values = new ArrayList<Versioned<byte[]>>(versioned.size());
        for (VProto.Versioned v : versioned) {
            values.add(ProtoUtils.decodeVersioned(v));
        }
        return values;
    }

    public static VectorClock decodeClock(VProto.VectorClock encoded) {
        ArrayList<ClockEntry> entries = new ArrayList<ClockEntry>(encoded.getEntriesCount());
        for (VProto.ClockEntry entry : encoded.getEntriesList()) {
            entries.add(new ClockEntry((short)entry.getNodeId(), entry.getVersion()));
        }
        return new VectorClock(entries, encoded.getTimestamp());
    }

    public static VProto.VectorClock.Builder encodeClock(Version version) {
        VectorClock clock = (VectorClock)version;
        VProto.VectorClock.Builder encoded = VProto.VectorClock.newBuilder();
        encoded.setTimestamp(clock.getTimestamp());
        for (ClockEntry entry : clock.getEntries()) {
            encoded.addEntries(VProto.ClockEntry.newBuilder().setNodeId(entry.getNodeId()).setVersion(entry.getVersion()));
        }
        return encoded;
    }

    public static ByteArray decodeBytes(ByteString string) {
        return new ByteArray(string.toByteArray());
    }

    public static ByteString encodeBytes(ByteArray array) {
        return ByteString.copyFrom((byte[])array.get());
    }

    public static ByteString encodeTransform(byte[] transform) {
        return ByteString.copyFrom((byte[])transform);
    }

    public static void writeMessage(DataOutputStream output, Message message) throws IOException {
        output.writeInt(message.getSerializedSize());
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)output);
        message.writeTo(codedOut);
        codedOut.flush();
    }

    public static void writeEndOfStream(DataOutputStream output) throws IOException {
        output.writeInt(-1);
    }

    public static <T extends Message.Builder> T readToBuilder(DataInputStream input, T builder) throws IOException {
        int size = input.readInt();
        CodedInputStream codedIn = CodedInputStream.newInstance((InputStream)input);
        codedIn.pushLimit(size);
        builder.mergeFrom(codedIn);
        return builder;
    }
}

