/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.admin;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.ClientConfig;
import voldemort.client.SocketStoreClientFactory;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.VoldemortFilter;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.client.protocol.admin.SocketAndStreams;
import voldemort.client.protocol.admin.SocketPool;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VAdminProto;
import voldemort.client.protocol.pb.VProto;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.server.protocol.admin.AsyncOperationStatus;
import voldemort.server.rebalance.VoldemortRebalancingException;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StoreDefinition;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.readonly.ReadOnlyStorageFormat;
import voldemort.store.readonly.ReadOnlyStorageMetadata;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.slop.Slop;
import voldemort.store.socket.SocketDestination;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.NetworkClassLoader;
import voldemort.utils.Pair;
import voldemort.utils.RebalanceUtils;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminClient {
    private static final Logger logger = Logger.getLogger(AdminClient.class);
    private final ErrorCodeMapper errorMapper;
    private final SocketPool pool;
    private final NetworkClassLoader networkClassLoader;
    private static final ClusterMapper clusterMapper = new ClusterMapper();
    private static final StoreDefinitionsMapper storeMapper = new StoreDefinitionsMapper();
    private static final long INITIAL_DELAY = 250L;
    private final AdminClientConfig adminClientConfig;
    public static final List<String> restoreStoreEngineBlackList = Arrays.asList("mysql", "read-only", "view");
    private Cluster currentCluster;

    public AdminClient(String bootstrapURL, AdminClientConfig adminClientConfig) {
        this.currentCluster = this.getClusterFromBootstrapURL(bootstrapURL);
        this.errorMapper = new ErrorCodeMapper();
        this.pool = this.createSocketPool(adminClientConfig);
        this.networkClassLoader = new NetworkClassLoader(Thread.currentThread().getContextClassLoader());
        this.adminClientConfig = adminClientConfig;
    }

    public AdminClient(Cluster cluster, AdminClientConfig adminClientConfig) {
        this.currentCluster = cluster;
        this.errorMapper = new ErrorCodeMapper();
        this.pool = this.createSocketPool(adminClientConfig);
        this.networkClassLoader = new NetworkClassLoader(Thread.currentThread().getContextClassLoader());
        this.adminClientConfig = adminClientConfig;
    }

    private Cluster getClusterFromBootstrapURL(String bootstrapURL) {
        ClientConfig config = new ClientConfig();
        config.setBootstrapUrls(bootstrapURL);
        SocketStoreClientFactory factory = new SocketStoreClientFactory(config);
        String clusterXml = factory.bootstrapMetadataWithRetries("cluster.xml", factory.validateUrls(config.getBootstrapUrls()));
        factory.close();
        return clusterMapper.readCluster(new StringReader(clusterXml), false);
    }

    private SocketPool createSocketPool(AdminClientConfig config) {
        TimeUnit unit = TimeUnit.SECONDS;
        return new SocketPool(config.getMaxConnectionsPerNode(), (int)unit.toMillis(config.getAdminConnectionTimeoutSec()), (int)unit.toMillis(config.getAdminSocketTimeoutSec()), config.getAdminSocketBufferSize(), config.getAdminSocketKeepAlive());
    }

    private <T extends Message.Builder> T sendAndReceive(int nodeId, Message message, T builder) {
        Node node = this.getAdminClientCluster().getNodeById(nodeId);
        SocketDestination destination = new SocketDestination(node.getHost(), node.getAdminPort(), RequestFormatType.ADMIN_PROTOCOL_BUFFERS);
        SocketAndStreams sands = this.pool.checkout(destination);
        try {
            DataOutputStream outputStream = sands.getOutputStream();
            DataInputStream inputStream = sands.getInputStream();
            ProtoUtils.writeMessage(outputStream, message);
            outputStream.flush();
            T t = ProtoUtils.readToBuilder(inputStream, builder);
            return t;
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new VoldemortException(e);
        }
        finally {
            this.pool.checkin(destination, sands);
        }
    }

    public void updateEntries(int nodeId, String storeName, Iterator<Pair<ByteArray, Versioned<byte[]>>> entryIterator, VoldemortFilter filter) {
        Node node = this.getAdminClientCluster().getNodeById(nodeId);
        SocketDestination destination = new SocketDestination(node.getHost(), node.getAdminPort(), RequestFormatType.ADMIN_PROTOCOL_BUFFERS);
        SocketAndStreams sands = this.pool.checkout(destination);
        DataOutputStream outputStream = sands.getOutputStream();
        DataInputStream inputStream = sands.getInputStream();
        boolean firstMessage = true;
        try {
            if (entryIterator.hasNext()) {
                while (entryIterator.hasNext()) {
                    Pair<ByteArray, Versioned<byte[]>> entry = entryIterator.next();
                    VAdminProto.PartitionEntry partitionEntry = VAdminProto.PartitionEntry.newBuilder().setKey(ProtoUtils.encodeBytes(entry.getFirst())).setVersioned(ProtoUtils.encodeVersioned(entry.getSecond())).build();
                    VAdminProto.UpdatePartitionEntriesRequest.Builder updateRequest = VAdminProto.UpdatePartitionEntriesRequest.newBuilder().setStore(storeName).setPartitionEntry(partitionEntry);
                    if (firstMessage) {
                        if (filter != null) {
                            updateRequest.setFilter(this.encodeFilter(filter));
                        }
                        ProtoUtils.writeMessage(outputStream, (Message)VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.UPDATE_PARTITION_ENTRIES).setUpdatePartitionEntries(updateRequest).build());
                        outputStream.flush();
                        firstMessage = false;
                        continue;
                    }
                    ProtoUtils.writeMessage(outputStream, (Message)updateRequest.build());
                }
                ProtoUtils.writeEndOfStream(outputStream);
                outputStream.flush();
                VAdminProto.UpdatePartitionEntriesResponse.Builder updateResponse = ProtoUtils.readToBuilder(inputStream, VAdminProto.UpdatePartitionEntriesResponse.newBuilder());
                if (updateResponse.hasError()) {
                    this.throwException(updateResponse.getError());
                }
            }
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new VoldemortException(e);
        }
        finally {
            this.pool.checkin(destination, sands);
        }
    }

    private void initiateFetchRequest(DataOutputStream outputStream, String storeName, HashMap<Integer, List<Integer>> replicaToPartitionList, VoldemortFilter filter, boolean fetchValues, boolean fetchMasterEntries, Cluster initialCluster, long skipRecords) throws IOException {
        HashMap filteredReplicaToPartitionList = Maps.newHashMap();
        if (fetchMasterEntries) {
            if (!replicaToPartitionList.containsKey(0)) {
                throw new VoldemortException("Could not find any partitions for primary replica type");
            }
            filteredReplicaToPartitionList.put(0, replicaToPartitionList.get(0));
        } else {
            filteredReplicaToPartitionList.putAll(replicaToPartitionList);
        }
        VAdminProto.FetchPartitionEntriesRequest.Builder fetchRequest = VAdminProto.FetchPartitionEntriesRequest.newBuilder().setFetchValues(fetchValues).addAllReplicaToPartition(ProtoUtils.encodePartitionTuple(filteredReplicaToPartitionList)).setStore(storeName).setSkipRecords(skipRecords);
        try {
            if (filter != null) {
                fetchRequest.setFilter(this.encodeFilter(filter));
            }
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        if (initialCluster != null) {
            fetchRequest.setInitialCluster(new ClusterMapper().writeCluster(initialCluster));
        }
        VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.FETCH_PARTITION_ENTRIES).setFetchPartitionEntries(fetchRequest).build();
        ProtoUtils.writeMessage(outputStream, (Message)request);
        outputStream.flush();
    }

    private VAdminProto.FetchPartitionEntriesResponse responseFromStream(DataInputStream inputStream, int size) throws IOException {
        byte[] input = new byte[size];
        ByteUtils.read(inputStream, input);
        VAdminProto.FetchPartitionEntriesResponse.Builder response = VAdminProto.FetchPartitionEntriesResponse.newBuilder();
        response.mergeFrom(input);
        return response.build();
    }

    public Iterator<Pair<ByteArray, Versioned<byte[]>>> fetchEntries(int nodeId, String storeName, List<Integer> partitionList, VoldemortFilter filter, boolean fetchMasterEntries, long skipRecords) {
        return this.fetchEntries(nodeId, storeName, this.getReplicaToPartitionMap(nodeId, storeName, partitionList), filter, fetchMasterEntries, null, skipRecords);
    }

    public Iterator<Pair<ByteArray, Versioned<byte[]>>> fetchEntries(int nodeId, String storeName, List<Integer> partitionList, VoldemortFilter filter, boolean fetchMasterEntries) {
        return this.fetchEntries(nodeId, storeName, partitionList, filter, fetchMasterEntries, 0L);
    }

    public Iterator<Pair<ByteArray, Versioned<byte[]>>> fetchEntries(int nodeId, String storeName, HashMap<Integer, List<Integer>> replicaToPartitionList, VoldemortFilter filter, boolean fetchMasterEntries, Cluster initialCluster, long skipRecords) {
        Node node = this.getAdminClientCluster().getNodeById(nodeId);
        final SocketDestination destination = new SocketDestination(node.getHost(), node.getAdminPort(), RequestFormatType.ADMIN_PROTOCOL_BUFFERS);
        final SocketAndStreams sands = this.pool.checkout(destination);
        DataOutputStream outputStream = sands.getOutputStream();
        final DataInputStream inputStream = sands.getInputStream();
        try {
            this.initiateFetchRequest(outputStream, storeName, replicaToPartitionList, filter, true, fetchMasterEntries, initialCluster, skipRecords);
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            this.pool.checkin(destination, sands);
            throw new VoldemortException(e);
        }
        return new AbstractIterator<Pair<ByteArray, Versioned<byte[]>>>(){

            public Pair<ByteArray, Versioned<byte[]>> computeNext() {
                try {
                    int size = inputStream.readInt();
                    if (size == -1) {
                        AdminClient.this.pool.checkin(destination, sands);
                        return (Pair)this.endOfData();
                    }
                    VAdminProto.FetchPartitionEntriesResponse response = AdminClient.this.responseFromStream(inputStream, size);
                    if (response.hasError()) {
                        AdminClient.this.pool.checkin(destination, sands);
                        AdminClient.this.throwException(response.getError());
                    }
                    VAdminProto.PartitionEntry partitionEntry = response.getPartitionEntry();
                    return Pair.create(ProtoUtils.decodeBytes(partitionEntry.getKey()), ProtoUtils.decodeVersioned(partitionEntry.getVersioned()));
                }
                catch (IOException e) {
                    AdminClient.this.close(sands.getSocket());
                    AdminClient.this.pool.checkin(destination, sands);
                    throw new VoldemortException(e);
                }
            }
        };
    }

    public Iterator<ByteArray> fetchKeys(int nodeId, String storeName, List<Integer> partitionList, VoldemortFilter filter, boolean fetchMasterEntries, long skipRecords) {
        return this.fetchKeys(nodeId, storeName, this.getReplicaToPartitionMap(nodeId, storeName, partitionList), filter, fetchMasterEntries, null, skipRecords);
    }

    public Iterator<ByteArray> fetchKeys(int nodeId, String storeName, List<Integer> partitionList, VoldemortFilter filter, boolean fetchMasterEntries) {
        return this.fetchKeys(nodeId, storeName, partitionList, filter, fetchMasterEntries, 0L);
    }

    public Iterator<ByteArray> fetchKeys(int nodeId, String storeName, HashMap<Integer, List<Integer>> replicaToPartitionList, VoldemortFilter filter, boolean fetchMasterEntries, Cluster initialCluster, long skipRecords) {
        Node node = this.getAdminClientCluster().getNodeById(nodeId);
        final SocketDestination destination = new SocketDestination(node.getHost(), node.getAdminPort(), RequestFormatType.ADMIN_PROTOCOL_BUFFERS);
        final SocketAndStreams sands = this.pool.checkout(destination);
        DataOutputStream outputStream = sands.getOutputStream();
        final DataInputStream inputStream = sands.getInputStream();
        try {
            this.initiateFetchRequest(outputStream, storeName, replicaToPartitionList, filter, false, fetchMasterEntries, initialCluster, skipRecords);
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            this.pool.checkin(destination, sands);
            throw new VoldemortException(e);
        }
        return new AbstractIterator<ByteArray>(){

            public ByteArray computeNext() {
                try {
                    int size = inputStream.readInt();
                    if (size == -1) {
                        AdminClient.this.pool.checkin(destination, sands);
                        return (ByteArray)this.endOfData();
                    }
                    VAdminProto.FetchPartitionEntriesResponse response = AdminClient.this.responseFromStream(inputStream, size);
                    if (response.hasError()) {
                        AdminClient.this.pool.checkin(destination, sands);
                        AdminClient.this.throwException(response.getError());
                    }
                    return ProtoUtils.decodeBytes(response.getKey());
                }
                catch (IOException e) {
                    AdminClient.this.close(sands.getSocket());
                    AdminClient.this.pool.checkin(destination, sands);
                    throw new VoldemortException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreDataFromReplications(int nodeId, int parallelTransfers) {
        ExecutorService executors = Executors.newFixedThreadPool(parallelTransfers, new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("restore-data-thread");
                return thread;
            }
        });
        try {
            List<StoreDefinition> storeDefList = this.getRemoteStoreDefList(nodeId).getValue();
            Cluster cluster = this.getRemoteCluster(nodeId).getValue();
            ArrayList writableStores = Lists.newArrayList();
            for (StoreDefinition def : storeDefList) {
                if (def.isView()) {
                    logger.info((Object)("Ignoring store " + def.getName() + " since it is a view"));
                    continue;
                }
                if (restoreStoreEngineBlackList.contains(def.getType())) {
                    logger.info((Object)("Ignoring store " + def.getName() + " since we don't support restoring for " + def.getType() + " storage engine"));
                    continue;
                }
                if (def.getReplicationFactor() == 1) {
                    logger.info((Object)("Ignoring store " + def.getName() + " since replication factor is set to 1"));
                    continue;
                }
                writableStores.add(def);
            }
            for (StoreDefinition def : writableStores) {
                if (def.getName().compareTo("test-recovery-data") != 0) continue;
                this.restoreStoreFromReplication(nodeId, cluster, def, executors);
            }
        }
        finally {
            executors.shutdown();
            try {
                executors.awaitTermination(this.adminClientConfig.getRestoreDataTimeoutSec(), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error((Object)"Interrupted while waiting restore operation to finish.");
            }
            logger.info((Object)"Finished restoring data.");
        }
    }

    public Map<Integer, HashMap<Integer, List<Integer>>> getReplicationMapping(int restoringNode, Cluster cluster, StoreDefinition storeDef) {
        Map<Integer, Integer> partitionToNodeId = RebalanceUtils.getCurrentPartitionMapping(cluster);
        HashMap returnMap = Maps.newHashMap();
        RoutingStrategy strategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDef, cluster);
        List<Integer> restoringNodePartition = cluster.getNodeById(restoringNode).getPartitionIds();
        for (Node node : cluster.getNodes()) {
            for (int partitionId : node.getPartitionIds()) {
                List<Integer> replicatingPartitions = strategy.getReplicatingPartitionList(partitionId);
                ArrayList extraCopyReplicatingPartitions = Lists.newArrayList(replicatingPartitions);
                if (replicatingPartitions.size() <= 1) {
                    throw new VoldemortException("Store " + storeDef.getName() + " cannot be restored from replica because replication factor = 1");
                }
                if (!replicatingPartitions.removeAll(restoringNodePartition)) continue;
                if (replicatingPartitions.size() == 0) {
                    throw new VoldemortException("Found a case where-in the overlap of the node partition list results in no replicas being left in replicating list");
                }
                int replicaType = extraCopyReplicatingPartitions.indexOf(replicatingPartitions.get(0));
                int partition = (Integer)extraCopyReplicatingPartitions.get(0);
                int nodeId = partitionToNodeId.get(replicatingPartitions.get(0));
                HashMap replicaToPartitionList = null;
                if (returnMap.containsKey(nodeId)) {
                    replicaToPartitionList = (HashMap)returnMap.get(nodeId);
                } else {
                    replicaToPartitionList = Maps.newHashMap();
                    returnMap.put(nodeId, replicaToPartitionList);
                }
                List<Integer> partitions = null;
                if (replicaToPartitionList.containsKey(replicaType)) {
                    partitions = (List)replicaToPartitionList.get(replicaType);
                } else {
                    partitions = Lists.newArrayList();
                    replicaToPartitionList.put(replicaType, partitions);
                }
                partitions.add(partition);
            }
        }
        return returnMap;
    }

    private void restoreStoreFromReplication(final int restoringNodeId, Cluster cluster, final StoreDefinition storeDef, ExecutorService executorService) {
        logger.info((Object)("Restoring data for store " + storeDef.getName() + " on node " + restoringNodeId));
        Map<Integer, HashMap<Integer, List<Integer>>> restoreMapping = this.getReplicationMapping(restoringNodeId, cluster, storeDef);
        for (final Map.Entry<Integer, HashMap<Integer, List<Integer>>> replicationEntry : restoreMapping.entrySet()) {
            final int donorNodeId = replicationEntry.getKey();
            executorService.submit(new Runnable(){

                public void run() {
                    try {
                        logger.info((Object)("Restoring data for store " + storeDef.getName() + " at node " + restoringNodeId + " from node " + replicationEntry.getKey() + " partitions:" + replicationEntry.getValue()));
                        int migrateAsyncId = AdminClient.this.migratePartitions(donorNodeId, restoringNodeId, storeDef.getName(), (HashMap)replicationEntry.getValue(), null, null, false);
                        AdminClient.this.waitForCompletion(restoringNodeId, migrateAsyncId, AdminClient.this.adminClientConfig.getRestoreDataTimeoutSec(), TimeUnit.SECONDS);
                        logger.info((Object)("Restoring data for store:" + storeDef.getName() + " from node " + donorNodeId + " completed."));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Restore operation for store " + storeDef.getName() + "from node " + donorNodeId + " failed."), (Throwable)e);
                    }
                }
            });
        }
    }

    public int rebalanceNode(RebalancePartitionsInfo stealInfo) {
        VAdminProto.RebalancePartitionInfoMap rebalancePartitionInfoMap = ProtoUtils.encodeRebalancePartitionInfoMap(stealInfo);
        VAdminProto.InitiateRebalanceNodeRequest rebalanceNodeRequest = VAdminProto.InitiateRebalanceNodeRequest.newBuilder().setRebalancePartitionInfo(rebalancePartitionInfoMap).build();
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.INITIATE_REBALANCE_NODE).setInitiateRebalanceNode(rebalanceNodeRequest).build();
        VAdminProto.AsyncOperationStatusResponse.Builder response = this.sendAndReceive(stealInfo.getStealerId(), (Message)adminRequest, VAdminProto.AsyncOperationStatusResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        return response.getRequestId();
    }

    private HashMap<Integer, List<Integer>> getReplicaToPartitionMap(int nodeId, String storeName, List<Integer> partitions) {
        StoreDefinition def = RebalanceUtils.getStoreDefinitionWithName(this.getRemoteStoreDefList(nodeId).getValue(), storeName);
        HashMap replicaToPartitionList = Maps.newHashMap();
        for (int replicaNum = 0; replicaNum < def.getReplicationFactor(); ++replicaNum) {
            replicaToPartitionList.put(replicaNum, partitions);
        }
        return replicaToPartitionList;
    }

    public int migratePartitions(int donorNodeId, int stealerNodeId, String storeName, List<Integer> stealPartitionList, VoldemortFilter filter) {
        return this.migratePartitions(donorNodeId, stealerNodeId, storeName, this.getReplicaToPartitionMap(donorNodeId, storeName, stealPartitionList), filter, null, false);
    }

    public int migratePartitions(int donorNodeId, int stealerNodeId, String storeName, HashMap<Integer, List<Integer>> replicaToPartitionList, VoldemortFilter filter, Cluster initialCluster, boolean optimize) {
        VAdminProto.InitiateFetchAndUpdateRequest.Builder initiateFetchAndUpdateRequest = VAdminProto.InitiateFetchAndUpdateRequest.newBuilder().setNodeId(donorNodeId).addAllReplicaToPartition(ProtoUtils.encodePartitionTuple(replicaToPartitionList)).setStore(storeName);
        try {
            if (filter != null) {
                initiateFetchAndUpdateRequest.setFilter(this.encodeFilter(filter));
            }
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        if (initialCluster != null) {
            initiateFetchAndUpdateRequest.setInitialCluster(new ClusterMapper().writeCluster(initialCluster));
        }
        initiateFetchAndUpdateRequest.setOptimize(optimize);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setInitiateFetchAndUpdate(initiateFetchAndUpdateRequest).setType(VAdminProto.AdminRequestType.INITIATE_FETCH_AND_UPDATE).build();
        VAdminProto.AsyncOperationStatusResponse.Builder response = this.sendAndReceive(stealerNodeId, (Message)adminRequest, VAdminProto.AsyncOperationStatusResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        return response.getRequestId();
    }

    public void truncate(int nodeId, String storeName) {
        VAdminProto.TruncateEntriesRequest.Builder truncateRequest = VAdminProto.TruncateEntriesRequest.newBuilder().setStore(storeName);
        VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.TRUNCATE_ENTRIES).setTruncateEntries(truncateRequest).build();
        VAdminProto.TruncateEntriesResponse.Builder response = this.sendAndReceive(nodeId, (Message)request, VAdminProto.TruncateEntriesResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    public AsyncOperationStatus getAsyncRequestStatus(int nodeId, int requestId) {
        VAdminProto.AsyncOperationStatusRequest asyncRequest = VAdminProto.AsyncOperationStatusRequest.newBuilder().setRequestId(requestId).build();
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.ASYNC_OPERATION_STATUS).setAsyncOperationStatus(asyncRequest).build();
        VAdminProto.AsyncOperationStatusResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.AsyncOperationStatusResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        AsyncOperationStatus status = new AsyncOperationStatus(response.getRequestId(), response.getDescription());
        status.setStatus(response.getStatus());
        status.setComplete(response.getComplete());
        return status;
    }

    public List<Integer> getAsyncRequestList(int nodeId) {
        return this.getAsyncRequestList(nodeId, false);
    }

    public List<Integer> getAsyncRequestList(int nodeId, boolean showComplete) {
        VAdminProto.AsyncOperationListRequest asyncOperationListRequest = VAdminProto.AsyncOperationListRequest.newBuilder().setShowComplete(showComplete).build();
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.ASYNC_OPERATION_LIST).setAsyncOperationList(asyncOperationListRequest).build();
        VAdminProto.AsyncOperationListResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.AsyncOperationListResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        return response.getRequestIdsList();
    }

    public void stopAsyncRequest(int nodeId, int requestId) {
        VAdminProto.AsyncOperationStopRequest asyncOperationStopRequest = VAdminProto.AsyncOperationStopRequest.newBuilder().setRequestId(requestId).build();
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.ASYNC_OPERATION_STOP).setAsyncOperationStop(asyncOperationStopRequest).build();
        VAdminProto.AsyncOperationStopResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.AsyncOperationStopResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    private VAdminProto.VoldemortFilter encodeFilter(VoldemortFilter filter) throws IOException {
        Class<?> cl = filter.getClass();
        byte[] classBytes = this.networkClassLoader.dumpClass(cl);
        return VAdminProto.VoldemortFilter.newBuilder().setName(cl.getName()).setData(ProtoUtils.encodeBytes(new ByteArray(classBytes))).build();
    }

    public long deletePartitions(int nodeId, String storeName, List<Integer> partitionList, VoldemortFilter filter) {
        return this.deletePartitions(nodeId, storeName, this.getReplicaToPartitionMap(nodeId, storeName, partitionList), null, filter);
    }

    public long deletePartitions(int nodeId, String storeName, HashMap<Integer, List<Integer>> replicaToPartitionList, Cluster initialCluster, VoldemortFilter filter) {
        VAdminProto.VoldemortAdminRequest request;
        VAdminProto.DeletePartitionEntriesResponse.Builder response;
        VAdminProto.DeletePartitionEntriesRequest.Builder deleteRequest = VAdminProto.DeletePartitionEntriesRequest.newBuilder().addAllReplicaToPartition(ProtoUtils.encodePartitionTuple(replicaToPartitionList)).setStore(storeName);
        try {
            if (filter != null) {
                deleteRequest.setFilter(this.encodeFilter(filter));
            }
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        if (initialCluster != null) {
            deleteRequest.setInitialCluster(new ClusterMapper().writeCluster(initialCluster));
        }
        if ((response = this.sendAndReceive(nodeId, (Message)(request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.DELETE_PARTITION_ENTRIES).setDeletePartitionEntries(deleteRequest).build()), VAdminProto.DeletePartitionEntriesResponse.newBuilder())).hasError()) {
            this.throwException(response.getError());
        }
        return response.getCount();
    }

    public void throwException(VProto.Error error) {
        throw this.errorMapper.getError((short)error.getErrorCode(), error.getErrorMessage());
    }

    private void close(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to close socket");
        }
    }

    public void stop() {
        this.pool.close();
    }

    public String waitForCompletion(int nodeId, int requestId, long maxWait, TimeUnit timeUnit, AsyncOperationStatus higherStatus) {
        long delay = 250L;
        long waitUntil = System.currentTimeMillis() + timeUnit.toMillis(maxWait);
        String description = null;
        while (System.currentTimeMillis() < waitUntil) {
            try {
                AsyncOperationStatus status = this.getAsyncRequestStatus(nodeId, requestId);
                logger.info((Object)("Status from node " + nodeId + " (" + status.getDescription() + ") - " + status.getStatus()));
                if (higherStatus != null) {
                    higherStatus.setStatus("Status from node " + nodeId + " (" + status.getDescription() + ") - " + status.getStatus());
                }
                description = status.getDescription();
                if (status.hasException()) {
                    throw status.getException();
                }
                if (status.isComplete()) {
                    return status.getStatus();
                }
                if (delay < (long)this.adminClientConfig.getMaxBackoffDelayMs()) {
                    delay <<= 1;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                throw new VoldemortException("Failed while waiting for async task (" + description + ") at node " + nodeId + " to finish", e);
            }
        }
        throw new VoldemortException("Failed to finish task requestId: " + requestId + " in maxWait " + maxWait + " " + timeUnit.toString());
    }

    public String waitForCompletion(int nodeId, int requestId, long maxWait, TimeUnit timeUnit) {
        return this.waitForCompletion(nodeId, requestId, maxWait, timeUnit, null);
    }

    public void waitForCompletion(int nodeId, String key, String value, long maxWait, TimeUnit timeUnit) {
        long delay = 250L;
        long waitUntil = System.currentTimeMillis() + timeUnit.toMillis(maxWait);
        while (System.currentTimeMillis() < waitUntil) {
            String currentValue = this.getRemoteMetadata(nodeId, key).getValue();
            if (value.equals(currentValue)) {
                return;
            }
            logger.debug((Object)("waiting for value " + value + " for metadata key " + key + " from remote node " + nodeId + " currentValue " + currentValue));
            if (delay < (long)this.adminClientConfig.getMaxBackoffDelayMs()) {
                delay <<= 1;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new VoldemortException("Failed to get matching value " + value + " for key " + key + " at remote node " + nodeId + " in maximum wait" + maxWait + " " + timeUnit.toString() + " time.");
    }

    public void updateRemoteMetadata(int remoteNodeId, String key, Versioned<String> value) {
        ByteArray keyBytes = new ByteArray(ByteUtils.getBytes(key, "UTF-8"));
        Versioned<byte[]> valueBytes = new Versioned<byte[]>(ByteUtils.getBytes(value.getValue(), "UTF-8"), value.getVersion());
        VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.UPDATE_METADATA).setUpdateMetadata(VAdminProto.UpdateMetadataRequest.newBuilder().setKey(ByteString.copyFrom((byte[])keyBytes.get())).setVersioned(ProtoUtils.encodeVersioned(valueBytes)).build()).build();
        VAdminProto.UpdateMetadataResponse.Builder response = this.sendAndReceive(remoteNodeId, (Message)request, VAdminProto.UpdateMetadataResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    public Versioned<String> getRemoteMetadata(int remoteNodeId, String key) {
        ByteArray keyBytes = new ByteArray(ByteUtils.getBytes(key, "UTF-8"));
        VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.GET_METADATA).setGetMetadata(VAdminProto.GetMetadataRequest.newBuilder().setKey(ByteString.copyFrom((byte[])keyBytes.get()))).build();
        VAdminProto.GetMetadataResponse.Builder response = this.sendAndReceive(remoteNodeId, (Message)request, VAdminProto.GetMetadataResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        Versioned<byte[]> value = ProtoUtils.decodeVersioned(response.getVersion());
        return new Versioned<String>(ByteUtils.getString(value.getValue(), "UTF-8"), value.getVersion());
    }

    public void updateRemoteCluster(int nodeId, Cluster cluster, Version clock) throws VoldemortException {
        this.updateRemoteMetadata(nodeId, "cluster.xml", new Versioned<String>(clusterMapper.writeCluster(cluster), clock));
    }

    public Versioned<Cluster> getRemoteCluster(int nodeId) throws VoldemortException {
        Versioned<String> value = this.getRemoteMetadata(nodeId, "cluster.xml");
        Cluster cluster = clusterMapper.readCluster(new StringReader(value.getValue()), false);
        return new Versioned<Cluster>(cluster, value.getVersion());
    }

    public void updateRemoteStoreDefList(int nodeId, List<StoreDefinition> storesList) throws VoldemortException {
        VectorClock oldClock = (VectorClock)this.getRemoteStoreDefList(nodeId).getVersion();
        this.updateRemoteMetadata(nodeId, "stores.xml", new Versioned<String>(storeMapper.writeStoreList(storesList), oldClock.incremented(nodeId, 1L)));
    }

    public Versioned<List<StoreDefinition>> getRemoteStoreDefList(int nodeId) throws VoldemortException {
        Versioned<String> value = this.getRemoteMetadata(nodeId, "stores.xml");
        List<StoreDefinition> storeList = storeMapper.readStoreList(new StringReader(value.getValue()), false);
        return new Versioned<List<StoreDefinition>>(storeList, value.getVersion());
    }

    public void updateRemoteServerState(int nodeId, MetadataStore.VoldemortState state, Version clock) {
        this.updateRemoteMetadata(nodeId, "server.state", new Versioned<String>(state.toString(), clock));
    }

    public Versioned<MetadataStore.VoldemortState> getRemoteServerState(int nodeId) {
        Versioned<String> value = this.getRemoteMetadata(nodeId, "server.state");
        return new Versioned<MetadataStore.VoldemortState>(MetadataStore.VoldemortState.valueOf(value.getValue()), value.getVersion());
    }

    public void addStore(StoreDefinition def) {
        for (Node node : this.currentCluster.getNodes()) {
            this.addStore(def, node.getId());
        }
    }

    public void addStore(StoreDefinition def, int nodeId) {
        String value = storeMapper.writeStore(def);
        VAdminProto.AddStoreRequest.Builder addStoreRequest = VAdminProto.AddStoreRequest.newBuilder().setStoreDefinition(value);
        VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.ADD_STORE).setAddStore(addStoreRequest).build();
        Node node = this.currentCluster.getNodeById(nodeId);
        if (null == node) {
            throw new VoldemortException("Invalid node id (" + nodeId + ") specified");
        }
        logger.info((Object)("Adding store " + def.getName() + " on node " + node.getHost() + ":" + node.getId()));
        VAdminProto.AddStoreResponse.Builder response = this.sendAndReceive(nodeId, (Message)request, VAdminProto.AddStoreResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        logger.info((Object)("Succesfully added " + def.getName() + " on node " + node.getHost() + ":" + node.getId()));
    }

    public void deleteStore(String storeName) {
        for (Node node : this.currentCluster.getNodes()) {
            this.deleteStore(storeName, node.getId());
        }
    }

    public void deleteStore(String storeName, int nodeId) {
        VAdminProto.DeleteStoreRequest.Builder deleteStoreRequest = VAdminProto.DeleteStoreRequest.newBuilder().setStoreName(storeName);
        VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.DELETE_STORE).setDeleteStore(deleteStoreRequest).build();
        Node node = this.currentCluster.getNodeById(nodeId);
        if (null == node) {
            throw new VoldemortException("Invalid node id (" + nodeId + ") specified");
        }
        logger.info((Object)("Deleting " + storeName + " on node " + node.getHost() + ":" + node.getId()));
        VAdminProto.DeleteStoreResponse.Builder response = this.sendAndReceive(node.getId(), (Message)request, VAdminProto.DeleteStoreResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        logger.info((Object)("Successfully deleted " + storeName + " on node " + node.getHost() + ":" + node.getId()));
    }

    public void setAdminClientCluster(Cluster cluster) {
        this.currentCluster = cluster;
    }

    public Cluster getAdminClientCluster() {
        return this.currentCluster;
    }

    public void rollbackStore(int nodeId, String storeName, long pushVersion) {
        VAdminProto.RollbackStoreRequest.Builder rollbackStoreRequest = VAdminProto.RollbackStoreRequest.newBuilder().setStoreName(storeName).setPushVersion(pushVersion);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setRollbackStore(rollbackStoreRequest).setType(VAdminProto.AdminRequestType.ROLLBACK_STORE).build();
        VAdminProto.RollbackStoreResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.RollbackStoreResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    public String fetchStore(int nodeId, String storeName, String storeDir, long pushVersion, long timeoutMs) {
        VAdminProto.VoldemortAdminRequest adminRequest;
        VAdminProto.AsyncOperationStatusResponse.Builder response;
        VAdminProto.FetchStoreRequest.Builder fetchStoreRequest = VAdminProto.FetchStoreRequest.newBuilder().setStoreName(storeName).setStoreDir(storeDir);
        if (pushVersion > 0L) {
            fetchStoreRequest.setPushVersion(pushVersion);
        }
        if ((response = this.sendAndReceive(nodeId, (Message)(adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setFetchStore(fetchStoreRequest).setType(VAdminProto.AdminRequestType.FETCH_STORE).build()), VAdminProto.AsyncOperationStatusResponse.newBuilder())).hasError()) {
            this.throwException(response.getError());
        }
        int asyncId = response.getRequestId();
        return this.waitForCompletion(nodeId, asyncId, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void failedFetchStore(int nodeId, String storeName, String storeDir) {
        VAdminProto.FailedFetchStoreRequest.Builder failedFetchStoreRequest = VAdminProto.FailedFetchStoreRequest.newBuilder().setStoreDir(storeDir).setStoreName(storeName);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setFailedFetchStore(failedFetchStoreRequest).setType(VAdminProto.AdminRequestType.FAILED_FETCH_STORE).build();
        VAdminProto.FailedFetchStoreResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.FailedFetchStoreResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    public String swapStore(int nodeId, String storeName, String storeDir) {
        VAdminProto.SwapStoreRequest.Builder swapStoreRequest = VAdminProto.SwapStoreRequest.newBuilder().setStoreDir(storeDir).setStoreName(storeName);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setSwapStore(swapStoreRequest).setType(VAdminProto.AdminRequestType.SWAP_STORE).build();
        VAdminProto.SwapStoreResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.SwapStoreResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        return response.getPreviousStoreDir();
    }

    public Map<String, String> getROStorageFormat(int nodeId, List<String> storeNames) {
        Map<String, String> storeToValues;
        VAdminProto.GetROStorageFormatRequest.Builder getRORequest = VAdminProto.GetROStorageFormatRequest.newBuilder().addAllStoreName(storeNames);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setGetRoStorageFormat(getRORequest).setType(VAdminProto.AdminRequestType.GET_RO_STORAGE_FORMAT).build();
        VAdminProto.GetROStorageFormatResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.GetROStorageFormatResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        if ((storeToValues = ProtoUtils.encodeROMap(response.getRoStoreVersionsList())).size() != storeNames.size()) {
            storeNames.removeAll(storeToValues.keySet());
            throw new VoldemortException("Did not retrieve values for " + storeNames);
        }
        return storeToValues;
    }

    public Map<String, String> getROMaxVersionDir(int nodeId, List<String> storeNames) {
        Map<String, String> storeToValues;
        VAdminProto.GetROMaxVersionDirRequest.Builder getRORequest = VAdminProto.GetROMaxVersionDirRequest.newBuilder().addAllStoreName(storeNames);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setGetRoMaxVersionDir(getRORequest).setType(VAdminProto.AdminRequestType.GET_RO_MAX_VERSION_DIR).build();
        VAdminProto.GetROMaxVersionDirResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.GetROMaxVersionDirResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        if ((storeToValues = ProtoUtils.encodeROMap(response.getRoStoreVersionsList())).size() != storeNames.size()) {
            storeNames.removeAll(storeToValues.keySet());
            throw new VoldemortException("Did not retrieve values for " + storeNames);
        }
        return storeToValues;
    }

    public Map<String, String> getROCurrentVersionDir(int nodeId, List<String> storeNames) {
        Map<String, String> storeToValues;
        VAdminProto.GetROCurrentVersionDirRequest.Builder getRORequest = VAdminProto.GetROCurrentVersionDirRequest.newBuilder().addAllStoreName(storeNames);
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setGetRoCurrentVersionDir(getRORequest).setType(VAdminProto.AdminRequestType.GET_RO_CURRENT_VERSION_DIR).build();
        VAdminProto.GetROCurrentVersionDirResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.GetROCurrentVersionDirResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        if ((storeToValues = ProtoUtils.encodeROMap(response.getRoStoreVersionsList())).size() != storeNames.size()) {
            storeNames.removeAll(storeToValues.keySet());
            throw new VoldemortException("Did not retrieve values for " + storeNames);
        }
        return storeToValues;
    }

    public Map<String, Long> getROCurrentVersion(int nodeId, List<String> storeNames) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)storeNames.size());
        Map<String, String> versionDirs = this.getROCurrentVersionDir(nodeId, storeNames);
        for (String storeName : versionDirs.keySet()) {
            returnMap.put(storeName, ReadOnlyUtils.getVersionId(new File(versionDirs.get(storeName))));
        }
        return returnMap;
    }

    public Map<String, Long> getROMaxVersion(int nodeId, List<String> storeNames) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)storeNames.size());
        Map<String, String> versionDirs = this.getROMaxVersionDir(nodeId, storeNames);
        for (String storeName : versionDirs.keySet()) {
            returnMap.put(storeName, ReadOnlyUtils.getVersionId(new File(versionDirs.get(storeName))));
        }
        return returnMap;
    }

    public Map<String, Long> getROMaxVersion(List<String> storeNames) {
        HashMap storeToMaxVersion = Maps.newHashMapWithExpectedSize((int)storeNames.size());
        for (String storeName : storeNames) {
            storeToMaxVersion.put(storeName, 0L);
        }
        for (Node node : this.currentCluster.getNodes()) {
            Map<String, Long> currentNodeVersions = this.getROMaxVersion(node.getId(), storeNames);
            for (String storeName : currentNodeVersions.keySet()) {
                Long maxVersion = (Long)storeToMaxVersion.get(storeName);
                if (maxVersion == null || maxVersion >= currentNodeVersions.get(storeName)) continue;
                storeToMaxVersion.put(storeName, currentNodeVersions.get(storeName));
            }
        }
        return storeToMaxVersion;
    }

    public void updateSlopEntries(int nodeId, Iterator<Versioned<Slop>> entryIterator) {
        Node node = this.getAdminClientCluster().getNodeById(nodeId);
        SocketDestination destination = new SocketDestination(node.getHost(), node.getAdminPort(), RequestFormatType.ADMIN_PROTOCOL_BUFFERS);
        SocketAndStreams sands = this.pool.checkout(destination);
        DataOutputStream outputStream = sands.getOutputStream();
        DataInputStream inputStream = sands.getInputStream();
        boolean firstMessage = true;
        try {
            if (entryIterator.hasNext()) {
                while (entryIterator.hasNext()) {
                    Versioned<Slop> versionedSlop = entryIterator.next();
                    Slop slop = versionedSlop.getValue();
                    VProto.RequestType requestType = null;
                    if (slop.getOperation().equals((Object)Slop.Operation.PUT)) {
                        requestType = VProto.RequestType.PUT;
                    } else if (slop.getOperation().equals((Object)Slop.Operation.DELETE)) {
                        requestType = VProto.RequestType.DELETE;
                    } else {
                        logger.error((Object)"Unsupported operation. Skipping");
                        continue;
                    }
                    VAdminProto.UpdateSlopEntriesRequest.Builder updateRequest = VAdminProto.UpdateSlopEntriesRequest.newBuilder().setStore(slop.getStoreName()).setKey(ProtoUtils.encodeBytes(slop.getKey())).setVersion(ProtoUtils.encodeClock(versionedSlop.getVersion())).setRequestType(requestType);
                    if (slop.getTransforms() != null) {
                        updateRequest.setTransform(ProtoUtils.encodeTransform(slop.getTransforms()));
                    }
                    if (slop.getValue() != null) {
                        updateRequest.setValue(ByteString.copyFrom((byte[])slop.getValue()));
                    }
                    if (firstMessage) {
                        ProtoUtils.writeMessage(outputStream, (Message)VAdminProto.VoldemortAdminRequest.newBuilder().setType(VAdminProto.AdminRequestType.UPDATE_SLOP_ENTRIES).setUpdateSlopEntries(updateRequest).build());
                        outputStream.flush();
                        firstMessage = false;
                        continue;
                    }
                    ProtoUtils.writeMessage(outputStream, (Message)updateRequest.build());
                }
                ProtoUtils.writeEndOfStream(outputStream);
                outputStream.flush();
                VAdminProto.UpdateSlopEntriesResponse.Builder updateResponse = ProtoUtils.readToBuilder(inputStream, VAdminProto.UpdateSlopEntriesResponse.newBuilder());
                if (updateResponse.hasError()) {
                    this.throwException(updateResponse.getError());
                }
            }
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new VoldemortException(e);
        }
        finally {
            this.pool.checkin(destination, sands);
        }
    }

    public void fetchPartitionFiles(int nodeId, String storeName, HashMap<Integer, List<Integer>> replicaToPartitionList, String destinationDirPath, Set<Object> notAcceptedBuckets, AtomicBoolean running) {
        if (!Utils.isReadableDir(destinationDirPath)) {
            throw new VoldemortException("The destination path (" + destinationDirPath + ") to store " + storeName + " does not exist");
        }
        Node node = this.getAdminClientCluster().getNodeById(nodeId);
        SocketDestination destination = new SocketDestination(node.getHost(), node.getAdminPort(), RequestFormatType.ADMIN_PROTOCOL_BUFFERS);
        SocketAndStreams sands = this.pool.checkout(destination);
        DataOutputStream outputStream = sands.getOutputStream();
        DataInputStream inputStream = sands.getInputStream();
        try {
            File metadataFile = new File(destinationDirPath, ".metadata");
            if (!metadataFile.exists()) {
                ReadOnlyStorageMetadata metadata = new ReadOnlyStorageMetadata();
                metadata.add("format", ReadOnlyStorageFormat.READONLY_V2.getCode());
                FileUtils.writeStringToFile((File)metadataFile, (String)metadata.toJsonString());
            }
            VAdminProto.FetchPartitionFilesRequest fetchPartitionFileRequest = VAdminProto.FetchPartitionFilesRequest.newBuilder().addAllReplicaToPartition(ProtoUtils.encodePartitionTuple(replicaToPartitionList)).setStore(storeName).build();
            VAdminProto.VoldemortAdminRequest request = VAdminProto.VoldemortAdminRequest.newBuilder().setFetchPartitionFiles(fetchPartitionFileRequest).setType(VAdminProto.AdminRequestType.FETCH_PARTITION_FILES).build();
            ProtoUtils.writeMessage(outputStream, (Message)request);
            outputStream.flush();
            while (running.get()) {
                Pair<Integer, Integer> partitionReplicaTuple;
                int size = 0;
                try {
                    size = inputStream.readInt();
                }
                catch (IOException e) {
                    logger.error((Object)"Received IOException while fetching files", (Throwable)e);
                    throw e;
                }
                if (size == -1) {
                    this.close(sands.getSocket());
                    break;
                }
                byte[] input = new byte[size];
                ByteUtils.read(inputStream, input);
                VAdminProto.FileEntry fileEntry = ((VAdminProto.FileEntry.Builder)VAdminProto.FileEntry.newBuilder().mergeFrom(input)).build();
                if (notAcceptedBuckets != null && notAcceptedBuckets.contains(partitionReplicaTuple = ReadOnlyUtils.getPartitionReplicaTuple(fileEntry.getFileName()))) {
                    throw new VoldemortException("Cannot copy file " + fileEntry.getFileName() + " since it is one of the mmap-ed files");
                }
                logger.info((Object)("Receiving file " + fileEntry.getFileName()));
                FileChannel fileChannel = new FileOutputStream(new File(destinationDirPath, fileEntry.getFileName())).getChannel();
                ReadableByteChannel channelIn = Channels.newChannel(inputStream);
                fileChannel.transferFrom(channelIn, 0L, fileEntry.getFileSizeBytes());
                fileChannel.force(true);
                fileChannel.close();
                logger.info((Object)("Completed file " + fileEntry.getFileName()));
            }
        }
        catch (IOException e) {
            this.close(sands.getSocket());
            throw new VoldemortException(e);
        }
        finally {
            this.pool.checkin(destination, sands);
        }
    }

    public void rebalanceStateChange(Cluster existingCluster, Cluster transitionCluster, List<RebalancePartitionsInfo> rebalancePartitionPlanList, boolean swapRO, boolean changeClusterMetadata, boolean changeRebalanceState, boolean rollback, boolean failEarly) {
        HashMap<Integer, List<RebalancePartitionsInfo>> stealerNodeToPlan = this.groupPartitionsInfoByStealerNode(rebalancePartitionPlanList);
        HashSet completedNodeIds = Sets.newHashSet();
        HashMap exceptions = Maps.newHashMap();
        try {
            for (int nodeId = 0; nodeId < transitionCluster.getNumberOfNodes(); ++nodeId) {
                try {
                    this.individualStateChange(nodeId, transitionCluster, stealerNodeToPlan.get(nodeId), swapRO, changeClusterMetadata, changeRebalanceState, false);
                    completedNodeIds.add(nodeId);
                    continue;
                }
                catch (Exception e) {
                    exceptions.put(nodeId, e);
                    if (!failEarly) continue;
                    throw e;
                }
            }
            if (exceptions.size() > 0) {
                throw new VoldemortRebalancingException("Got exceptions from nodes " + exceptions.keySet());
            }
        }
        catch (Exception e) {
            if (rollback) {
                logger.error((Object)("Got exceptions from nodes " + exceptions.keySet() + " while changing state. Rolling back state on " + completedNodeIds));
                Iterator i$ = completedNodeIds.iterator();
                while (i$.hasNext()) {
                    int completedNodeId = (Integer)i$.next();
                    try {
                        this.individualStateChange(completedNodeId, existingCluster, stealerNodeToPlan.get(completedNodeId), swapRO, changeClusterMetadata, changeRebalanceState, true);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error while reverting back state change for completed node " + completedNodeId), (Throwable)exception);
                    }
                }
            } else {
                logger.error((Object)("Got exceptions from nodes " + exceptions.keySet() + " while changing state"));
            }
            throw new VoldemortRebalancingException("Got exceptions from nodes " + exceptions.keySet() + " while changing state", Lists.newArrayList(exceptions.values()));
        }
    }

    private void individualStateChange(int nodeId, Cluster cluster, List<RebalancePartitionsInfo> rebalancePartitionPlanList, boolean swapRO, boolean changeClusterMetadata, boolean changeRebalanceState, boolean rollback) {
        if (!changeClusterMetadata && rebalancePartitionPlanList == null) {
            return;
        }
        logger.info((Object)("Node " + nodeId + "] Performing " + (rollback ? "rollback" : "normal") + " rebalance state change " + (swapRO ? "<swap RO>" : "") + (changeClusterMetadata ? "<change cluster - " + cluster + ">" : "") + (changeRebalanceState ? "<change rebalance state - " + rebalancePartitionPlanList + ">" : "")));
        VAdminProto.RebalanceStateChangeRequest.Builder getRebalanceStateChangeRequestBuilder = VAdminProto.RebalanceStateChangeRequest.newBuilder();
        if (rebalancePartitionPlanList != null) {
            ArrayList map = Lists.newArrayList();
            for (RebalancePartitionsInfo stealInfo : rebalancePartitionPlanList) {
                VAdminProto.RebalancePartitionInfoMap infoMap = ProtoUtils.encodeRebalancePartitionInfoMap(stealInfo);
                map.add(infoMap);
            }
            getRebalanceStateChangeRequestBuilder.addAllRebalancePartitionInfoList(map);
        }
        VAdminProto.RebalanceStateChangeRequest getRebalanceStateChangeRequest = getRebalanceStateChangeRequestBuilder.setSwapRo(swapRO).setChangeClusterMetadata(changeClusterMetadata).setChangeRebalanceState(changeRebalanceState).setClusterString(clusterMapper.writeCluster(cluster)).setRollback(rollback).build();
        VAdminProto.VoldemortAdminRequest adminRequest = VAdminProto.VoldemortAdminRequest.newBuilder().setRebalanceStateChange(getRebalanceStateChangeRequest).setType(VAdminProto.AdminRequestType.REBALANCE_STATE_CHANGE).build();
        VAdminProto.RebalanceStateChangeResponse.Builder response = this.sendAndReceive(nodeId, (Message)adminRequest, VAdminProto.RebalanceStateChangeResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    private HashMap<Integer, List<RebalancePartitionsInfo>> groupPartitionsInfoByStealerNode(List<RebalancePartitionsInfo> rebalancePartitionPlanList) {
        HashMap stealerNodeToPlan = Maps.newHashMap();
        if (rebalancePartitionPlanList != null) {
            for (RebalancePartitionsInfo partitionInfo : rebalancePartitionPlanList) {
                List partitionInfos = (List)stealerNodeToPlan.get(partitionInfo.getStealerId());
                if (partitionInfos == null) {
                    partitionInfos = Lists.newArrayList();
                    stealerNodeToPlan.put(partitionInfo.getStealerId(), partitionInfos);
                }
                partitionInfos.add(partitionInfo);
            }
        }
        return stealerNodeToPlan;
    }
}

