/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import voldemort.VoldemortException;
import voldemort.client.AbstractStoreClientFactory;
import voldemort.client.ClientConfig;
import voldemort.client.LazyStoreClient;
import voldemort.client.RoutingTier;
import voldemort.client.StoreClient;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.ClientStoreVerifier;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.FailureDetectorUtils;
import voldemort.server.RequestRoutingType;
import voldemort.store.Store;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketStoreFactory;
import voldemort.store.socket.clientrequest.ClientRequestExecutorPool;
import voldemort.utils.ByteArray;
import voldemort.utils.JmxUtils;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketStoreClientFactory
extends AbstractStoreClientFactory {
    public static final String URL_SCHEME = "tcp";
    private final SocketStoreFactory storeFactory;
    private FailureDetectorListener failureDetectorListener;
    private final RequestRoutingType requestRoutingType;

    public SocketStoreClientFactory(ClientConfig config) {
        super(config);
        this.requestRoutingType = RequestRoutingType.getRequestRoutingType(RoutingTier.SERVER.equals((Object)config.getRoutingTier()), false);
        this.storeFactory = new ClientRequestExecutorPool(config.getSelectors(), config.getMaxConnectionsPerNode(), config.getConnectionTimeout(TimeUnit.MILLISECONDS), config.getSocketTimeout(TimeUnit.MILLISECONDS), config.getSocketBufferSize(), config.getSocketKeepAlive());
        if (config.isJmxEnabled()) {
            JmxUtils.registerMbean(this.storeFactory, JmxUtils.createObjectName(this.storeFactory.getClass()));
        }
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(final String storeName, final InconsistencyResolver<Versioned<V>> resolver) {
        if (this.getConfig().isLazyEnabled()) {
            return new LazyStoreClient(new Callable<StoreClient<K, V>>(){

                @Override
                public StoreClient<K, V> call() throws Exception {
                    return SocketStoreClientFactory.this.getParentStoreClient(storeName, resolver);
                }
            });
        }
        return this.getParentStoreClient(storeName, resolver);
    }

    private <K, V> StoreClient<K, V> getParentStoreClient(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        return super.getStoreClient(storeName, resolver);
    }

    @Override
    protected List<Versioned<String>> getRemoteMetadata(String key, URI url) {
        try {
            return super.getRemoteMetadata(key, url);
        }
        catch (VoldemortException e) {
            SocketDestination destination = new SocketDestination(url.getHost(), url.getPort(), this.getRequestFormatType());
            this.storeFactory.close(destination);
            throw new VoldemortException(e);
        }
    }

    @Override
    protected Store<ByteArray, byte[], byte[]> getStore(String storeName, String host, int port, RequestFormatType type) {
        return this.storeFactory.create(storeName, host, port, type, this.requestRoutingType);
    }

    @Override
    protected FailureDetector initFailureDetector(final ClientConfig config, Collection<Node> nodes) {
        this.failureDetectorListener = new FailureDetectorListener(){

            public void nodeAvailable(Node node) {
            }

            public void nodeUnavailable(Node node) {
                if (AbstractStoreClientFactory.logger.isInfoEnabled()) {
                    AbstractStoreClientFactory.logger.info((Object)(node + " has been marked as unavailable, destroying socket pool"));
                }
                SocketDestination destination = new SocketDestination(node.getHost(), node.getSocketPort(), config.getRequestFormatType());
                SocketStoreClientFactory.this.storeFactory.close(destination);
            }
        };
        ClientStoreVerifier storeVerifier = new ClientStoreVerifier(){

            @Override
            protected Store<ByteArray, byte[], byte[]> getStoreInternal(Node node) {
                return SocketStoreClientFactory.this.getStore("metadata", node.getHost(), node.getSocketPort(), config.getRequestFormatType());
            }
        };
        FailureDetectorConfig failureDetectorConfig = new FailureDetectorConfig(config).setNodes(nodes).setStoreVerifier(storeVerifier);
        return FailureDetectorUtils.create(failureDetectorConfig, true, this.failureDetectorListener);
    }

    @Override
    protected int getPort(Node node) {
        return node.getSocketPort();
    }

    @Override
    protected void validateUrl(URI url) {
        if (!URL_SCHEME.equals(url.getScheme())) {
            throw new IllegalArgumentException("Illegal scheme in bootstrap URL for SocketStoreClientFactory: expected 'tcp' but found '" + url.getScheme() + "'.");
        }
    }

    @Override
    public void close() {
        this.storeFactory.close();
        if (this.failureDetector != null) {
            this.failureDetector.removeFailureDetectorListener(this.failureDetectorListener);
        }
        super.close();
    }
}

