/*
 * Decompiled with CFR 0.152.
 */
package voldemort;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.server.rebalance.RebalancerState;
import voldemort.store.StoreDefinition;
import voldemort.store.compress.CompressionStrategy;
import voldemort.store.compress.CompressionStrategyFactory;
import voldemort.store.metadata.MetadataStore;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.CmdUtils;
import voldemort.utils.KeyDistributionGenerator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortAdminTool {
    private static final String ALL_METADATA = "all";

    public static void main(String[] args) throws Exception {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print help information");
        parser.accepts("url", "[REQUIRED] bootstrap URL").withRequiredArg().describedAs("bootstrap-url").ofType(String.class);
        parser.accepts("node", "node id").withRequiredArg().describedAs("node-id").ofType(Integer.class);
        parser.accepts("delete-partitions", "Delete partitions").withRequiredArg().describedAs("partition-ids").withValuesSeparatedBy(',').ofType(Integer.class);
        parser.accepts("restore", "Restore from replication [ Optional parallelism param - Default - 5 ]").withOptionalArg().describedAs("parallelism").ofType(Integer.class);
        parser.accepts("ascii", "Fetch keys as ASCII");
        parser.accepts("fetch-keys", "Fetch keys").withOptionalArg().describedAs("partition-ids").withValuesSeparatedBy(',').ofType(Integer.class);
        parser.accepts("fetch-entries", "Fetch full entries").withOptionalArg().describedAs("partition-ids").withValuesSeparatedBy(',').ofType(Integer.class);
        parser.accepts("outdir", "Output directory").withRequiredArg().describedAs("output-directory").ofType(String.class);
        parser.accepts("stores", "Store names").withRequiredArg().describedAs("store-names").withValuesSeparatedBy(',').ofType(String.class);
        parser.accepts("add-stores", "Add stores in this stores.xml").withRequiredArg().describedAs("stores.xml containing just the new stores").ofType(String.class);
        parser.accepts("delete-store", "Delete store").withRequiredArg().describedAs("store-name").ofType(String.class);
        parser.accepts("update-entries", "Insert or update entries").withRequiredArg().describedAs("input-directory").ofType(String.class);
        parser.accepts("get-metadata", "retreive metadata information " + MetadataStore.METADATA_KEYS).withOptionalArg().describedAs("metadata-key").ofType(String.class);
        parser.accepts("check-metadata", "retreive metadata information from all nodes and checks if they are consistent across [ cluster.xml | stores.xml | server.state ]").withRequiredArg().describedAs("metadata-key").ofType(String.class);
        parser.accepts("ro-metadata", "retrieve version information [current | max | storage-format]").withRequiredArg().describedAs("type").ofType(String.class);
        parser.accepts("truncate", "truncate a store").withRequiredArg().describedAs("store-name").ofType(String.class);
        parser.accepts("set-metadata", "Forceful setting of metadata [ cluster.xml | stores.xml | server.state | rebalancing.steal.info.key ]").withRequiredArg().describedAs("metadata-key").ofType(String.class);
        parser.accepts("set-metadata-value", "The value for the set-metadata [ cluster.xml | stores.xml, rebalancing.steal.info.key ] - xml file location, [ server.state ] - " + (Object)((Object)MetadataStore.VoldemortState.NORMAL_SERVER) + "," + (Object)((Object)MetadataStore.VoldemortState.REBALANCING_MASTER_SERVER)).withRequiredArg().describedAs("metadata-value").ofType(String.class);
        parser.accepts("key-distribution", "Prints the current key distribution of the cluster");
        parser.accepts("clear-rebalancing-metadata", "Remove the metadata related to rebalancing");
        parser.accepts("async", "a) Get a list of async job ids [get] b) Stop async job ids [stop] ").withRequiredArg().describedAs("op-type").ofType(String.class);
        parser.accepts("async-id", "Comma separated list of async ids to stop").withOptionalArg().describedAs("job-ids").withValuesSeparatedBy(',').ofType(Integer.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            VoldemortAdminTool.printHelp(System.out, parser);
            System.exit(0);
        }
        if (!((missing = CmdUtils.missing(options, "url", "node")).size() <= 0 || ((Object)missing).equals(ImmutableSet.of((Object)"node")) && (options.has("add-stores") || options.has("delete-store") || options.has("ro-metadata") || options.has("set-metadata") || options.has("get-metadata") || options.has("check-metadata") || options.has("key-distribution")) || options.has("truncate") || options.has("clear-rebalancing-metadata") || options.has("async"))) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
            VoldemortAdminTool.printHelp(System.err, parser);
            System.exit(1);
        }
        String url = (String)options.valueOf("url");
        Integer nodeId = CmdUtils.valueOf(options, "node", Integer.valueOf(-1));
        int parallelism = CmdUtils.valueOf(options, "restore", Integer.valueOf(5));
        AdminClient adminClient = new AdminClient(url, new AdminClientConfig());
        String ops = "";
        if (options.has("delete-partitions")) {
            ops = ops + "d";
        }
        if (options.has("fetch-keys")) {
            ops = ops + "k";
        }
        if (options.has("fetch-entries")) {
            ops = ops + "v";
        }
        if (options.has("restore")) {
            ops = ops + "r";
        }
        if (options.has("add-stores")) {
            ops = ops + "a";
        }
        if (options.has("update-entries")) {
            ops = ops + "u";
        }
        if (options.has("delete-store")) {
            ops = ops + "s";
        }
        if (options.has("get-metadata")) {
            ops = ops + "g";
        }
        if (options.has("ro-metadata")) {
            ops = ops + "e";
        }
        if (options.has("truncate")) {
            ops = ops + "t";
        }
        if (options.has("set-metadata")) {
            ops = ops + "m";
        }
        if (options.has("check-metadata")) {
            ops = ops + "c";
        }
        if (options.has("key-distribution")) {
            ops = ops + "y";
        }
        if (options.has("clear-rebalancing-metadata")) {
            ops = ops + "i";
        }
        if (options.has("async")) {
            ops = ops + "b";
        }
        if (ops.length() < 1) {
            Utils.croak("At least one of (delete-partitions, restore, add-node, fetch-entries, fetch-keys, add-stores, delete-store, update-entries, get-metadata, ro-metadata, set-metadata, check-metadata, key-distribution, clear-rebalancing-metadata, async) must be specified");
        }
        List storeNames = null;
        if (options.has("stores")) {
            List temp;
            storeNames = temp = options.valuesOf("stores");
        }
        String outputDir = null;
        if (options.has("outdir")) {
            outputDir = (String)options.valueOf("outdir");
        }
        try {
            String metadataKey;
            String storeName;
            List partitionIdList;
            if (ops.contains("d")) {
                System.out.println("Starting delete-partitions");
                List partitionIdList2 = options.valuesOf("delete-partitions");
                VoldemortAdminTool.executeDeletePartitions(nodeId, adminClient, partitionIdList2, storeNames);
                System.out.println("Finished delete-partitions");
            }
            if (ops.contains("r")) {
                if (nodeId == -1) {
                    System.err.println("Cannot run restore without node id");
                    System.exit(1);
                }
                System.out.println("Starting restore");
                adminClient.restoreDataFromReplications(nodeId, parallelism);
                System.out.println("Finished restore");
            }
            if (ops.contains("k")) {
                boolean useAscii = options.has("ascii");
                System.out.println("Starting fetch keys");
                partitionIdList = null;
                if (options.hasArgument("fetch-keys")) {
                    partitionIdList = options.valuesOf("fetch-keys");
                }
                VoldemortAdminTool.executeFetchKeys(nodeId, adminClient, partitionIdList, outputDir, storeNames, useAscii);
            }
            if (ops.contains("v")) {
                boolean useAscii = options.has("ascii");
                System.out.println("Starting fetch entries");
                partitionIdList = null;
                if (options.hasArgument("fetch-entries")) {
                    partitionIdList = options.valuesOf("fetch-entries");
                }
                VoldemortAdminTool.executeFetchEntries(nodeId, adminClient, partitionIdList, outputDir, storeNames, useAscii);
            }
            if (ops.contains("a")) {
                String storesXml = (String)options.valueOf("add-stores");
                VoldemortAdminTool.executeAddStores(adminClient, storesXml, nodeId);
            }
            if (ops.contains("u")) {
                String inputDir = (String)options.valueOf("update-entries");
                VoldemortAdminTool.executeUpdateEntries(nodeId, adminClient, storeNames, inputDir);
            }
            if (ops.contains("s")) {
                storeName = (String)options.valueOf("delete-store");
                VoldemortAdminTool.executeDeleteStore(adminClient, storeName, nodeId);
            }
            if (ops.contains("g")) {
                metadataKey = ALL_METADATA;
                if (options.hasArgument("get-metadata")) {
                    metadataKey = (String)options.valueOf("get-metadata");
                }
                VoldemortAdminTool.executeGetMetadata(nodeId, adminClient, metadataKey, outputDir);
            }
            if (ops.contains("e")) {
                String type = (String)options.valueOf("ro-metadata");
                VoldemortAdminTool.executeROMetadata(nodeId, adminClient, storeNames, type);
            }
            if (ops.contains("t")) {
                storeName = (String)options.valueOf("truncate");
                VoldemortAdminTool.executeTruncateStore(nodeId, adminClient, storeName);
            }
            if (ops.contains("c")) {
                metadataKey = (String)options.valueOf("check-metadata");
                VoldemortAdminTool.executeCheckMetadata(adminClient, metadataKey);
            }
            if (ops.contains("m")) {
                metadataKey = (String)options.valueOf("set-metadata");
                if (!options.has("set-metadata-value")) {
                    throw new VoldemortException("Missing set-metadata-value");
                }
                String metadataValue = (String)options.valueOf("set-metadata-value");
                if (metadataKey.compareTo("cluster.xml") == 0) {
                    if (!Utils.isReadableFile(metadataValue)) {
                        throw new VoldemortException("Cluster xml file path incorrect");
                    }
                    ClusterMapper mapper = new ClusterMapper();
                    Cluster newCluster = mapper.readCluster(new File(metadataValue));
                    VoldemortAdminTool.executeSetMetadata(nodeId, adminClient, "cluster.xml", mapper.writeCluster(newCluster));
                } else if (metadataKey.compareTo("server.state") == 0) {
                    MetadataStore.VoldemortState newState = MetadataStore.VoldemortState.valueOf(metadataValue);
                    VoldemortAdminTool.executeSetMetadata(nodeId, adminClient, "server.state", newState.toString());
                } else if (metadataKey.compareTo("stores.xml") == 0) {
                    if (!Utils.isReadableFile(metadataValue)) {
                        throw new VoldemortException("Stores definition xml file path incorrect");
                    }
                    StoreDefinitionsMapper mapper = new StoreDefinitionsMapper();
                    List<StoreDefinition> storeDefs = mapper.readStoreList(new File(metadataValue));
                    VoldemortAdminTool.executeSetMetadata(nodeId, adminClient, "stores.xml", mapper.writeStoreList(storeDefs));
                } else if (metadataKey.compareTo("rebalancing.steal.info.key") == 0) {
                    if (!Utils.isReadableFile(metadataValue)) {
                        throw new VoldemortException("Rebalancing steal info file path incorrect");
                    }
                    String rebalancingStealInfoJsonString = FileUtils.readFileToString((File)new File(metadataValue));
                    RebalancerState state = RebalancerState.create(rebalancingStealInfoJsonString);
                    VoldemortAdminTool.executeSetMetadata(nodeId, adminClient, "rebalancing.steal.info.key", state.toJsonString());
                } else {
                    throw new VoldemortException("Incorrect metadata key");
                }
            }
            if (ops.contains("y")) {
                VoldemortAdminTool.executeKeyDistribution(adminClient);
            }
            if (ops.contains("i")) {
                VoldemortAdminTool.executeClearRebalancing(nodeId, adminClient);
            }
            if (ops.contains("b")) {
                String asyncKey = (String)options.valueOf("async");
                List asyncIds = null;
                if (options.hasArgument("async-id")) {
                    asyncIds = options.valuesOf("async-id");
                }
                VoldemortAdminTool.executeAsync(nodeId, adminClient, asyncKey, asyncIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Utils.croak(e.getMessage());
        }
    }

    public static void printHelp(PrintStream stream, OptionParser parser) throws IOException {
        stream.println("Commands supported");
        stream.println("------------------");
        stream.println("CHANGE METADATA");
        stream.println("\t1) Get all metadata from all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --get-metadata --url [url]");
        stream.println("\t2) Get metadata from all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --get-metadata " + MetadataStore.METADATA_KEYS + " --url [url]");
        stream.println("\t3) Get metadata from a particular node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --get-metadata " + MetadataStore.METADATA_KEYS + " --url [url] --node [node-id]");
        stream.println("\t4) Get metadata from a particular node and store to a directory");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --get-metadata " + MetadataStore.METADATA_KEYS + " --url [url] --node [node-id] --outdir [directory]");
        stream.println("\t5) Set metadata on all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --set-metadata [cluster.xml, server.state, stores.xml, rebalancing.steal.info.key] --set-metadata-value [metadata-value] --url [url]");
        stream.println("\t6) Set metadata for a particular node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --set-metadata [cluster.xml, server.state, stores.xml, rebalancing.steal.info.key] --set-metadata-value [metadata-value] --url [url] --node [node-id]");
        stream.println("\t7) Check if metadata is same on all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --check-metadata [cluster.xml, server.state, stores.xml] --url [url]");
        stream.println("\t8) Clear rebalancing metadata [server.state, rebalancing.steal.info.key] on all node ");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --clear-rebalancing-metadata --url [url]");
        stream.println("\t9) Clear rebalancing metadata [server.state, rebalancing.steal.info.key] on a particular node ");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --clear-rebalancing-metadata --url [url] --node [node-id]");
        stream.println();
        stream.println("ADD / DELETE STORES");
        stream.println("\t1) Add store(s) on all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --add-stores [xml file with store(s) to add] --url [url]");
        stream.println("\t2) Add store(s) on a single node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --add-stores [xml file with store(s) to add] --url [url] --node [node-id]");
        stream.println("\t3) Delete store on all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --delete-store [store-name] --url [url]");
        stream.println("\t4) Delete store on a single node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --delete-store [store-name] --url [url] --node [node-id]");
        stream.println("\t5) Delete the contents of the store on all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --truncate [store-name] --url [url]");
        stream.println("\t6) Delete the contents of the store on a single node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --truncate [store-name] --url [url] --node [node-id]");
        stream.println("\t7) Delete the contents of some partitions on a single node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --delete-partitions [comma-separated list of partitions] --url [url] --node [node-id]");
        stream.println("\t8) Delete the contents of some partitions ( of some stores ) on a single node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --delete-partitions [comma-separated list of partitions] --url [url] --node [node-id] --stores [comma-separated list of store names]");
        stream.println();
        stream.println("STREAM DATA");
        stream.println("\t1) Fetch keys from a set of partitions [ all stores ] on a node ( binary dump )");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-keys [comma-separated list of partitions with no space] --url [url] --node [node-id]");
        stream.println("\t2) Fetch keys from a set of partitions [ all stores ] on a node ( ascii enabled )");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-keys [comma-separated list of partitions with no space] --url [url] --node [node-id] --ascii");
        stream.println("\t3) Fetch entries from a set of partitions [ all stores ] on a node ( binary dump )");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-entries [comma-separated list of partitions with no space] --url [url] --node [node-id]");
        stream.println("\t4) Fetch entries from a set of partitions [ all stores ] on a node ( ascii enabled )");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-entries [comma-separated list of partitions with no space] --url [url] --node [node-id] --ascii");
        stream.println("\t5) Fetch entries from a set of partitions [ all stores ] on a node ( ascii enabled ) and output to a folder");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-entries [comma-separated list of partitions with no space] --url [url] --node [node-id] --ascii --outdir [directory]");
        stream.println("\t6) Fetch entries from a set of partitions and some stores on a node ( ascii enabled )");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-entries [comma-separated list of partitions with no space] --url [url] --node [node-id] --ascii --stores [comma-separated list of store names] ");
        stream.println("\t7) Fetch all keys on a particular node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-keys --url [url] --node [node-id]");
        stream.println("\t8) Fetch all entries on a particular node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --fetch-entries --url [url] --node [node-id]");
        stream.println("\t9) Update entries for a set of stores using the output from a binary dump fetch entries");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --update-entries [folder path from output of --fetch-entries --outdir] --url [url] --node [node-id] --stores [comma-separated list of store names]");
        stream.println();
        stream.println("READ-ONLY OPERATIONS");
        stream.println("\t1) Retrieve metadata information of read-only data for a particular node and all stores");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --ro-metadata [current | max | storage-format] --url [url] --node [node-id]");
        stream.println("\t2) Retrieve metadata information of read-only data for all nodes and a set of store");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --ro-metadata [current | max | storage-format] --url [url] --stores [comma-separated list of store names]");
        stream.println();
        stream.println("ASYNC JOBS");
        stream.println("\t1) Get a list of async jobs on all nodes");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --async get --url [url]");
        stream.println("\t2) Get a list of async jobs on a particular node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --async get --url [url] --node [node-id]");
        stream.println("\t3) Stop a list of async jobs on a particular node");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --async stop --async-id [comma-separated list of async job id] --url [url] --node [node-id]");
        stream.println();
        stream.println("OTHERS");
        stream.println("\t1) Restore a particular node completely from its replicas");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --restore --url [url] --node [node-id]");
        stream.println("\t2) Restore a particular node completely from its replicas ( with increased parallelism - 10 ) ");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --restore 10 --url [url] --node [node-id]");
        stream.println("\t3) Generates the key distribution on a per node basis [ both store wise and overall ]");
        stream.println("\t\t./bin/voldemort-admin-tool.sh --key-distribution --url [url]");
        parser.printHelpOn((OutputStream)stream);
    }

    private static void executeAsync(Integer nodeId, AdminClient adminClient, String asyncKey, List<Integer> asyncIdsToStop) {
        if (asyncKey.compareTo("get") == 0) {
            ArrayList nodeIds = Lists.newArrayList();
            if (nodeId < 0) {
                for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                    nodeIds.add(node.getId());
                }
            } else {
                nodeIds.add(nodeId);
            }
            Iterator<Node> i$ = nodeIds.iterator();
            while (i$.hasNext()) {
                int currentNodeId = (Integer)((Object)i$.next());
                System.out.println("Retrieving async jobs from node " + currentNodeId);
                List<Integer> asyncIds = adminClient.getAsyncRequestList(currentNodeId);
                System.out.println("Async Job Ids on node " + currentNodeId + " : " + asyncIds);
                for (int asyncId : asyncIds) {
                    System.out.println("Async Job Id " + asyncId + " ] " + adminClient.getAsyncRequestStatus(currentNodeId, asyncId));
                    System.out.println();
                }
            }
        } else if (asyncKey.compareTo("stop") == 0) {
            if (nodeId < 0) {
                throw new VoldemortException("Cannot stop job ids without node id");
            }
            if (asyncIdsToStop == null || asyncIdsToStop.size() == 0) {
                throw new VoldemortException("Async ids cannot be null / zero");
            }
            for (int asyncId : asyncIdsToStop) {
                System.out.println("Stopping async id " + asyncId);
                adminClient.stopAsyncRequest(nodeId, asyncId);
                System.out.println("Stopped async id " + asyncId);
            }
        } else {
            throw new VoldemortException("Unsupported async operation type " + asyncKey);
        }
    }

    private static void executeClearRebalancing(int nodeId, AdminClient adminClient) {
        System.out.println("Setting server.state to " + (Object)((Object)MetadataStore.VoldemortState.NORMAL_SERVER));
        VoldemortAdminTool.executeSetMetadata(nodeId, adminClient, "server.state", MetadataStore.VoldemortState.NORMAL_SERVER.toString());
        RebalancerState state = RebalancerState.create("[]");
        System.out.println("Cleaning up rebalancing.steal.info.key to " + state.toJsonString());
        VoldemortAdminTool.executeSetMetadata(nodeId, adminClient, "rebalancing.steal.info.key", state.toJsonString());
    }

    private static void executeKeyDistribution(AdminClient adminClient) {
        List<ByteArray> keys = KeyDistributionGenerator.generateKeys(10000);
        System.out.println(KeyDistributionGenerator.printStoreWiseDistribution(adminClient.getAdminClientCluster(), adminClient.getRemoteStoreDefList(0).getValue(), keys));
        System.out.println(KeyDistributionGenerator.printOverallDistribution(adminClient.getAdminClientCluster(), adminClient.getRemoteStoreDefList(0).getValue(), keys));
    }

    private static void executeCheckMetadata(AdminClient adminClient, String metadataKey) {
        HashSet metadataValues = Sets.newHashSet();
        for (Node node : adminClient.getAdminClientCluster().getNodes()) {
            System.out.println(node.getHost() + ":" + node.getId());
            Versioned<String> versioned = adminClient.getRemoteMetadata(node.getId(), metadataKey);
            if (versioned == null || versioned.getValue() == null) {
                throw new VoldemortException("Value returned from node " + node.getId() + " was null");
            }
            if (metadataKey.compareTo("cluster.xml") == 0) {
                metadataValues.add(new ClusterMapper().readCluster(new StringReader(versioned.getValue())));
                continue;
            }
            if (metadataKey.compareTo("stores.xml") == 0) {
                metadataValues.add(new StoreDefinitionsMapper().readStoreList(new StringReader(versioned.getValue())));
                continue;
            }
            if (metadataKey.compareTo("server.state") == 0) {
                metadataValues.add(MetadataStore.VoldemortState.valueOf(versioned.getValue()));
                continue;
            }
            throw new VoldemortException("Incorrect metadata key");
        }
        if (metadataValues.size() == 1) {
            System.out.println("true");
        } else {
            System.out.println("false");
        }
    }

    private static void executeSetMetadata(Integer nodeId, AdminClient adminClient, String key, Object value) {
        ArrayList nodeIds = Lists.newArrayList();
        VectorClock updatedVersion = null;
        if (nodeId < 0) {
            for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                nodeIds.add(node.getId());
                if (updatedVersion == null) {
                    updatedVersion = (VectorClock)adminClient.getRemoteMetadata(node.getId(), key).getVersion();
                    continue;
                }
                updatedVersion = updatedVersion.merge((VectorClock)adminClient.getRemoteMetadata(node.getId(), key).getVersion());
            }
            updatedVersion = updatedVersion.incremented(0, System.currentTimeMillis());
        } else {
            Versioned<String> currentValue = adminClient.getRemoteMetadata(nodeId, key);
            updatedVersion = ((VectorClock)currentValue.getVersion()).incremented(nodeId, System.currentTimeMillis());
            nodeIds.add(nodeId);
        }
        for (Integer currentNodeId : nodeIds) {
            System.out.println("Setting " + key + " for " + adminClient.getAdminClientCluster().getNodeById(currentNodeId).getHost() + ":" + adminClient.getAdminClientCluster().getNodeById(currentNodeId).getId());
            adminClient.updateRemoteMetadata(currentNodeId, key, Versioned.value(value.toString(), updatedVersion));
        }
    }

    private static void executeROMetadata(Integer nodeId, AdminClient adminClient, List<String> storeNames, String type) {
        Map<Object, Object> storeToValue = Maps.newHashMap();
        if (storeNames == null) {
            storeNames = Lists.newArrayList();
            for (StoreDefinition storeDef : adminClient.getRemoteStoreDefList(nodeId > 0 ? nodeId : 0).getValue()) {
                if (storeDef.getType().compareTo("read-only") != 0) continue;
                storeNames.add(storeDef.getName());
            }
        }
        ArrayList nodeIds = Lists.newArrayList();
        if (nodeId < 0) {
            for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                nodeIds.add(node.getId());
            }
        } else {
            nodeIds.add(nodeId);
        }
        Iterator<Node> i$ = nodeIds.iterator();
        while (i$.hasNext()) {
            int currentNodeId = (Integer)((Object)i$.next());
            System.out.println(adminClient.getAdminClientCluster().getNodeById(currentNodeId).getHost() + ":" + adminClient.getAdminClientCluster().getNodeById(currentNodeId).getId());
            if (type.compareTo("max") == 0) {
                storeToValue = adminClient.getROMaxVersion(currentNodeId, storeNames);
            } else if (type.compareTo("current") == 0) {
                storeToValue = adminClient.getROCurrentVersion(currentNodeId, storeNames);
            } else {
                if (type.compareTo("storage-format") == 0) {
                    Map<String, String> storeToStorageFormat = adminClient.getROStorageFormat(currentNodeId, storeNames);
                    for (String storeName : storeToStorageFormat.keySet()) {
                        System.out.println(storeName + ":" + storeToStorageFormat.get(storeName));
                    }
                    continue;
                }
                System.err.println("Unsupported operation, only max, current or storage-format allowed");
                return;
            }
            for (String string : storeToValue.keySet()) {
                System.out.println(string + ":" + storeToValue.get(string));
            }
        }
    }

    private static void executeGetMetadata(Integer nodeId, AdminClient adminClient, String metadataKey, String outputDir) throws IOException {
        File directory = null;
        if (outputDir != null && !(directory = new File(outputDir)).exists() && !directory.mkdir()) {
            Utils.croak("Can't find or create directory " + outputDir);
        }
        ArrayList nodeIds = Lists.newArrayList();
        if (nodeId < 0) {
            for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                nodeIds.add(node.getId());
            }
        } else {
            nodeIds.add(nodeId);
        }
        ArrayList metadataKeys = Lists.newArrayList();
        if (metadataKey.compareTo(ALL_METADATA) == 0) {
            for (Object key : MetadataStore.METADATA_KEYS) {
                metadataKeys.add((String)key);
            }
        } else {
            metadataKeys.add(metadataKey);
        }
        for (Integer currentNodeId : nodeIds) {
            System.out.println(adminClient.getAdminClientCluster().getNodeById(currentNodeId).getHost() + ":" + adminClient.getAdminClientCluster().getNodeById(currentNodeId).getId());
            for (String key : metadataKeys) {
                System.out.println("Key - " + key);
                Versioned<String> versioned = null;
                try {
                    versioned = adminClient.getRemoteMetadata(currentNodeId, key);
                }
                catch (Exception e) {
                    System.out.println("Error in retrieving " + e.getMessage());
                    System.out.println();
                    continue;
                }
                if (versioned == null) {
                    if (directory == null) {
                        System.out.println("null");
                        System.out.println();
                        continue;
                    }
                    FileUtils.writeStringToFile((File)new File(directory, key + "_" + currentNodeId), (String)"");
                    continue;
                }
                if (directory == null) {
                    System.out.println(versioned.getVersion());
                    System.out.print(": ");
                    System.out.println(versioned.getValue());
                    System.out.println();
                    continue;
                }
                FileUtils.writeStringToFile((File)new File(directory, key + "_" + currentNodeId), (String)versioned.getValue());
            }
        }
    }

    private static void executeDeleteStore(AdminClient adminClient, String storeName, int nodeId) {
        System.out.println("Deleting " + storeName);
        if (nodeId == -1) {
            adminClient.deleteStore(storeName);
        } else {
            adminClient.deleteStore(storeName, nodeId);
        }
    }

    private static void executeTruncateStore(int nodeId, AdminClient adminClient, String storeName) {
        ArrayList nodeIds = Lists.newArrayList();
        if (nodeId < 0) {
            for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                nodeIds.add(node.getId());
            }
        } else {
            nodeIds.add(nodeId);
        }
        for (Integer currentNodeId : nodeIds) {
            System.out.println("Truncating " + storeName + " on node " + currentNodeId);
            adminClient.truncate(currentNodeId, storeName);
        }
    }

    private static void executeAddStores(AdminClient adminClient, String storesXml, int nodeId) throws IOException {
        List<StoreDefinition> storeDefinitionList = new StoreDefinitionsMapper().readStoreList(new File(storesXml));
        for (StoreDefinition storeDef : storeDefinitionList) {
            System.out.println("Adding " + storeDef.getName());
            if (-1 != nodeId) {
                adminClient.addStore(storeDef, nodeId);
                continue;
            }
            adminClient.addStore(storeDef);
        }
    }

    private static void executeFetchEntries(Integer nodeId, AdminClient adminClient, List<Integer> partitionIdList, String outputDir, List<String> storeNames, boolean useAscii) throws IOException {
        ArrayList stores;
        List<StoreDefinition> storeDefinitionList = adminClient.getRemoteStoreDefList(nodeId).getValue();
        HashMap storeDefinitionMap = Maps.newHashMap();
        for (StoreDefinition storeDefinition : storeDefinitionList) {
            storeDefinitionMap.put(storeDefinition.getName(), storeDefinition);
        }
        File directory = null;
        if (outputDir != null && !(directory = new File(outputDir)).exists() && !directory.mkdir()) {
            Utils.croak("Can't find or create directory " + outputDir);
        }
        if ((stores = storeNames) == null) {
            stores = Lists.newArrayList();
            stores.addAll(storeDefinitionMap.keySet());
        }
        if (partitionIdList == null) {
            partitionIdList = Lists.newArrayList();
            for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                partitionIdList.addAll(node.getPartitionIds());
            }
        }
        StoreDefinition storeDefinition = null;
        for (String store : stores) {
            storeDefinition = (StoreDefinition)storeDefinitionMap.get(store);
            if (null == storeDefinition) {
                System.out.println("No store found under the name '" + store + "'");
                continue;
            }
            System.out.println("Fetching entries in partitions " + Joiner.on((String)", ").join((Iterable)partitionIdList) + " of " + store);
            Iterator<Pair<ByteArray, Versioned<byte[]>>> entriesIterator = adminClient.fetchEntries(nodeId, store, partitionIdList, null, false);
            File outputFile = null;
            if (directory != null) {
                outputFile = new File(directory, store + ".entries");
            }
            if (useAscii) {
                VoldemortAdminTool.writeEntriesAscii(entriesIterator, outputFile, storeDefinition);
            } else {
                VoldemortAdminTool.writeEntriesBinary(entriesIterator, outputFile);
            }
            if (outputFile == null) continue;
            System.out.println("Fetched keys from " + store + " to " + outputFile);
        }
    }

    private static void executeUpdateEntries(Integer nodeId, AdminClient adminClient, List<String> storeNames, String inputDirPath) throws IOException {
        List<StoreDefinition> storeDefinitionList = adminClient.getRemoteStoreDefList(nodeId).getValue();
        HashMap storeDefinitionMap = Maps.newHashMap();
        for (StoreDefinition storeDefinition : storeDefinitionList) {
            storeDefinitionMap.put(storeDefinition.getName(), storeDefinition);
        }
        File inputDir = new File(inputDirPath);
        if (!inputDir.exists()) {
            throw new FileNotFoundException("input directory " + inputDirPath + " doesn't exist");
        }
        if (storeNames == null) {
            storeNames = Lists.newArrayList();
            for (File storeFile : inputDir.listFiles()) {
                String fileName = storeFile.getName();
                if (!fileName.endsWith(".entries")) continue;
                int extPosition = fileName.lastIndexOf(".entries");
                storeNames.add(fileName.substring(0, extPosition));
            }
        }
        for (String storeName : storeNames) {
            Iterator<Pair<ByteArray, Versioned<byte[]>>> iterator = VoldemortAdminTool.readEntriesBinary(inputDir, storeName);
            adminClient.updateEntries(nodeId, storeName, iterator, null);
        }
    }

    private static Iterator<Pair<ByteArray, Versioned<byte[]>>> readEntriesBinary(File inputDir, String storeName) throws IOException {
        File inputFile = new File(inputDir, storeName + ".entries");
        if (!inputFile.exists()) {
            throw new FileNotFoundException("File " + inputFile.getAbsolutePath() + " does not exist!");
        }
        final DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
        return new AbstractIterator<Pair<ByteArray, Versioned<byte[]>>>(){

            protected Pair<ByteArray, Versioned<byte[]>> computeNext() {
                try {
                    int length = dis.readInt();
                    byte[] keyBytes = new byte[length];
                    ByteUtils.read(dis, keyBytes);
                    length = dis.readInt();
                    byte[] versionBytes = new byte[length];
                    ByteUtils.read(dis, versionBytes);
                    length = dis.readInt();
                    byte[] valueBytes = new byte[length];
                    ByteUtils.read(dis, valueBytes);
                    ByteArray key = new ByteArray(keyBytes);
                    VectorClock version = new VectorClock(versionBytes);
                    Versioned<byte[]> value = new Versioned<byte[]>(valueBytes, version);
                    return new Pair<ByteArray, Versioned<byte[]>>(key, value);
                }
                catch (EOFException e) {
                    try {
                        dis.close();
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                    return (Pair)this.endOfData();
                }
                catch (IOException e) {
                    try {
                        dis.close();
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                    throw new VoldemortException("Error reading from input file ", e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEntriesAscii(Iterator<Pair<ByteArray, Versioned<byte[]>>> iterator, File outputFile, StoreDefinition storeDefinition) throws IOException {
        SerializerDefinition valueSerializerDef;
        BufferedWriter writer = null;
        CompressionStrategy keyCompressionStrategy = null;
        CompressionStrategy valueCompressionStrategy = null;
        writer = outputFile != null ? new BufferedWriter(new FileWriter(outputFile)) : new BufferedWriter(new OutputStreamWriter(System.out));
        DefaultSerializerFactory serializerFactory = new DefaultSerializerFactory();
        StringWriter stringWriter = new StringWriter();
        JsonGenerator generator = new JsonFactory((ObjectCodec)new ObjectMapper()).createJsonGenerator((Writer)stringWriter);
        SerializerDefinition keySerializerDef = storeDefinition.getKeySerializer();
        if (null != keySerializerDef && keySerializerDef.hasCompression()) {
            keyCompressionStrategy = new CompressionStrategyFactory().get(keySerializerDef.getCompression());
        }
        if (null != (valueSerializerDef = storeDefinition.getValueSerializer()) && valueSerializerDef.hasCompression()) {
            valueCompressionStrategy = new CompressionStrategyFactory().get(valueSerializerDef.getCompression());
        }
        Serializer<?> keySerializer = serializerFactory.getSerializer(storeDefinition.getKeySerializer());
        Serializer<?> valueSerializer = serializerFactory.getSerializer(storeDefinition.getValueSerializer());
        try {
            while (iterator.hasNext()) {
                Pair<ByteArray, Versioned<byte[]>> kvPair = iterator.next();
                byte[] keyBytes = kvPair.getFirst().get();
                VectorClock version = (VectorClock)kvPair.getSecond().getVersion();
                byte[] valueBytes = kvPair.getSecond().getValue();
                Object keyObject = keySerializer.toObject(null == keyCompressionStrategy ? keyBytes : keyCompressionStrategy.inflate(keyBytes));
                Object valueObject = valueSerializer.toObject(null == valueCompressionStrategy ? valueBytes : valueCompressionStrategy.inflate(valueBytes));
                generator.writeObject(keyObject);
                stringWriter.write(32);
                stringWriter.write(version.toString());
                generator.writeObject(valueObject);
                StringBuffer buf = stringWriter.getBuffer();
                if (buf.charAt(0) == ' ') {
                    buf.setCharAt(0, '\n');
                }
                writer.write(buf.toString());
                buf.setLength(0);
            }
            writer.write(10);
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEntriesBinary(Iterator<Pair<ByteArray, Versioned<byte[]>>> iterator, File outputFile) throws IOException {
        DataOutputStream dos = null;
        dos = outputFile != null ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile))) : new DataOutputStream(new BufferedOutputStream(System.out));
        try {
            while (iterator.hasNext()) {
                Pair<ByteArray, Versioned<byte[]>> kvPair = iterator.next();
                byte[] keyBytes = kvPair.getFirst().get();
                byte[] versionBytes = ((VectorClock)kvPair.getSecond().getVersion()).toBytes();
                byte[] valueBytes = kvPair.getSecond().getValue();
                dos.writeInt(keyBytes.length);
                dos.write(keyBytes);
                dos.writeInt(versionBytes.length);
                dos.write(versionBytes);
                dos.writeInt(valueBytes.length);
                dos.write(valueBytes);
            }
        }
        finally {
            dos.close();
        }
    }

    private static void executeFetchKeys(Integer nodeId, AdminClient adminClient, List<Integer> partitionIdList, String outputDir, List<String> storeNames, boolean useAscii) throws IOException {
        ArrayList stores;
        List<StoreDefinition> storeDefinitionList = adminClient.getRemoteStoreDefList(nodeId).getValue();
        HashMap storeDefinitionMap = Maps.newHashMap();
        for (StoreDefinition storeDefinition : storeDefinitionList) {
            storeDefinitionMap.put(storeDefinition.getName(), storeDefinition);
        }
        File directory = null;
        if (outputDir != null && !(directory = new File(outputDir)).exists() && !directory.mkdir()) {
            Utils.croak("Can't find or create directory " + outputDir);
        }
        if ((stores = storeNames) == null) {
            stores = Lists.newArrayList();
            stores.addAll(storeDefinitionMap.keySet());
        }
        if (partitionIdList == null) {
            partitionIdList = Lists.newArrayList();
            for (Node node : adminClient.getAdminClientCluster().getNodes()) {
                partitionIdList.addAll(node.getPartitionIds());
            }
        }
        StoreDefinition storeDefinition = null;
        for (String store : stores) {
            storeDefinition = (StoreDefinition)storeDefinitionMap.get(store);
            if (null == storeDefinition) {
                System.out.println("No store found under the name '" + store + "'");
                continue;
            }
            System.out.println("Fetching keys in partitions " + Joiner.on((String)", ").join((Iterable)partitionIdList) + " of " + store);
            Iterator<ByteArray> keyIterator = adminClient.fetchKeys(nodeId, store, partitionIdList, null, false);
            File outputFile = null;
            if (directory != null) {
                outputFile = new File(directory, store + ".keys");
            }
            if (useAscii) {
                VoldemortAdminTool.writeKeysAscii(keyIterator, outputFile, storeDefinition);
            } else {
                VoldemortAdminTool.writeKeysBinary(keyIterator, outputFile);
            }
            if (outputFile == null) continue;
            System.out.println("Fetched keys from " + store + " to " + outputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeysAscii(Iterator<ByteArray> keyIterator, File outputFile, StoreDefinition storeDefinition) throws IOException {
        BufferedWriter writer = null;
        CompressionStrategy keysCompressionStrategy = null;
        FileWriter fileWriter = null;
        if (outputFile != null) {
            fileWriter = new FileWriter(outputFile);
            writer = new BufferedWriter(fileWriter);
        } else {
            writer = new BufferedWriter(new OutputStreamWriter(System.out));
        }
        SerializerDefinition serializerDef = storeDefinition.getKeySerializer();
        if (null != serializerDef && serializerDef.hasCompression()) {
            keysCompressionStrategy = new CompressionStrategyFactory().get(serializerDef.getCompression());
        }
        DefaultSerializerFactory serializerFactory = new DefaultSerializerFactory();
        StringWriter stringWriter = new StringWriter();
        JsonGenerator generator = new JsonFactory((ObjectCodec)new ObjectMapper()).createJsonGenerator((Writer)stringWriter);
        Serializer<?> serializer = serializerFactory.getSerializer(storeDefinition.getKeySerializer());
        try {
            while (keyIterator.hasNext()) {
                byte[] keyBytes = keyIterator.next().get();
                Object keyObject = serializer.toObject(null == keysCompressionStrategy ? keyBytes : keysCompressionStrategy.inflate(keyBytes));
                generator.writeObject(keyObject);
                StringBuffer buf = stringWriter.getBuffer();
                if (buf.charAt(0) == ' ') {
                    buf.setCharAt(0, '\n');
                }
                writer.write(buf.toString());
                buf.setLength(0);
            }
            writer.write(10);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeysBinary(Iterator<ByteArray> keyIterator, File outputFile) throws IOException {
        DataOutputStream dos = null;
        FileOutputStream outputStream = null;
        if (outputFile != null) {
            outputStream = new FileOutputStream(outputFile);
            dos = new DataOutputStream(new BufferedOutputStream(outputStream));
        } else {
            dos = new DataOutputStream(new BufferedOutputStream(System.out));
        }
        try {
            while (keyIterator.hasNext()) {
                byte[] keyBytes = keyIterator.next().get();
                dos.writeInt(keyBytes.length);
                dos.write(keyBytes);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            dos.close();
        }
    }

    private static void executeDeletePartitions(Integer nodeId, AdminClient adminClient, List<Integer> partitionIdList, List<String> storeNames) {
        ArrayList stores = storeNames;
        if (stores == null) {
            stores = Lists.newArrayList();
            List<StoreDefinition> storeDefinitionList = adminClient.getRemoteStoreDefList(nodeId).getValue();
            for (StoreDefinition storeDefinition : storeDefinitionList) {
                stores.add(storeDefinition.getName());
            }
        }
        for (String store : stores) {
            System.out.println("Deleting partitions " + Joiner.on((String)", ").join(partitionIdList) + " of " + store);
            adminClient.deletePartitions(nodeId, store, partitionIdList, null);
        }
    }
}

