/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.twitter4j.DefaultTwitter4jProvider;
import griffon.plugins.twitter4j.Twitter4jAware;
import griffon.plugins.twitter4j.Twitter4jContributionHandler;
import griffon.plugins.twitter4j.Twitter4jProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.Twitter4jAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class Twitter4jAwareASTTransformation
extends AbstractASTTransformation
implements Twitter4jAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(Twitter4jAwareASTTransformation.class);
    private static final ClassNode TWITTER4j_CONTRIBUTION_HANDLER_CNODE = Twitter4jAwareASTTransformation.makeClassSafe(Twitter4jContributionHandler.class);
    private static final ClassNode TWITTER4j_AWARE_CNODE = Twitter4jAwareASTTransformation.makeClassSafe(Twitter4jAware.class);
    private static final ClassNode TWITTER4j_PROVIDER_CNODE = Twitter4jAwareASTTransformation.makeClassSafe(Twitter4jProvider.class);
    private static final ClassNode DEFAULT_TWITTER4j_PROVIDER_CNODE = Twitter4jAwareASTTransformation.makeClassSafe(DefaultTwitter4jProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withTwitter"};

    public static boolean hasTwitter4jAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!TWITTER4j_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        Twitter4jAwareASTTransformation.addTwitter4jContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addTwitter4jContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (Twitter4jAwareASTTransformation.needsTwitter4jContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + Twitter4jContributionHandler.class.getName() + " into " + classNode.getName());
            }
            Twitter4jAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsTwitter4jContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withTwitter") && method.getParameters().length == 2;
                found2 = method.getName().equals("setTwitter4jProvider") && method.getParameters().length == 1;
                boolean bl = found3 = method.getName().equals("getTwitter4jProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3) continue;
                return false;
            }
        }
        if (found1 || found2 || found3) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@Twitter4jAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + Twitter4jContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)TWITTER4j_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$twitter4jProvider", 4098, TWITTER4j_PROVIDER_CNODE, Twitter4jAwareASTTransformation.defaultTwitter4jProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getTwitter4jProvider", 1, TWITTER4j_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setTwitter4jProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)TWITTER4j_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)Twitter4jAwareASTTransformation.defaultTwitter4jProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : TWITTER4j_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(Twitter4jAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = Twitter4jAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultTwitter4jProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_TWITTER4j_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

