/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import griffon.plugins.twitter4j.Twitter4jAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.Twitter4jAwareConstants;
import lombok.core.handlers.Twitter4jAwareHandler;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.ast.JavacType;

import static lombok.core.util.ErrorMessages.canBeUsedOnClassAndEnumOnly;
import static lombok.javac.handlers.JavacHandlerUtil.deleteAnnotationIfNeccessary;

/**
 * @author Andres Almiray
 */
public class HandleTwitter4jAware extends JavacAnnotationHandler<Twitter4jAware> {
    private final JavacTwitter4jAwareHandler handler = new JavacTwitter4jAwareHandler();

    @Override
    public void handle(final AnnotationValues<Twitter4jAware> annotation, final JCTree.JCAnnotation source, final JavacNode annotationNode) {
        deleteAnnotationIfNeccessary(annotationNode, Twitter4jAware.class);

        JavacType type = JavacType.typeOf(annotationNode, source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(canBeUsedOnClassAndEnumOnly(Twitter4jAware.class));
            return;
        }

        JavacUtil.addInterface(type.node(), Twitter4jAwareConstants.TWITTER4j_CONTRIBUTION_HANDLER_TYPE);
        handler.addTwitter4jProviderField(type);
        handler.addTwitter4jProviderAccessors(type);
        handler.addTwitter4jContributionMethods(type);
        type.editor().rebuild();
    }

    private static class JavacTwitter4jAwareHandler extends Twitter4jAwareHandler<JavacType> {
    }
}
