/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.window.translucentandshaped;

import ch.swingfx.window.translucentandshaped.ApiType;
import ch.swingfx.window.translucentandshaped.ITranslucentAndShapedWindowApi;
import ch.swingfx.window.translucentandshaped.Translucency;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Method;

public class PrivateApi
implements ITranslucentAndShapedWindowApi {
    private static boolean isSupported = false;
    private static Object PERPIXEL_TRANSPARENT;
    private static Object TRANSLUCENT;
    private static Object PERPIXEL_TRANSLUCENT;
    private static Method isTranslucencySupported;
    private static Method setWindowOpacity;
    private static Method getWindowOpacity;
    private static Method setWindowShape;
    private static Method getWindowShape;
    private static Method setWindowOpaque;
    private static Method isWindowOpaque;
    private static Method isTranslucencyCapable;

    public static boolean isSupported() {
        return isSupported;
    }

    public boolean isTranslucencySupported(Translucency translucencyKind, GraphicsDevice gd) {
        Object kind = null;
        switch (translucencyKind) {
            case PERPIXEL_TRANSLUCENT: {
                kind = PERPIXEL_TRANSLUCENT;
                break;
            }
            case TRANSLUCENT: {
                kind = TRANSLUCENT;
                break;
            }
            case PERPIXEL_TRANSPARENT: {
                kind = PERPIXEL_TRANSPARENT;
            }
        }
        try {
            return (Boolean)isTranslucencySupported.invoke(null, kind);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setWindowOpacity(Window window, float opacity) {
        try {
            setWindowOpacity.invoke(null, window, Float.valueOf(opacity));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float getWindowOpacity(Window window) {
        try {
            return ((Float)getWindowOpacity.invoke(null, window)).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    public void setWindowShape(Window window, Shape shape) {
        try {
            setWindowShape.invoke(null, window, shape);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Shape getWindowShape(Window window) {
        try {
            return (Shape)getWindowShape.invoke(null, window);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setWindowOpaque(Window window, boolean isOpaque) {
        try {
            if (!this.isTranslucencyCapable(window.getGraphicsConfiguration()) || !this.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT, window.getGraphicsConfiguration().getDevice())) {
                return;
            }
            setWindowOpaque.invoke(null, window, isOpaque);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isWindowOpaque(Window window) {
        try {
            return (Boolean)isWindowOpaque.invoke(null, window);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public boolean isTranslucencyCapable(GraphicsConfiguration gc) {
        try {
            return (Boolean)isTranslucencyCapable.invoke(null, gc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ApiType getApiType() {
        return ApiType.PRIVATE;
    }

    static {
        try {
            Class<?> awtUtilitiesClass = Class.forName("com.sun.awt.AWTUtilities");
            Class<?> translucencyClass = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Method valueOf = translucencyClass.getMethod("valueOf", String.class);
            PERPIXEL_TRANSPARENT = valueOf.invoke(translucencyClass, "PERPIXEL_TRANSPARENT");
            TRANSLUCENT = valueOf.invoke(translucencyClass, "TRANSLUCENT");
            PERPIXEL_TRANSLUCENT = valueOf.invoke(translucencyClass, "PERPIXEL_TRANSLUCENT");
            isTranslucencySupported = awtUtilitiesClass.getMethod("isTranslucencySupported", translucencyClass);
            setWindowOpacity = awtUtilitiesClass.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            getWindowOpacity = awtUtilitiesClass.getMethod("getWindowOpacity", Window.class);
            setWindowShape = awtUtilitiesClass.getMethod("setWindowShape", Window.class, Shape.class);
            getWindowShape = awtUtilitiesClass.getMethod("getWindowShape", Window.class);
            setWindowOpaque = awtUtilitiesClass.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            isWindowOpaque = awtUtilitiesClass.getMethod("isWindowOpaque", Window.class);
            isTranslucencyCapable = awtUtilitiesClass.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            isSupported = true;
        }
        catch (Exception e) {
            isSupported = false;
        }
    }
}

