/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.timer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AnimationTimer {
    private final Timer fTimer;
    private AnimationTarget fAnimationTarget;
    private long fAnimationStartTime;
    private long fDuration;

    public AnimationTimer() {
        this(FrameRate.FPS_25);
    }

    public AnimationTimer(FrameRate fps) {
        this.fTimer = new Timer(fps.delay(), new TimerActionListener());
    }

    public void setDuration(long duration) {
        this.fDuration = duration;
    }

    public void start() {
        if (!this.fTimer.isRunning()) {
            if (this.fAnimationTarget == null) {
                throw new IllegalStateException("Animation target is not set!");
            }
            this.fAnimationStartTime = System.nanoTime() / 1000000L;
            Runnable r = new Runnable(){

                public void run() {
                    AnimationTimer.this.fAnimationTarget.begin(AnimationTimer.this);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
            this.fTimer.start();
        }
    }

    public void stop() {
        if (this.fTimer.isRunning()) {
            this.fTimer.stop();
            Runnable r = new Runnable(){

                public void run() {
                    AnimationTimer.this.fAnimationTarget.end(AnimationTimer.this);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public void setAnimationTarget(AnimationTarget target) {
        this.fAnimationTarget = target;
    }

    public static interface AnimationTarget {
        public void begin(AnimationTimer var1);

        public void event(AnimationTimer var1, float var2);

        public void end(AnimationTimer var1);
    }

    private class TimerActionListener
    implements ActionListener {
        private TimerActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            long currentAnimationTime = System.nanoTime() / 1000000L;
            long totalTime = currentAnimationTime - AnimationTimer.this.fAnimationStartTime;
            if (totalTime > AnimationTimer.this.fDuration) {
                AnimationTimer.this.fAnimationStartTime = totalTime;
            }
            float fraction = (float)totalTime / (float)AnimationTimer.this.fDuration;
            if ((fraction = Math.min(1.0f, fraction)) == 1.0f) {
                AnimationTimer.this.stop();
            } else {
                AnimationTimer.this.fAnimationTarget.event(AnimationTimer.this, fraction);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrameRate {
        FPS_15(66),
        FPS_20(50),
        FPS_25(40),
        FPS_30(33),
        FPS_40(25),
        FPS_50(20);

        private final int fDelay;

        private FrameRate(int delay) {
            this.fDelay = delay;
        }

        public int delay() {
            return this.fDelay;
        }
    }
}

