/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.overlay;

import ch.swingfx.twinkle.style.overlay.AbstractOverlay;
import ch.swingfx.twinkle.style.overlay.IOverlay;
import ch.swingfx.twinkle.style.overlay.NullOverlay;
import ch.swingfx.twinkle.style.overlay.OverlayPaintMode;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;

public class GradientOverlay
extends AbstractOverlay {
    private final Color fStartColor;
    private final Color fEndColor;

    public GradientOverlay(Color startColor, Color endColor, OverlayPaintMode paintMode) {
        this(startColor, endColor, paintMode, new NullOverlay());
    }

    public GradientOverlay(Color startColor, Color endColor, OverlayPaintMode paintMode, IOverlay decorator) {
        super(paintMode, decorator);
        this.fStartColor = startColor;
        this.fEndColor = endColor;
    }

    private void paintGradient(Graphics g, int cornerRadius) {
        Graphics2D copy = (Graphics2D)g.create();
        copy.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape clip = g.getClip();
        GradientPaint mask = new GradientPaint(0.0f, 0.0f, this.fStartColor, 0.0f, clip.getBounds().height, this.fEndColor);
        copy.setPaint(mask);
        if (cornerRadius == 0) {
            copy.fill(clip);
        } else {
            copy.fill(new RoundRectangle2D.Double(0.0, 0.0, clip.getBounds().getWidth(), clip.getBounds().getHeight(), cornerRadius, cornerRadius));
        }
        copy.dispose();
    }

    public void paintMouseOver(Graphics g, int cornerRadius) {
        this.paintGradient(g, cornerRadius);
    }

    public void paintMouseOut(Graphics g, int cornerRadius) {
        this.paintGradient(g, cornerRadius);
    }
}

